;;; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;
;;;     			     ANSIL
;;; 		      Advanced Network Simulator In Lisp
;;; 		      ----------------------------------
;;;
;;;				  Written By
;;;			       Peter J. Angeline
;;;			      Gregory M. Saunders
;;;
;;;			   The Ohio State University
;;;		       Laboratory for AI Research (LAIR)
;;;			     Columbus, Ohio, 43210
;;;
;;;			      Copyright (c) 1991
;;;
;;; ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;---------------------------------------------------------------------------
;;;                                                                         
;;;                            Filename: compile.lisp
;;;                            Author: Peter J Angeline
;;;
;;; Comments: This file is created to compile the ANSIL system.
;;;
;;;---------------------------------------------------------------------------

;; variables
(defvar *ansil-path*)
(defvar *fasl-extension*)

;; the path name for the RAAM Code system.
(setf *ansil-path* "/n/nervous/1/ansil/source/")

;; the file extension for the compiled versions of the lisp files.
(setf *fasl-extension* ".fasl")

;; the list of files to compile.
(setf file-list '("random" "matrixbp" "raam1" "raam2"))

#+allegro (setf file-list (cons "clinear" file-list))
#-allegro (setf file-list (cons "linear" file-list))

(defun compile-load (x)
  (print (concatenate 'string "  Compiling file " *ansil-path* x ".lisp ..."))
  (compile-file (concatenate 'string *ansil-path* x ".lisp"))
  (load (concatenate 'string *ansil-path* x *fasl-extension*)))

(print "Compiling the RAAM Code System...")

;; compiles C routines which are called by the fcl specific code.
#+allegro (run-shell-command 
	   (concatenate 'string "cc "
			*ansil-path* 
			"linear-lib.c -c -lm -o "
			*ansil-path*
			"linear-lib.o"))

(mapc #'compile-load file-list)

(print "Compilation Complete")

;; package stuff
(in-package 'user)
(use-package 'mbp)
(use-package 'mraam)
