;; Xor, just to show how to set up a simple network...
;; This converges in anything from 200 to 500 epochs depending on what kind of
;; initial conditions you get.  It's much faster if you use a rate of 5.0 or
;; randomize the initial weights to be distributed within -0.9 to 0.9 rather
;; than the default -0.5 to 0.5.

(use-package 'mbp)

(setf xor (create-network 2 2 1))
(set-network xor :rate 1.0 :momentum 0.7 :sp-add 0.1)
(add-pattern xor '(1 1) '(0))
(add-pattern xor '(1 0) '(1))
(add-pattern xor '(0 1) '(1))
(add-pattern xor '(0 0) '(0))

(network-train xor :display 20)
