;; Implementation of Jordan Pollacks example from his RAAM paper in the AI
;; Journal. Expect this raam to take about 1000 epochs to converge depending on
;; the initial conditions.

(use-package 'mbp)
(use-package 'mraam)
(setf raam (create-raam :nil-value nil
	    :trees '( (d n)
		      (d (a (a (a n))))
		      (d (a n))
		      ((d n) (p (d n)))
		      (v (p (d n)))
		      (v (d (a n)))
		      (v (d n))
		      (p (d n))
		      (p (d (a n)))
		      (a n)
		      (a (a n))
		      (a (a (a n)))
		      ((d n) v)
		      ((d n) (v (d (a n))))
		      ((d (a n)) (v (p (d n)))) )
	    :random-weights t :valence 2 :rep-width 10 :adjust? t))

(set-terminal raam 'd '(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0))
(set-terminal raam 'v '(0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 0.0))
(set-terminal raam 'p '(0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0))
(set-terminal raam 'n '(0.0 0.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0))
(set-terminal raam 'a '(0.0 0.0 0.0 0.0 0.0 1.0 0.0 0.0 0.0 0.0))

(raam-train raam :display 10 :reconstruct 10)

