;; This is the 4-3-4 shift register from the paper.  We have expanded the code
;; to allow for the raam representation width to differ from the terminal
;; representation width.  We have not been able to get this stack to converge
;; with the terminal test, but it will converge without it at the rate and
;; momentum settings given.  Expect this to take about 500 epochs.

(use-package 'mbp)
(use-package 'mraam)

(setf raam
      (create-stack :rep-width 3 :terminal-width 1 :random-weights t
		    :trees '((0 0 0) (0 0 1) (0 1 0) (0 1 1)
			     (1 0 0) (1 0 1) (1 1 0) (1 1 1))
		    :rate 0.5 :momentum 0.25))

(set-terminal raam '0 '(0.0))
(set-terminal raam '1 '(1.0))

(raam-train raam :display 10 :terminal-test nil)
