;; Implementation of Jordan Pollack's sentences example from his raam paper
;; appearing in the AI Journal.  Expect this raam to take at least 2000 epochs
;; to converge. 
(use-package 'mbp)
(use-package 'mraam)
(setf raam
      (create-raam
       :trees '( (loved pat mary)
		 (loved john pat)
		 ((with saw telescope) john (on man hill))
		 ((with ate chopsticks) mary spaghetti)
		 (ate mary (with spaghetti meat))
		 (ate pat meat)
		 (knew pat (loved john mary))
		 (thought pat (knew john (loved mary john)))
		 (hoped pat (thought john (ate mary spaghetti)))
		 ((with hit (mod telescope long)) john man)
		 (hit john (with man (mod telescope long)))
		 (hoped pat (saw (with man telescope) pat))
		 (hit pat (is man (thought man (loved mary john))))
		 (saw (is (mod man short) (thought man (saw man john))) pat) )
	    :valence 3 :rep-width 16 :adjust? t))

(set-terminal raam 'hill       '(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'street     '(1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'telescope  '(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'chopsticks '(1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'meat       '(1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'spaghetti  '(1 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'man        '(0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'john       '(0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'mary       '(0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'pat        '(0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0))
(set-terminal raam 'mod        '(0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0))
(set-terminal raam 'with       '(0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0))
(set-terminal raam 'on         '(0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0))
(set-terminal raam 'long       '(0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0))
(set-terminal raam 'short      '(0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0))
(set-terminal raam 'is         '(0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0))
(set-terminal raam 'knew       '(0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 1))
(set-terminal raam 'hoped      '(0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0))
(set-terminal raam 'thought    '(0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 1))
(set-terminal raam 'loved      '(0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0))
(set-terminal raam 'hit        '(0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1))
(set-terminal raam 'ate        '(0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0))
(set-terminal raam 'saw        '(0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1))

(raam-train raam :display 10 :reconstruct 10)


