/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "aspirin_bp.h"
#include "BpDatafile.h"
#include "BpConverge.h"
#include "BpIo.h"


/* command structure */
typedef struct uicommand {
  char *name;                       /* label */
  char *help;                       /* more info */
  int (*f)();                       /* function ptr (return non-zero to terminate session) */
  struct uicommand *next;           /* list */
} UICOMMAND;


/* context structure */
typedef struct uicontext {
  char *name;                       /* label */
  char *data;                       /* generic ptr to hang stuff */
  struct uicontext *subcontexts;    /* children */
  struct uicontext *supercontext;   /* parent */
  struct uicontext *next;           /* sibling */
  UICOMMAND *commands;              /* list of commands */
} UICONTEXT;

/* info for black boxes */
typedef struct bb_info {
  int bb, l, c, type;
} BB_INFO;
#define BB_BOX 0
#define BB_LAYER 1
#define BB_LAYER_INPUT_CONNECTION 2
#define BB_TARGETS 3
#define BB_INPUTS 4


/* for pipes */

/* data type */
#define P_FLOAT 0
#define P_COMPLEX 1

/* data format */
#define P_ASCII 0
#define P_BINARY 1

#define P_NODES 0
#define P_BIASES 1
#define P_CONNECTION_WEIGHTS 2
#define P_TARGETS 3
#define P_INPUTS 4
#define P_AR1 5
#define P_AR2 6

typedef struct uipipe {
  int type;
  char *name;
  char *command;
  FILE *stream;
  BB_INFO *info;
  int x,y,header,format;
  float *data;
  int data_xdim, data_ydim;
  struct uipipe *next;
} UIPIPE;


/* sizes */
#define MAX_COMMAND_SIZE 32
#define MAX_INPUT_SIZE 256
#define MAX_CONTEXT_SIZE 64
#define MAX_FILENAME_SIZE 128
#define MAX_STREAMS 10

