/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
 
#include <stdio.h>

#include "ui.h"

#define BANNER "\n\nWelcome to the MIGRAINES user interface.\n"

/* global */

UICONTEXT *current_context;

static char ui_input_buffer[MAX_INPUT_SIZE]; /* user's commands */

VFPTR ui_input_generator;


/* local */
static int current_stream = 0;
static FILE *stream_stack[MAX_STREAMS];
static UICONTEXT *root_context;





char *uiextract_word(to, i, from)
     char *to, *from;
     int i;
{
  /* strip intial white space and tabs */
  while (*from == ' ' || *from == '\t') from++;

  /* eos */
  if (*from == 0 ) return(NULL); /* no good */
  
  do {
    char *to_ptr = to;
    
    while ( *from != ' ') {
      *to_ptr++ = *from++;
      if (*(from - 1) == 0) break; /* eos */
    }/* end while */
    *to_ptr = 0; /* eos */

    /* strip white space and tabs */
    while (*from == ' ' || *from == '\t') from++;
    
    i--;

  }while (*(from-1) != 0 && i);

  if (i)
    return(NULL); /* didn't find it ! */
  else
    return(from);
}

void uiadd_command(c, s, h, f)
     UICONTEXT *c;
     char *s, *h;
     int (*f)();
{
  UICOMMAND *new_command;

  new_command = (UICOMMAND *)am_alloc_mem( sizeof(UICOMMAND) );
  new_command->name = s;
  new_command->help = h;
  new_command->f = f;
  new_command->next = c->commands;

  /* push */
  c->commands = new_command;

}


static int uihelp(buffer)
     char *buffer;
{
  
  /* print global commands */
  {
    UICOMMAND *c = root_context->commands;
    
    printf("\nGlobal commands:");
    while (c != NULL) {
      printf("\n\t%s %s", c->name, c->help);
      c = c->next;
    }/* end while */
  }
  
  /* print context commands */
  if (current_context != root_context)  {
    UICOMMAND *c = current_context->commands;
    
    printf("\nCurrent context commands:");
    while (c != NULL) {
      printf("\n\t%s %s", c->name, c->help);
      c = c->next;
    }/* end while */
  }
  
  /* print context commands */
  {
    UICONTEXT *c = current_context->subcontexts;
    
    if (c != NULL) {
      printf("\n\nSubcontexts:");
      do {
	printf("\n\t%s", c->name);
	c = c->next;
      }while (c != NULL);
    }/* end if */
  }
  
  return(1);
}


static int uiecho(buffer)
     char *buffer;
{
  /* find end of echo command */
  while (*buffer != 'o') buffer++;

  printf("\n%s", buffer+1);
  return(1);
}

static int uisystem(buffer)
     char *buffer;
{
  /* find end of system command */
  while (*buffer != '!') buffer++;

  am_system(buffer+1);
  return(1);
}

static int uisource(buffer)
     char *buffer;
{
  FILE *stream;
  char file_name[MAX_FILENAME_SIZE];
    
  if ( uiextract_word(file_name, 2, buffer) == NULL ) /*prob */
    return(1);

  if (current_stream + 1 == MAX_STREAMS) {
    fprintf(stderr, "\nsource: too many open files!\n");
    return(1);
  }/* end if */
  
  /* open the file */
  stream = am_fopen(file_name, "r");
  if (stream == NULL) {
    am_perror("\nsource: cannot open file!\n");
    return(1);
  }

  /* push */
  current_stream++;
  stream_stack[current_stream] = stream;

  return(1);
}

static int uicopyright(buffer)
     char *buffer;
{
  printf(MITRE_COPYRIGHT);
  return(1);
}

static int uiemail(buffer)
     char *buffer;
{
  printf("\nSend questions, comments or bug reports to: %s", EMAIL);
  return(1);
}

static int uiquit(buffer)
     char *buffer;
{
  return(0);
}

static int uipush(buffer)
     char *buffer;
{
  if (current_context->subcontexts != NULL) {
    char context_name[MAX_CONTEXT_SIZE];
    
    if ( uiextract_word(context_name, 2, buffer) == NULL ) /*prob */
      return(1);
    
    /* search for name */
    {
      UICONTEXT *c = current_context->subcontexts;
      
      while (c != NULL) {
	if (! strcmp(c->name, context_name) ) {
	  current_context = c;
	  return(1);
	}/* end if */
	c = c->next;
      }/* end while */
    }
    
    printf("\nUnknown context: %s", context_name);
    
  } 
    
  printf("\nNo subcontexts!");
  return(1);
}

static int uipop(buffer)
     char *buffer;
{
  /* up */
  if (current_context->supercontext != NULL)
    current_context = current_context->supercontext;
  return(1);
}

static int uipoproot(buffer)
     char *buffer;
{
  /* up to root */
  current_context = root_context;
  return(1);
}

static int uiload_network(buffer)
     char *buffer;
{
  extern void network_load(); /* from the generated sim file */
  extern void update_pipes(); /* from nn_pipe.c */
  char file_name[MAX_FILENAME_SIZE];
    
  if ( uiextract_word(file_name, 2, buffer) == NULL ) { /*prob */
    fprintf(stderr, "\nload: No file name supplied!\n");
    return(1);
  }/* fi */
    
  network_load(file_name);

  update_pipes(P_CONNECTION_WEIGHTS);
  update_pipes(P_BIASES);

  return(1);
}

static int uicycle(buffer)
     char *buffer;
{
  extern void network_forward();   /* from the generated sim file */
  extern void update_pipes(); /* from nn_pipe.c */
  int it;
  char input[32];

  if ( uiextract_word(input, 2, buffer) == NULL )
    return(1);

  if ( sscanf(input, "%d", &it) != 1) {
    printf("\n\tUnable to read iterations!");
    return (1);
  }
  
  if (it < 0) {
    printf("\n\tIteration count must be greater than 0!");
    return(1);
  }

  /* forward */
  while (it--) {
    network_forward(1, ui_input_generator);
    update_pipes(P_NODES);
    update_pipes(P_TARGETS);
    update_pipes(P_INPUTS);
  }

  return(1);
}

static void uiinit()
{
  extern void build_tst_context();      /* nn_tst.c */
  extern void build_bb_context();       /* nn_bb.c */
  extern int pipe_info(),
             pipe_header(),
             pipe_noheader(),
             pipe_verbose(),
             pipe_silent(),
             pipe_format_ascii(),
             pipe_format_binary(),
             pipe_open_nodes(),
             pipe_open_biases(),
             pipe_open_ar1(),
             pipe_open_ar2(),
             pipe_open_targets(),
             pipe_open_inputs(),
             pipe_open_weights(),
             pipe_close();              /* nn_pipe.c */

  /* set current input stream */
  *stream_stack = stdin;

  /* build root context */
  root_context = current_context = (UICONTEXT *)am_alloc_mem(sizeof(UICONTEXT));
  current_context->name = "MIGRAINES";
  current_context->data = NULL;
  current_context->subcontexts = NULL;
  current_context->supercontext = NULL;
  current_context->next = NULL;
  current_context->commands = NULL;

  /* commands */
  uiadd_command(root_context, "?", "(this message)", uihelp);
  uiadd_command(root_context, "quit", "(quit MIGRAINES)", uiquit);
  uiadd_command(root_context, "echo", " (<string> prints string)", uiecho);
  uiadd_command(root_context, "!", " (<string> executes system call)", uisystem);
  uiadd_command(root_context, "source", " (<filename> evaluates commands in file)", uisource);
  uiadd_command(root_context, "poproot", "(go to root context)", uipoproot);
  uiadd_command(root_context, "pop", "(up context)", uipop);
  uiadd_command(root_context, "push", "(<context> down context)", uipush);
  uiadd_command(root_context, "load", "(<filename> load neural network weight file)", uiload_network);
  if (ui_input_generator != NULL)
    uiadd_command(root_context, "cycle", "(<iterations> present inputs/targets to network)", uicycle);
  uiadd_command(root_context, "popenNodes",
		"<pipe name> <commands> (open a Unix pipe to accept node value vector)",
		pipe_open_nodes);
  uiadd_command(root_context, "popenBiases",
		"<pipe name> <commands> (open a Unix pipe to accept node bias vector)",
		pipe_open_biases);
  uiadd_command(root_context, "popenAr1",
		"<pipe name> <commands> (open a Unix pipe to accept ar1 vector)",
		pipe_open_ar1);
  uiadd_command(root_context, "popenAr2",
		"<pipe name> <commands> (open a Unix pipe to accept ar2 vector)",
		pipe_open_ar2);
  uiadd_command(root_context, "popenTargets",
		"<pipe name> <commands> (open a Unix pipe to accept output target vector)",
		pipe_open_targets);
  uiadd_command(root_context, "popenInputs",
		"<pipe name> <commands> (open a Unix pipe to accept input vector)",
		pipe_open_inputs);
  uiadd_command(root_context, "popenWeights",
		"<x node index> <y node index> <pipe name> <commands> (open a Unix pipe to accept weight vector)",
		pipe_open_weights);
  uiadd_command(root_context, "pclose", "<pipe name> (close a Unix pipe)", pipe_close);
  uiadd_command(root_context, "pinfo", "(Info on pipes)", pipe_info);
  uiadd_command(root_context, "pheader", "(Use header on pipe data)", pipe_header);
  uiadd_command(root_context, "pnoheader", "(Do not use header on pipe data)", pipe_noheader);
  uiadd_command(root_context, "pascii", "(Output pipe data in ascii)", pipe_format_ascii);
  uiadd_command(root_context, "pbinary", "(Output pipe data in binary)", pipe_format_binary);
  uiadd_command(root_context, "psilent", "(Disable messages to stderr)", pipe_silent);
  uiadd_command(root_context, "pverbose", "(Enable messages to stderr)", pipe_verbose);
  uiadd_command(root_context, "email", "(where to send questions or bug reports)", uiemail);
  uiadd_command(root_context, "copyright", "(print copyright)", uicopyright);

  /* build subcontexts */
  build_bb_context(root_context);
  build_tst_context(root_context);

}

static void uiprompt()
{
  printf("\n%s%% ", current_context->name);
}

static int uiexecute_command(s)
     char *s;
{
  /* check global commands */
  {
    UICOMMAND *c = root_context->commands;

    while (c != NULL) {
      if ( ! strcmp(c->name, s) ) return ( c->f(ui_input_buffer) );
      c = c->next;
    }/* end while */
  }
  
  /* check context commands */
  {
    UICOMMAND *c = current_context->commands;

    while (c != NULL) {
      if ( ! strcmp(c->name, s) ) return ( c->f(ui_input_buffer) );
      c = c->next;
    }/* end while */
  }

  /* nogo */
  printf("\nUnknown command: %s.", s);
  return(1);
}



static int uiparse()
{
  char *iptr;
  char input[MAX_COMMAND_SIZE];

  /* read line */
  readline :
  iptr = fgets(ui_input_buffer, MAX_INPUT_SIZE, stream_stack[current_stream]);

  /* pop stream? */
  if ( feof(stream_stack[current_stream]) ) {
    am_fclose(stream_stack[current_stream]);
    current_stream--;
  }/* end if eof */

  /* null? */
  if (iptr == NULL) goto readline ;

  /* check for comments ... skip line */
  if (*ui_input_buffer == '#') goto readline;

  /* discard carrage return */
  {
    char *ptr=ui_input_buffer;

    while(*ptr != '\n' && *ptr != 0) ptr++;

    *ptr = 0; /* eos */
  }


  /* extract 1st word */
  if ( uiextract_word(input, 1, ui_input_buffer) == NULL ) return(1);

  /* parse commands */
  return ( uiexecute_command(input) );
}

void nn_ui_loop(prog, generator)
     char *prog;
     VFPTR generator;
{
  ui_input_generator = generator;

  /* initialize */
  uiinit();

  printf(BANNER);
  printf(BASIC_COPYRIGHT);

  printf("\nType ? for help.\nType quit to end this session.\n");

  /* loop... */
  do {
    uiprompt();
  }while ( uiparse() );
  
}


