/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include <stdio.h>

#include "ui.h"


/* NOTE: This file assumes that Create_Test_List(network_query)
   has been called.
*/

/* extern */
extern UICONTEXT *current_context;
extern char *uiextract_word();

/* local */
static float tst_bound = 0.1;
static int tst_iterations = 100;

static int tst_print(buffer)
     char *buffer;
{
  
  printf("\n\tBound: %f Iterations: %d", tst_bound, tst_iterations);
  return(1);
}

static int tst_set_bound(buffer)
     char *buffer;
{
  float bound;
  char input[32];

  if ( uiextract_word(input, 2, buffer) == NULL )
    return(1);

  if ( sscanf(input, "%f", &bound) != 1) {
    printf("\n\tUnable to read bound!");
    return (1);
  } 

  if (bound <= 0) {
    printf("\n\tError bound must be greater than 0!");
    return(1);
  }

  tst_bound = bound;
  
  return(1);
}

static int tst_set_it(buffer)
     char *buffer;
{
  int it;
  char input[32];

  if ( uiextract_word(input, 2, buffer) == NULL )
    return(1);

  if ( sscanf(input, "%d", &it) != 1) {
    printf("\n\tUnable to read iterations!");
    return (1);
  }
  
  if (it < 0) {
    printf("\n\tIteration count must be greater than 0!");
    return(1);
  }

  tst_iterations = it;

  return(1);
}

static int tst_go(buffer)
     char *buffer;
{
  extern void network_forward();   /* from the generated sim file */
  extern VFPTR ui_input_generator; /* from nn_ui_loop.c */
  extern void update_pipes(); /* from nn_pipe.c */
  int i = tst_iterations;

  printf("\n\tTesting %d patterns...", tst_iterations);

  do {
    /* forward */
    network_forward(1, ui_input_generator);
    if ( Max_Absolute_Error() > tst_bound )  break;
  }while (--i);

  if (!i)
    printf("\n\tSuccess, %d patterns passed with %f error bound!",
	   tst_iterations, tst_bound);
  else {
    extern void generator1(); /* from libBpDatafile.a */
    extern DATAPTR data;      /* from libBpDatafile.a */

    if ( (VFPTR)ui_input_generator == (VFPTR)generator1) /* from a df file */
	printf("\n\tPattern %d (%d in %s) exceeded a %f error bound.",
	       tst_iterations - i,
	       data->current_datafile->current_pattern,
	       data->current_datafile->filename,
	       tst_bound);
      else
	printf("\n\tPattern %d exceeded a %f error bound.",
	       tst_iterations - i, tst_bound);
  }/* end else */

  update_pipes(P_NODES);
  update_pipes(P_TARGETS);
  update_pipes(P_INPUTS);

  return(1);
}

void build_tst_context(parent)
     UICONTEXT *parent;
{
  extern VFPTR ui_input_generator;
  extern void uiadd_command();
  UICONTEXT *tst_context;

  if (ui_input_generator == NULL ) return; /* no data */

  tst_context = (UICONTEXT *)am_alloc_mem(sizeof(UICONTEXT));
  tst_context->name = "TestingContext";
  tst_context->data = NULL;
  tst_context->subcontexts = NULL;
  tst_context->supercontext = parent;
  tst_context->next = parent->subcontexts;
  tst_context->commands = NULL;

  /* commands */
  uiadd_command(tst_context, "SetBound", "<bound> (set error bound)", tst_set_bound);
  uiadd_command(tst_context, "SetIterations", "<it> (set iterations)", tst_set_it);
  uiadd_command(tst_context, "StartTesting", "(run)", tst_go);
  uiadd_command(tst_context, "Info", "", tst_print);


  /* push */
  parent->subcontexts = tst_context;
  
}
