/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include <stdio.h>

#include "ui.h"


/* extern */
extern UICONTEXT *current_context;
extern char *uiextract_word();



static char *uimake_cstring(to,from,delay)
     char *to,*from;
     int delay;
{
  char *s;
  
  if (delay) {
    s = am_alloc_mem( strlen(to) + strlen(from) + 1 + 2 + ((int)AM_LOG10((double)delay+1)) );
    sprintf(s, "%s->%s[%d]", from, to, delay);
  } else {
    s = am_alloc_mem( strlen(to) + strlen(from) + 1 + 2);
    sprintf(s, "%s->%s", from, to);
  }
  
  return(s);
}


static int connection_info(buffer)
     char *buffer;
{
  int bb, l, c;
  int type, xdim, ydim, xoffset, yoffset, delay;
  BB_INFO *bb_info;

  bb_info = (BB_INFO *)current_context->data;

  bb = bb_info->bb;
  l = bb_info->l;
  c = bb_info->c;

  printf("\n\tConnection: %s", current_context->name);

  BPbb_connection_dim(bb, l, c, &type, &xdim, &ydim, &xoffset, &yoffset);

  switch(type) {

  case NXM_CONNECTION_TYPE :
    printf("\n\t\tFull connection");
    printf("\n\t\tSize: %d x %d", xdim, ydim);
    break;

  case TESS_1D_CONNECTION_TYPE :
    printf("\n\t\tOne dimensional tessellated connection");
    printf("\n\t\tSize: %d", xdim);
    if ( xoffset ) printf("\n\t\tOffset: %d", xoffset);
    break;

  case TESS_2D_CONNECTION_TYPE :
    printf("\n\t\tTwo dimensional tessellated connection");
    printf("\n\t\tSize: %d x %d", xdim, ydim);
    if (xoffset) printf("\n\t\tXoffset: %d", xoffset);
    if (yoffset) printf("\n\t\tYoffset: %d", yoffset);
    break;

  }

  if ( delay = BPbb_connection_delay(bb, l, c) )
    printf("\n\t\tConnected at %d delay", delay);

  return(1);
}

static void build_connection_context(bb, l, parent)
     int bb, l;
     UICONTEXT *parent;
{
  extern void uiadd_command();
  UICONTEXT *c_context;
  int ncs;
  
  ncs = BPn_layer_inputs(bb,l);
  
  while(ncs--) {
    
    c_context = (UICONTEXT *)am_alloc_mem(sizeof(UICONTEXT));
    c_context->name = uimake_cstring(parent->name,
				     BPbb_connection_from_name(bb, l, ncs),
				     BPbb_connection_delay(bb, l, ncs) );
    
    {
      BB_INFO *bb_info;
      
      bb_info = (BB_INFO *)am_alloc_mem(sizeof(BB_INFO));
      bb_info->bb = bb;
      bb_info->l = l;
      bb_info->c = ncs;
      bb_info->type = BB_LAYER_INPUT_CONNECTION;
      c_context->data = (char *)bb_info;
    }
    
    c_context->subcontexts = NULL;
    c_context->supercontext = parent;
    c_context->next = parent->subcontexts;
    c_context->commands = NULL;
    
    /* commands */
    uiadd_command(c_context, "Info", "", connection_info);
    
    /* push */
    parent->subcontexts = c_context;
    
  }/* end while */
}

static int layer_info(buffer)
     char *buffer;
{
  int bb, l, xdim, ydim;
  BB_INFO *bb_info;

  bb_info = (BB_INFO *)current_context->data;

  bb = bb_info->bb;
  l = bb_info->l;

  printf("\n\tLayer: %s", current_context->name);

  BPbb_layer_dim(bb, l, &xdim, &ydim);
  printf("\n\t\tSize: %d x %d", xdim, ydim);

  { /* ar layer? */
    int lorder;

    lorder = BPbb_layer_order(bb, l);

    if (lorder)
      printf("\n\t\tAutoregressive order: %d", lorder);
  }

  return(1);
}


static void build_layer_context(bb, parent)
     int bb;
     UICONTEXT *parent;
{
  extern void uiadd_command();
  UICONTEXT *l_context;
  int nls;

  nls = BPn_bb_layers(bb);

  while(nls--) {
    
    l_context = (UICONTEXT *)am_alloc_mem(sizeof(UICONTEXT));
    l_context->name = BPbb_layer_name(bb, nls);

    {
      BB_INFO *bb_info;
      
      bb_info = (BB_INFO *)am_alloc_mem(sizeof(BB_INFO));
      bb_info->bb = bb;
      bb_info->l = nls;
      bb_info->c = 0;
      bb_info->type = BB_LAYER;
      l_context->data = (char *)bb_info;
    }

    l_context->subcontexts = NULL;
    l_context->supercontext = parent;
    l_context->next = parent->subcontexts;
    l_context->commands = NULL;
    
    /* commands */
    uiadd_command(l_context, "Info", "", layer_info);
    
    /* push */
    parent->subcontexts = l_context;

    /* subcontexts */
    build_connection_context(bb, nls, l_context);

  }/* end while */
}



static int target_info(buffer)
     char *buffer;
{
  int bb, l, xdim, ydim;
  BB_INFO *bb_info;

  bb_info = (BB_INFO *)current_context->data;

  bb = bb_info->bb;
  l = bb_info->l;

  printf("\n\tTarget Outputs:");

  BPbb_layer_dim(bb, l, &xdim, &ydim);
  printf("\n\t\tSize: %d x %d", xdim, ydim);

  return(1);
}


static void build_target_context(bb, parent)
     int bb;
     UICONTEXT *parent;
{
  extern VFPTR ui_input_generator;
  extern void uiadd_command();
  UICONTEXT *target_context;

  if ( BPbb_efferent(bb) && ui_input_generator != NULL ) { /* if bb is efferent && there is input data! */
    
    target_context = (UICONTEXT *)am_alloc_mem(sizeof(UICONTEXT));
    target_context->name = "Targets";

    {
      BB_INFO *bb_info;
      
      bb_info = (BB_INFO *)am_alloc_mem(sizeof(BB_INFO));
      bb_info->bb = bb;
      bb_info->l = BPbb_output_layer_index(bb);
      bb_info->c = 0;
      bb_info->type = BB_TARGETS;
      target_context->data = (char *)bb_info;
    }

    target_context->subcontexts = NULL;
    target_context->supercontext = parent;
    target_context->next = parent->subcontexts;
    target_context->commands = NULL;
    
    /* commands */
    uiadd_command(target_context, "Info", "", target_info);
    
    /* push */
    parent->subcontexts = target_context;

  }/* end if  */
}


static int input_info(buffer)
     char *buffer;
{
  int bb, xdim, ydim;
  BB_INFO *bb_info;

  bb_info = (BB_INFO *)current_context->data;

  bb = bb_info->bb;

  printf("\n\t$INPUTS");

  BPbb_input_dim(bb, &xdim, &ydim);
  printf("\n\t\tSize: %d x %d", xdim, ydim);

  return(1);
}


static void build_input_context(bb, parent)
     int bb;
     UICONTEXT *parent;
{
  extern void uiadd_command();
  UICONTEXT *input_context;

  if ( BPbb_input_size(bb) ) { /* if there are $INPUTS */
    
    input_context = (UICONTEXT *)am_alloc_mem(sizeof(UICONTEXT));
    input_context->name = "$INPUTS";

    {
      BB_INFO *bb_info;
      
      bb_info = (BB_INFO *)am_alloc_mem(sizeof(BB_INFO));
      bb_info->bb = bb;
      bb_info->l = 0;
      bb_info->c = 0;
      bb_info->type = BB_INPUTS;
      input_context->data = (char *)bb_info;
    }

    input_context->subcontexts = NULL;
    input_context->supercontext = parent;
    input_context->next = parent->subcontexts;
    input_context->commands = NULL;
    
    /* commands */
    uiadd_command(input_context, "Info", "", input_info);
    
    /* push */
    parent->subcontexts = input_context;

  }/* end if  */
}

static int bb_info(buffer)
     char *buffer;
{
  int bb, input_xdim, input_ydim;
  BB_INFO *bb_info;

  bb_info = (BB_INFO *)current_context->data;

  bb = bb_info->bb;

  printf("\n\tBlack Box: %s", current_context->name);


  if ( BPbb_dynamic(bb) )
    printf("\n\t\tDynamic (can learn)");
  else
    printf("\n\t\tStatic (cannot learn)");


  if ( BPbb_efferent(bb) )
    printf("\n\t\tEfferent (has target outputs)");

  BPbb_input_dim(bb, &input_xdim, &input_ydim);
  if (input_xdim * input_ydim)
    printf("\n\t\tInput Size: %d x %d", input_xdim, input_ydim);

  printf("\n\t\t%d Layers", BPn_bb_layers(bb));

  return(1);
}

void build_bb_context(parent)
     UICONTEXT *parent;
{
  extern void uiadd_command();
  UICONTEXT *bb_context;
  int nbbs;

  nbbs = BPn_bbs();

  while(nbbs--) {
    
    bb_context = (UICONTEXT *)am_alloc_mem(sizeof(UICONTEXT));
    bb_context->name = BPbb_name(nbbs);
    
    {
      BB_INFO *bb_info;
      
      bb_info = (BB_INFO *)am_alloc_mem(sizeof(BB_INFO));
      bb_info->bb = nbbs;
      bb_info->l = bb_info->c = 0;
      bb_info->type = BB_BOX;
      bb_context->data = (char *)bb_info;
    }

    bb_context->subcontexts = NULL;
    bb_context->supercontext = parent;
    bb_context->next = parent->subcontexts;
    bb_context->commands = NULL;
    
    /* commands */
    uiadd_command(bb_context, "Info", "", bb_info);
    
    /* push */
    parent->subcontexts = bb_context;

    /* subcontexts */
    build_layer_context(nbbs, bb_context);
    build_input_context(nbbs, bb_context);
    build_target_context(nbbs, bb_context);
    
  }/* end while */
  
}
