/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
/* filter translates AM data files to gnuplot files */

#include <stdio.h>

extern char *malloc();

static int xdim, ydim, ascii;
static float *d;

/* this was ripped out of am_mem.c */
static char *am_alloc_mem(length)
     unsigned int length; /* number of bytes */
{
  char *results = NULL;
#define PADDING 0  
  /* printf("\n%d bytes.", length); */
  
  if (length) { /* don't call with 0!!! */
    
    results = (char *)malloc( length + (PADDING * sizeof(float)) );
    if (results == (char *)NULL) {
      fprintf(stderr,
	      "Error: cannot allocate %d bytes of memory!\n", length);
      exit(1);
    }  /* if */
    
  } else {
    fprintf(stderr,
	    "Warning: _alloc_mem called with 0 bytes argument. Returning NULL.\n");
  }/* end if */


  /* align ? */
#ifdef ALIGN
  {
    unsigned int align;

    align = ( ((unsigned int)results) + ALIGN )/ALIGN;
    results  = (char *) ( align * ALIGN );
  }
#endif
  
  return(results);
}/* end am_alloc_mem */

static int read_am_stream(prog)
     char *prog;
{
  char format_string[64];
  char data_type_string[64];
  
  /* read header */
  if ( scanf("%s %s %d %d\n",
	     format_string,
	     data_type_string,
	     &xdim, &ydim) != 4) {
    return(0);
  }/* end if */
  
  /* how to read */
  if ( !strcmp(format_string, "ascii") )
    ascii = 1;
  else if ( !strcmp(format_string, "binary") )
    ascii = 0;
  else {
    fprintf(stderr, "\n%s: Illegal data format - %s!\n", prog, format_string);
    return(0);
  }
  
  /* only float supported */
  if ( strcmp(data_type_string, "float") ) {
    fprintf(stderr, "\n%s: Error - only type float supported!\n", prog);
    return(0);
  }
  
  
  /* make some space... */
  d = (float *)am_alloc_mem(xdim*ydim*sizeof(float));

  /* fill... */
  if (ascii) {
    float *ptr=d;
    int n;
    
    n=xdim*ydim;
    while(n--)
      if ( scanf("%f", ptr++) != 1 ) {
	fprintf(stderr, "\n%s: Error reading ascii input!\n", prog);
	return(0);
      }
  } else {
    int n;
    
    n=xdim*ydim;
    if ( fread(d, sizeof(float), n, stdin) != n ) {
      fprintf(stderr, "\n%s: Error reading binary input!\n", prog);
      return(0);
    }
  }
  
}

static void write_gnuplot_stream()
{

  if (ydim == 1) { /* one column */

    while(xdim--) printf("%f\n", *d++);

  } else { /* coords */
    int x,y;

    for (x=0;x<xdim; x++) {
      for (y=0;y<ydim; y++) {
	printf("%d %d %f\n", x, y, *d++);
      }
      printf("\n");
    }
  }

  fflush(stdout);

}




main(argc, argv)
     int argc;
     char **argv;
{

  if (argc-1) {
    /* arguments? */
    if (argc != 2 || strcmp(argv[1], "-s") ) {
      fprintf(stderr, "\n%s: Unknown flag.\nUsage: %s [-s], where -s is silent mode.\n",
	      *argv, *argv);
      exit(1);
    }
  } else 
    fprintf(stderr, "\nTranslating am file to Gnuplot 3.0 format.\n");

  while ( read_am_stream(*argv) )  write_gnuplot_stream();

}
