/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
/* type1 file reader: Type1 files are floating point files of data patterns,
                      one after another. It is assumed that the size and
		      dimensions of these patterns correspond to the size
		      and dimensions of the input to ALL black boxes.
		      The target vector MUST BE specified in the .df file.
 */

#include "BpDatafile.h"

void _type1_reader(file_descriptor, datafile, data)
     int file_descriptor;                 /* open file */
     DATAFILEPTR datafile;                /* this file */
     DATAPTR data;                        /* root structure */
{
  register int counter;
  int file_nfloats, file_nbytes;
  int npatterns, input_size = (data->inputs_xdim * data->inputs_ydim);
  float *data_block;


  /* check to see if user specified a target vector */
  if (datafile->self) { /* using input as target */
    if (input_size != (data->targets_xdim * data->targets_ydim)) {
      fprintf(stderr,"\nError: Input size is not the same as output size!\n");
      return;
    }/* end if */
  } else if (datafile->user_target == (float *)NULL ) {
    fprintf(stderr,"\nType1 files require a target vector in the .df file!\n");
    return;
  }/* end if */

  /* get size of the file */
  file_nbytes = am_file_size(datafile->filename);
  file_nfloats = ((int)file_nbytes)/sizeof(float);  /* # floats in file */

  /* derive the number of patterns */
  if (datafile->scroll_step) { /* if scrolling */
    npatterns = datafile->npatterns = 1;
    if (datafile->switch_cycle < 0)
      datafile->switch_cycle = (file_nfloats / input_size)/datafile->scroll_step; /* (switch: all) */
    datafile->size = file_nfloats;
  } else { /* not scrolling */
    if (file_nfloats % input_size != 0) { /* error check */
      fprintf(stderr,"\n%s has NON integral number of patterns!\n",
	      datafile->filename);
      return;
    }/* end if */
    npatterns = datafile->npatterns = file_nfloats / input_size;
    if (datafile->switch_cycle < 0) datafile->switch_cycle = npatterns; /* (switch: all) */
    datafile->size = input_size;
  }/* end else */

  datafile->xdim = data->inputs_xdim;
  datafile->ydim = data->inputs_ydim;

  /* make pointer vectors */
  datafile->inputs = (float **)am_alloc_mem(npatterns * sizeof(float *));
  datafile->targets = (float **)am_alloc_mem(npatterns * sizeof(float *));

  /* read the file into an array of the same size */
  data_block = (float *)am_alloc_mem((int)file_nbytes);

  am_read(file_descriptor, (char *)data_block, (int)file_nbytes);

  /* update pointers into the inputs array */
  if (datafile->self) 
    for (counter=0; counter<npatterns; counter++) {
      datafile->inputs[counter] = data_block + (counter * input_size);
      datafile->targets[counter] = datafile->inputs[counter];
    }/* end for */
  else 
    for (counter=0; counter<npatterns; counter++) {
      datafile->inputs[counter] = data_block + (counter * input_size);
      datafile->targets[counter] = datafile->user_target;
    }/* end for */

}/* end _type1_reader */
