/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
/* reads a datafile and updates structures */
#include <stdio.h>
#include "BpDatafile.h"

void _readfile(datafile, data)
     DATAFILEPTR datafile;        /* this file */
     DATAPTR data;                /* root structure */
{
  extern void _ascii_reader();
  extern void _type1_reader();
  extern void _type2_reader();
  extern void _type3_reader();
  extern void _type4_reader();
  extern void _type5_reader();
  extern void _matlab_reader();
  int fd;

  /* open datafile */
  fd = am_open(datafile->filename);
  if (fd < 0) {
    fprintf(stderr,"\nUnable to open %s.\n",datafile->filename);
    am_perror("ReadFile");
  }/* end if */

  switch(datafile->type) {
  case ASCII_FILE : {
    _ascii_reader(fd, datafile, data);
    break;
  }/* end case */
  case TYPE1_FILE : {
    _type1_reader(fd, datafile, data);
    break;
  }/* end case */
  case TYPE2_FILE : {
    _type2_reader(fd, datafile, data);
    break;
  }/* end case */
  case TYPE3_FILE : {
    _type3_reader(fd, datafile, data);
    break;
  }/* end case */
  case TYPE4_FILE : {
    _type4_reader(fd, datafile, data);
    break;
  }/* end case */
  case TYPE5_FILE : {
    _type5_reader(fd, datafile, data);
    break;
  }/* end case */
  case MATLAB_FILE : {
    _matlab_reader(fd, datafile, data);
    break;
  }/* end case */
    default : {
      fprintf(stderr, "\nUnknown file type: %d (readfile.c)\n",
	      datafile->type);
    }/* end default */
  }/* end switch */

  /* close */
  am_close(fd);
}/* end _readfile */
