/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "BpDatafile.h"

/*
 *   NormalRandom()    --  Uses the Box-Jenkins technique
 */
static int NRswitch = 0;
static float NR_u1, NR_u2;
static float NormalRandom(mean, variance)
     float mean, variance;
{
  if (NRswitch == 0) {
    while((NR_u1 = AM_RANDOM()) == 0.0);
    while((NR_u2 = AM_RANDOM()) == 0.0);
    NRswitch = 1;
    return( mean + sqrt((double)(-2.0 * log((double)NR_u1) * variance)) * cos((double)(2.0 * AM_PI * NR_u2)) );
  } else {
    NRswitch = 0;
    return( mean + sqrt((double)(-2.0 * log((double)NR_u1) * variance)) * sin((double)(2.0 * AM_PI * NR_u2)) );
  }
}  /* end NormalRandom() */

static float UniformRandom(mean, variance)
     float mean, variance;
{
  return(mean + (variance * 2.0  * (AM_RANDOM() - 0.5)));
}  /* UniformRandom() */


float *_add_uniform_noise(from_ptr, to_ptr, mean, variance,n, scroll_step, scroll_index)
     float *from_ptr, *to_ptr, mean, variance;
     int n,scroll_step,scroll_index;
{
  
  if (scroll_step && scroll_step < n) {

    /* points to be copied backwards (scrolled) */
    n -= scroll_step; /* last point */
    while (n--) {
      to_ptr[n + scroll_step] = to_ptr[n];
    }/* end while */

    /* add in new points plus noise */
    bcopy((char *)(from_ptr + scroll_index), (char *)to_ptr, scroll_step * sizeof(float));
    while(scroll_step--)
      to_ptr[scroll_step] += UniformRandom(mean,variance);

  } else {/* just copy & add noise */
    register float *ptr = to_ptr;

    bcopy((char *)(from_ptr + scroll_index), (char *)to_ptr, n * sizeof(float));
    while(n--) *ptr++ += UniformRandom(mean,variance);
  }/* end else */

  return(to_ptr);
}/* end _add_uniform_noise */

float *_add_normal_noise(from_ptr, to_ptr, mean, variance,n,scroll_step,scroll_index)
     float *from_ptr, *to_ptr, mean, variance;
     int n, scroll_step,scroll_index;
{

  if (scroll_step && scroll_step < n) {

    /* points to be copied backwards (scrolled) */
    n -= scroll_step; /* last point */
    while (n--) {
      to_ptr[n + scroll_step] = to_ptr[n];
    }/* end while */

    /* add in new points plus noise */
    bcopy((char *)(from_ptr + scroll_index), (char *)to_ptr, scroll_step * sizeof(float));
    while(scroll_step--)
      to_ptr[scroll_step] += NormalRandom(mean,variance);

  } else {/* just copy & add noise */
    register float *ptr = to_ptr;

    bcopy((char *)(from_ptr + scroll_index), (char *)to_ptr, n * sizeof(float));
    while(n--) *ptr++ +=  NormalRandom(mean,variance);
  }/* end else */

  return(to_ptr);
}/* end _add_normal_noise */


float *_no_noise(from_ptr, to_ptr, mean, variance,n,scroll_step,scroll_index)
     float *from_ptr, *to_ptr, mean, variance;
     int n, scroll_step, scroll_index;
{
  if (scroll_step && scroll_step < n) {
      /* points to be copied backwards (scrolled) */
      n -= scroll_step; /* last point */
      while (n--) {
	to_ptr[n + scroll_step] = to_ptr[n];
      }/* end while */
      
      /* add in new points */
      bcopy((char *)(from_ptr + scroll_index), (char *)to_ptr, scroll_step * sizeof(float));
      
      return(to_ptr);
  } else {
    return(from_ptr + scroll_index);   /* noop */
  }/* end if else */
}/* end _no_noise */
