/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
/* matlab file reader: This reads a matlab file (assumes this is 1 pattern)
 */

#include <stdio.h>
#include "BpDatafile.h"

/* header for MATLAB files */
typedef struct {
  long int type;
  long int mrows;
  long int ncols;
  long int imagf;
  long int namlen;
} mathead;

#define COL_MAJOR 0
#define ROW_MAJOR 1
#define DOUBLE 0
#define SINGLE 1
#define INTEGER 2
#define SHORT 3
#define USHORT 4
#define MATRIX 0
#define ASCII 1

void _matlab_reader(file_descriptor, datafile, data)
     int file_descriptor;                 /* open file */
     DATAFILEPTR datafile;                /* this file */
     DATAPTR data;                        /* root structure */
{
  register int counter1, counter2;
  mathead header;
  float *data_block;
  long int M, O, P, T;
  int mrows, ncols;
  int xdim = data->inputs_xdim;
  int ydim = data->inputs_ydim;
  
  /* check to see if user specified a target vector */
  if (datafile->self) { /* using input as target */
    if ( (data->inputs_xdim * data->inputs_ydim )
	!= (data->targets_xdim * data->targets_ydim)) {
      fprintf(stderr,"\nError: Input size is not the same as output size!\n");
      return;
    }/* end if */
  } else if (datafile->user_target == (float *)NULL ) {
    fprintf(stderr,"\nType1 files require a target vector in the .df file!\n");
    return;
  }/* end if */
  
  /* get size of the file and read header */
  am_read(file_descriptor, &header, sizeof(mathead));
  
  if (datafile->user_label == (char *)NULL) {
    datafile->user_label = (char *)am_alloc_mem(header.namlen);
    am_read(file_descriptor, datafile->user_label, header.namlen * sizeof(char));
  } else { /* strip off string */
    char byte;
    
    for(counter1=0;counter1<header.namlen;counter1++)
      am_read(file_descriptor, &byte, sizeof(char));
  }
  
  /* here we check the type */
  M = header.type / 1000;
  O = (header.type / 100) - (M * 10) ;
  P = (header.type / 10) - (M * 100) - (O * 10) ;
  T =  header.type - (M * 1000) - (O * 100) - (P * 10);
  
  if (T != MATRIX) {
    fprintf(stderr, "\nCannot process NON-matrix matlab files!\n");
    return;
  }/* end if */
  
  
  mrows = header.mrows;
  ncols = header.ncols;
  
  
  switch(O) {
    
  case COL_MAJOR :
    
    /* vectors are a special case */
    if (mrows == 1 && ydim == 1) { /* switch */
      mrows = ncols; ncols =1;
    } else if (ydim < ncols) {     /* check size */
      fprintf(stderr,"\n%s's column count(%d) is not less than input height(%d)!\n",
	      datafile->filename,
	      ncols,
	      ydim);
      return;
    }/* end else if */
    break;
    
  case ROW_MAJOR :
    
    /* vectors are a special case */
    if (ncols == 1 && xdim == 1) { /* switch */
      ncols = mrows; mrows =1;
    } else if (ydim < mrows) { /* check size */
      fprintf(stderr,"\n%s's row count(%d) is not less than input height(%d)!\n",
	      datafile->filename,
	      mrows,
	      ydim);
      return;
    }/* end else if */
    
    break;
    
    default : {
      fprintf(stderr, "\nBad O field in matlab file header\n");
      return;
    }/* end default */
    
  }/* end switch */
  
  
  datafile->size = mrows * ncols;  
  datafile->xdim = ncols;
  datafile->ydim = mrows;
  datafile->npatterns = 1; /* 1 pattern per matlab file */
  if (datafile->switch_cycle < 0)
    if (datafile->scroll_step)
      datafile->switch_cycle = (datafile->size/(xdim * ydim))/datafile->scroll_step;
    else
      datafile->switch_cycle = 1;
  
  
  /* make pointer vectors */
  datafile->inputs = (float **)am_alloc_mem(sizeof(float *));
  datafile->targets = (float **)am_alloc_mem(sizeof(float *));
  
  /* read the file into an array of the same size */
  data_block = (float *)am_alloc_mem(datafile->size * sizeof(float));
  
  /* read in 1 pattern (convert to proper format) */
  switch (P) {
    
  case DOUBLE : {
    register double *buffer;
    
    if (O == COL_MAJOR) {

      /* get buffer */
      buffer = (double *)am_alloc_mem(mrows * sizeof(double));

      /* read */
      for(counter2=0;counter2<ncols;counter2++){
	double *dword=buffer;
	am_read(file_descriptor, buffer, mrows * sizeof(double));
	for(counter1=0;counter1<mrows;counter1++){
	  *(data_block + (ydim * counter1) + counter2)
	    = (float)*dword++; /* convert to single */
	}/* end for */
	/* pad remaining values */
	for(counter1=mrows;counter1<ydim;counter1++){
	  *(data_block + (ydim * counter1) + counter2) = 0.0;
	}/* end for */
      }/* end for counter2 */
      /* pad remaining values */
      for(counter2=ncols;counter2<ydim;counter2++){
	for(counter1=0;counter1<xdim;counter1++){
	  *(data_block + counter1 + (counter2 * ydim)) = 0.0;
	}/* end for */
      }/* end for */

      /* free */
      am_free_mem(buffer);
      
    } else {

      /* get buffer */
      buffer = (double *)am_alloc_mem(ncols * sizeof(double));

      /* read */
      for(counter2=0;counter2<mrows;counter2++){
	double *dword=buffer;
	am_read(file_descriptor, buffer, ncols * sizeof(double));
	for(counter1=0;counter1<ncols;counter1++){
	  *(data_block + counter1 + (xdim * counter2))
	    = (float)*dword++; /* convert to single */
	}/* end for */
	/* pad remaining values */
	for(counter1=ncols;counter1<ydim;counter1++){
	  *(data_block + counter1 + (counter2 * xdim)) = 0.0;
	}/* end for */
      }/* end for counter2 */
      /* pad remaining values */
      for(counter2=ncols;counter2<xdim;counter2++){
	for(counter1=0;counter1<ydim;counter1++){
	  *(data_block + (xdim * counter1) + counter2) = 0.0;
	}/* end for */
      }/* end for */

      /* free */
      am_free_mem(buffer);
      
    }/* end if else */
    
    break;
  }
    
  case SINGLE : {
    register float *buffer;
    
    if (O == COL_MAJOR) {

      /* get buffer */
      buffer = (float *)am_alloc_mem(mrows * sizeof(float));

      /* read */
      for(counter2=0;counter2<ncols;counter2++){
	float *fword=buffer;
	am_read(file_descriptor, buffer, mrows * sizeof(float));
	for(counter1=0;counter1<mrows;counter1++){
	  *(data_block + (ydim * counter1) + counter2)
	    = (float)*fword++; /* convert to single */
	}/* end for */
	/* pad remaining values */
	for(counter1=mrows;counter1<ydim;counter1++){
	  *(data_block + (ydim * counter1) + counter2) = 0.0;
	}/* end for */
      }/* end for counter2 */
      /* pad remaining values */
      for(counter2=ncols;counter2<ydim;counter2++){
	for(counter1=0;counter1<xdim;counter1++){
	  *(data_block + counter1 + (counter2 * ydim)) = 0.0;
	}/* end for */
      }/* end for */

      /* free */
      am_free_mem(buffer);

    } else {

      /* get buffer */
      buffer = (float *)am_alloc_mem(ncols * sizeof(double));

      /* read */
      for(counter2=0;counter2<mrows;counter2++){
	float *fword=buffer;
	am_read(file_descriptor, buffer, ncols * sizeof(float));
	for(counter1=0;counter1<ncols;counter1++){
	  *(data_block + counter1 + (xdim * counter2))
	    = (float)*fword++; /* convert to single */
	}/* end for */
	/* pad remaining values */
	for(counter1=ncols;counter1<ydim;counter1++){
	  *(data_block + counter1 + (counter2 * xdim)) = 0.0;
	}/* end for */
      }/* end for counter2 */
      /* pad remaining values */
      for(counter2=ncols;counter2<xdim;counter2++){
	for(counter1=0;counter1<ydim;counter1++){
	  *(data_block + (xdim * counter1) + counter2) = 0.0;
	}/* end for */
      }/* end for */

      /* free */
      am_free_mem(buffer);

    }/* end if else */
    
    break;
  }
    
  case SHORT : {
    register short *buffer;
    
    if (O == COL_MAJOR) {

      /* get buffer */
      buffer = (short *)am_alloc_mem(mrows * sizeof(short));

      /* read */
      for(counter2=0;counter2<ncols;counter2++){
	short *sword=buffer;
	am_read(file_descriptor, buffer, mrows * sizeof(short));
	for(counter1=0;counter1<mrows;counter1++){
	  *(data_block + (ydim * counter1) + counter2)
	    = (float)*sword++; /* convert to single */
	}/* end for */
	/* pad remaining values */
	for(counter1=mrows;counter1<ydim;counter1++){
	  *(data_block + (ydim * counter1) + counter2) = 0.0;
	}/* end for */
      }/* end for counter2 */
      /* pad remaining values */
      for(counter2=ncols;counter2<ydim;counter2++){
	for(counter1=0;counter1<xdim;counter1++){
	  *(data_block + counter1 + (counter2 * ydim)) = 0.0;
	}/* end for */
      }/* end for */

      /* free */
      am_free_mem(buffer);
      
    } else {

      /* get buffer */
      buffer = (short *)am_alloc_mem(ncols * sizeof(short));

      /* read */
      for(counter2=0;counter2<mrows;counter2++){
	short *sword=buffer;
	am_read(file_descriptor, buffer, ncols * sizeof(short));
	for(counter1=0;counter1<ncols;counter1++){
	  *(data_block + counter1 + (xdim * counter2))
	    = (float)*sword++; /* convert to single */
	}/* end for */
	/* pad remaining values */
	for(counter1=ncols;counter1<ydim;counter1++){
	  *(data_block + counter1 + (counter2 * xdim)) = 0.0;
	}/* end for */
      }/* end for counter2 */
      /* pad remaining values */
      for(counter2=ncols;counter2<xdim;counter2++){
	for(counter1=0;counter1<ydim;counter1++){
	  *(data_block + (xdim * counter1) + counter2) = 0.0;
	}/* end for */
      }/* end for */
      
      /* free */
      am_free_mem(buffer);

    }/* end if else */
    
    break;
  }
  case USHORT : {
    register unsigned short *buffer;
    
    if (O == COL_MAJOR) {

      /* get buffer */
      buffer = (unsigned short *)am_alloc_mem(mrows * sizeof(unsigned short));

      /* read */
      for(counter2=0;counter2<ncols;counter2++){
	unsigned short *usword=buffer;
	am_read(file_descriptor, buffer, mrows * sizeof(unsigned short));
	for(counter1=0;counter1<mrows;counter1++){
	  *(data_block + (ydim * counter1) + counter2)
	    = (float)*usword++; /* convert to single */
	}/* end for */
	/* pad remaining values */
	for(counter1=mrows;counter1<ydim;counter1++){
	  *(data_block + (ydim * counter1) + counter2) = 0.0;
	}/* end for */
      }/* end for counter2 */
      /* pad remaining values */
      for(counter2=ncols;counter2<ydim;counter2++){
	for(counter1=0;counter1<xdim;counter1++){
	  *(data_block + counter1 + (counter2 * ydim)) = 0.0;
	}/* end for */
      }/* end for */

      /* free */
      am_free_mem(buffer);

    } else {

      /* get buffer */
      buffer = (unsigned short *)am_alloc_mem(ncols * sizeof(unsigned short));

      /* read */
      for(counter2=0;counter2<mrows;counter2++){
	unsigned short *usword=buffer;
	am_read(file_descriptor, buffer, ncols * sizeof(unsigned short));
	for(counter1=0;counter1<ncols;counter1++){
	  *(data_block + counter1 + (xdim * counter2))
	    = (float)*usword++; /* convert to single */
	}/* end for */
	/* pad remaining values */
	for(counter1=ncols;counter1<ydim;counter1++){
	  *(data_block + counter1 + (counter2 * xdim)) = 0.0;
	}/* end for */
      }/* end for counter2 */
      /* pad remaining values */
      for(counter2=ncols;counter2<xdim;counter2++){
	for(counter1=0;counter1<ydim;counter1++){
	  *(data_block + (xdim * counter1) + counter2) = 0.0;
	}/* end for */
      }/* end for */

      /* free */
      am_free_mem(buffer);

    }/* end if else */
    
    break;
  }
    default : {
      fprintf(stderr, "\nUnknown matlab data numeric type.\n");
      return;
    }
    
  }/* end switch */
  
  /* update pointers into the inputs array */
  datafile->inputs[0] = data_block;
  if (datafile->self)
    datafile->targets[0] = data_block;
  else
    datafile->targets[0] = datafile->user_target;
  
}/* end _matlab_reader */

