/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "BpDatafile.h"
#include "globals.h"

/* these globals keep track of user generators */
int n_user_generators = 0;
USER_GENERATOR user_generators[MAX_USER_GENERATORS];        /* from BpDatafile.h */
static int file_counter = 0 , user_counter = 0, toggle = 0;

/* update_black_boxes: Sets the input and targets for each black box. */
static void update_black_boxes(datafile)
     DATAFILEPTR datafile;
{
  int index = datafile->current_pattern;
  FUNCTIONSPTR bbfncts = data->setfunctions;
  float *current_inputs, *current_targets;

  
  /* get the data (possibly add noise and scroll) */
  {
    register int nscroll = 0;
    
    /* if scrolling then you might need to clip */
    if (datafile->scroll_step) {
      if (datafile->scroll_step > datafile->size - datafile->scroll_index )
	nscroll = datafile->size - datafile->scroll_index;
      else
	nscroll = datafile->scroll_step;
    }/* end if */
    
    current_inputs = (data->noise)((datafile->inputs)[index],
				   data->input_buffer,
				   data->mean,
				   data->variance,
				   data->inputs_size,
				   nscroll,
				   datafile->scroll_index);
  }/* end block */

  current_targets = (datafile->targets)[index];

  /* for every black box ... */
  while(bbfncts != (FUNCTIONSPTR)NULL) {

    /* set the targets? */
    if (bbfncts->set_target_output != (VFPTR)NULL) {
      (bbfncts->set_target_output)(current_targets);
    }/* end if */

    /* set the inputs? */
    if (bbfncts->set_input != (VFPTR)NULL) {
      (bbfncts->set_input)(current_inputs);
    }/* end if */

    bbfncts = bbfncts->next;
  }/* end while */

}/* end update_black_boxes */



/* file_generator: Sets the input and target outputs of all
                   the black boxes. This is meant to be used
                   in the menus of the graphics, which scrolls
		   thru the menu items (datafile generators or patterns).
 */
void file_generator(datafile)
     DATAFILEPTR datafile;
{
  extern void network_clear_delays();

  /* goto next pattern... */
  if (datafile->scroll_step) {/* if scrolling...*/

      if (datafile->scroll_index == datafile->scroll_step /* new pattern? */
	  && datafile->clear_delays) {/* clear delays? */
	network_clear_delays();
	/* clear my own buffers */
	if (data->input_buffer != (float *)NULL)
	  bzero((char *)data->input_buffer, data->inputs_size * sizeof(float));
      }/* end if */

      /* update black boxes by setting input and target output */
      update_black_boxes(datafile);

      /* shift */
      datafile->scroll_index += datafile->scroll_step;

      /* done scrolling this pattern? */
      if (datafile->scroll_index >= datafile->size) {
	datafile->scroll_index = datafile->scroll_step; /* reset */
	/* next (only if generator) */
	if (datafile->genORpatterns == 0)
	  datafile->current_pattern = (datafile->current_pattern +  1) % datafile->npatterns;
      }/* end if */

  } else { /* no scrolling */

    /* clear delays? ("network_clear_delays" is in the generated file) */
    if (datafile->clear_delays) network_clear_delays();

    /* update black boxes by setting input and target output */
    update_black_boxes(datafile);

    /* next (only if generator) */
    if (datafile->genORpatterns == 0)
      datafile->current_pattern = (datafile->current_pattern +  1) % datafile->npatterns;

  }/* end else */

}/* end file_generator */


/* datafile_generator: Sets the input and target outputs of all
                       the black boxes. This is meant to be used
                       WITHOUT graphics.
 */
void datafile_generator(datafile)
     DATAFILEPTR datafile;
{
  extern void network_clear_delays();
 
    if (datafile->scroll_step) {/* if scrolling...*/
      
      if (datafile->scroll_index == datafile->scroll_step /* new pattern? */
	  && datafile->clear_delays) {/* clear delays? */
	network_clear_delays();
	/* clear my own buffers */
	if (data->input_buffer != (float *)NULL)
	  bzero((char *)data->input_buffer, data->inputs_size * sizeof(float));
      }/* end if */


      /* update black boxes by setting input and target output */
      update_black_boxes(datafile);

      /* shift */
      datafile->scroll_index +=  datafile->scroll_step;

      /* done scrolling this pattern? */
      if (datafile->scroll_index >= datafile->size) {
	datafile->scroll_index = datafile->scroll_step; /* reset */
	/* get the next file */
	 data->next_datafile();
      } else { /* interupt? */
	if (!(datafile->scroll_index % datafile->switch_cycle))
	  data->next_datafile();
      }/* end else */

  } else { /* no scrolling...*/
    
   /* clear delays? ("network_clear_delays" is in the generated file) */
    if (datafile->clear_delays)  network_clear_delays();

    /* update black boxes by setting input and target output */
    update_black_boxes(datafile);

    /* next */
    datafile->current_pattern = (datafile->current_pattern + 1) % datafile->npatterns;
 
    /* get the next file */
    if (!(datafile->current_pattern % datafile->switch_cycle))
      data->next_datafile();
  }/* end if */

}/* end datafile_generator */



/* epoch_length:  Calc how many iterations to go 1 pass thru generators */
int epoch_length()
{
  DATAFILEPTR datafile = data->current_datafile, first_datafile;
  int iterations = 0;

  
  first_datafile = datafile;
  do {
    register int patterns = datafile->npatterns;

      if (datafile->scroll_step) {

	/* number that perfectly fit...*/
	patterns *= datafile->size/datafile->scroll_step;
	/* if there is some left on the last pattern...*/
	if ( AM_FMOD(datafile->size , datafile->scroll_step) != 0.0)
	  patterns += 1;
      }/* end if */

    iterations += patterns;

    datafile = datafile->next;
  } while(datafile != first_datafile);

  return ( iterations );

}/* end epoch_length */


/*=================================================*
  define_generator  This adds a user's generator
  to the list.
  *=================================================*/
void define_generator(generator, item, string)
     VFPTR generator;
     char *item, *string;
{
  if (n_user_generators > MAX_USER_GENERATORS) {
    fprintf(stderr,"\nToo many generators declared!\n");
    exit(1);
  }/* end if */
  user_generators[n_user_generators].generator = generator;
  user_generators[n_user_generators].item = item;
  if (string == NULL)
    user_generators[n_user_generators++].string = "User Generator";
  else
    user_generators[n_user_generators++].string = string;
}/* end define_generator */

/*=================================================*
  generator1:         Calls the generators in a cycle.
  from only files.
  *=================================================*/
void generator1()
{
  datafile_generator( data->current_datafile );
  file_counter = (file_counter + 1) % data->n_datafiles;
}/* end generator1 */

/*=================================================*
  generator2:         Calls the generators in a cycle.
  from only user.
  *=================================================*/
void generator2()
{
  user_generators[user_counter].generator(user_generators[user_counter].item);
  user_counter = (user_counter + 1) % n_user_generators;
}/* end generator2 */

/*=================================================*
  generator3:         Calls the generators in a cycle.
  from both files and user.
  *=================================================*/
void generator3()
{
  if (toggle) {
    generator1();
    if (file_counter == 0) toggle = 1 - toggle;
  } else {
    generator2();
    if (user_counter == 0) toggle = 1 - toggle;
  }/* end else */
}/* end generator3 */


/*=================================================*
  set_generator:    Select a generator.
  *=================================================*/
VFPTR set_generator(verbose)
     int verbose;
{
  
  /* if we don't have a generator by now...barf! */
  if (n_user_generators == 0 && data == NULL) {
    if (verbose) {
      fprintf(stderr, "\nNo generators defined!");
      fprintf(stderr, "\nMaybe you need a .df file?");
    }/* end if */
    return(NULL);
  } else if (n_user_generators && data != NULL) { /* both */
    return(generator3);
  } else if (data != NULL) { /* only files */
    return(generator1);
  } else  { /* only user */
    return(generator2);
  }/* end else */
  
}/* end set_generator */
