/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include <stdio.h>
#include "BpDatafile.h"

/* noise functions */
extern float *_no_noise();
extern float *_add_normal_noise();
extern float *_add_uniform_noise();

/* file_init: Init structures, get sizes from network. */
DATAPTR _file_init(query_function, noise_type, mean, variance)
     LB_PTR (*query_function)();
     int noise_type;
     float mean, variance;
{
  BBB_PTR bbinfo;
  LB_PTR layer;
  DATAPTR data; /* root */
  register int bbindex = 0;

  /* create root data structure */
  data = (DATAPTR)am_alloc_mem(sizeof(DATA));

  /* set */
  data->inputs_xdim = 0;
  data->inputs_ydim = 0;
  data->targets_xdim = 0;
  data->targets_ydim = 0;
  data->setfunctions = (FUNCTIONSPTR)NULL;
  data->datafiles = (DATAFILEPTR)NULL;
  data->n_datafiles = 0;
  data->datafile_table = (DATAFILEPTR *)NULL;

  /* now update the dimensions, create list of setfunctions */
  while((layer = query_function(bbindex,0)) != (LB_PTR)NULL) {

    /* ask the network for black box information */
    bbinfo = &((query_function(bbindex,0))->black_box_info);

    /* get the output layer for target dimensions */
    layer = query_function(bbindex, bbinfo->output_layer_index);

    /* test to see if ALL black boxes have same input/target
       dimensions. */
    if (data->setfunctions != (FUNCTIONSPTR)NULL) { /* been set at least once */
      
      /* can i set the targets? */
      if (bbinfo->set_target_output != (VFPTR)NULL) { /* does this bb have targets? */
	if (data->targets_xdim != 0) {/* have the global target sizes been set ? */
	  /* cannot have different sized targets to use this */
	  if (data->targets_xdim != layer->xdim ||	  
	      data->targets_ydim != layer->ydim) {
	    fprintf(stderr,"\nError: Two black boxes have different target sizes.");
	    fprintf(stderr,
		    "\nYou should use your own generator in this case.\n");
	    exit(1);
	  }/* end if */
	}/* end if */
	else {
	  data->targets_xdim = layer->xdim;
	  data->targets_ydim = layer->ydim;
	}/* end else */
      }/* end if */
      
      /* can i set the inputs? */
      if (bbinfo->n_inputs != 0) { /* does this bb have inputs? */
	if (data->inputs_xdim != 0) { /* have the global input size been set? */
	  if (data->inputs_xdim != bbinfo->inputs_xdim ||
	      data->inputs_ydim != bbinfo->inputs_ydim) {
	    fprintf(stderr,"\nError: Two black boxes have different input sizes.");
	    fprintf(stderr,"\nYou should use your own generator in this case.\n");
	    exit(1);
	  }/* end if */
	}/* end if */
	else {
	  data->inputs_xdim = bbinfo->inputs_xdim;
	  data->inputs_ydim = bbinfo->inputs_ydim;
	}/* end else */
      }/* end if */
      
      /* update functions? */
      if (bbinfo->set_target_output != (VFPTR)NULL ||
	  bbinfo->n_inputs != 0) {
	FUNCTIONSPTR temp = data->setfunctions;
	
	/* add new function structure */
	data->setfunctions = (FUNCTIONSPTR)am_alloc_mem(sizeof(FUNCTIONS));
	data->setfunctions->set_target_output = bbinfo->set_target_output;
	data->setfunctions->set_input = bbinfo->set_input;
	
	data->setfunctions->next = temp;
      }/* end if */
      
      
    } else { /* never been set */

      /* can i set the targets? */
      if (bbinfo->set_target_output != (VFPTR)NULL) { 
	data->targets_xdim = layer->xdim;
	data->targets_ydim = layer->ydim;
      }/* end if */

      /* can i set the inputs? */
      if (bbinfo->n_inputs != 0) { 
        data->inputs_xdim = bbinfo->inputs_xdim;
	data->inputs_ydim = bbinfo->inputs_ydim;
      }/* end if */

      /* did i change anything? */
      if (data->inputs_xdim != 0 || data->targets_xdim != 0) {
	/* add new function structure */
	data->setfunctions = (FUNCTIONSPTR)am_alloc_mem(sizeof(FUNCTIONS));
	data->setfunctions->set_target_output = bbinfo->set_target_output;
	data->setfunctions->set_input = bbinfo->set_input;
	data->setfunctions->next = NULL;
      }/* end if */
      
    }/* end if else */

    bbindex++;
  }/* end while */


  /* noise info */
  data->inputs_size = data->inputs_xdim * data->inputs_ydim;
  data->mean = mean;
  data->variance = variance;
  switch (noise_type) {
  case NO_NOISE :
    data->noise = _no_noise;
    data->input_buffer = (float *)NULL;
    break;
  case NORMAL_NOISE :
    data->noise = _add_normal_noise;
    data->input_buffer = (float *)am_alloc_mem(data->inputs_size * sizeof(float)); 
    break;
  case UNIFORM_NOISE :
    data->noise = _add_uniform_noise;
    data->input_buffer = (float *)am_alloc_mem(data->inputs_size * sizeof(float)); 
    break;
  }/* end switch */


  return(data);
}/* end _file_init */
