/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

/*  A Bison parser, made from df.y  */

#define	NEWLINE	258
#define	NUMBER	259
#define	NAME	260
#define	LCP	261
#define	RCP	262
#define	RP	263
#define	LP	264
#define	READFILE	265
#define	USEFILE	266
#define	RANDOM_SWITCH	267
#define	ASCII	268
#define	MATLAB	269
#define	TYPE1	270
#define	TYPE2	271
#define	TYPE3	272
#define	TYPE4	273
#define	TYPE5	274
#define	LABEL	275
#define	GENERATOR	276
#define	PATTERNS	277
#define	TARGET	278
#define	SELF	279
#define	PATTERN_NAME	280
#define	SWITCH	281
#define	SCROLL	282
#define	XOFF	283
#define	XLENGTH	284
#define	YOFF	285
#define	YLENGTH	286
#define	RANGE	287
#define	NORMALIZE	288
#define	THRESHOLD	289
#define	SUBMEAN	290
#define	SCALE	291
#define	BIAS	292
#define	CLEAR_DELAYS	293
#define	SWAPBYTES	294
#define	MATH	295
#define	MATH_FUNCTION	296


#line 10 "df.y"
typedef union {
	int i;    /* integer */
	float f;  /* float */
	char *s;  /* string */
} YYSTYPE;
#line 17 "df.y"

#include "BpDatafile.h"
#include "globals.h"

extern DATAPTR _file_init(); /* initialize files */
extern void  _readfile();    /* read in a datafile */

#define TRUE 1
#define FALSE 0

/* input stream */
static FILE *df_stream;

/* input buffer */
static unsigned char yytext[256];
static int yyleng;

DATAPTR data = NULL; /* root */

static int error_code = 0;

#define TARGET_LENGTH 50
#define N_PATTERN_NAMES 30


/* globals */
static char *user_label = NULL; /* user supplied label */  
static int genORpatterns = 0;   /* use a generator or patterns */
static int menu_defaults = TRUE;/* use default menu style */
static int target_length = 0;   /* length of user's target vector */
static float target_vector[TARGET_LENGTH];
static int self = FALSE; /* if target is same as data */
static char *target_file = NULL; /* name of target file (type5) */
static int n_pattern_names = 0;   /* number of user's pattern names */
static int switch_cycle = 1; /* when to switch between files (after how many patterns) */
static int scroll_step = 0; /* scroll pattern? if so, how much */
static int xoffset =0,yoffset =0,xlength=0,ylength=0; /* for clipping data */
static float range = -1.0, bias = 0.0, scalar=1.0; /* for rescaling data */
static int normalize = 0; /* for normalizing data */
static int submean = 0; /* for normalizing data */
static float threshold; /* for preprocessing data */
static int clear_delays = FALSE; /* TRUE if clear delay buffers before using */
static USER_NAME pattern_names[N_PATTERN_NAMES];
static int random_switch = FALSE;
static int swapbytes= FALSE; /* in case the data is from a machine w/opposite byte order */
static int math=DF_MATH_NONE;       /* for doing math on data points */

/* used for error messages */
int lineno = 1; 
static char *datafile_name;




/*****************************************************/
/*****************************************************/
/*****************************************************/
/*******************    lex    ***********************/



char *newstr (name, length)
  char *name;
  int length;
{
 char *temp;

 temp = am_alloc_mem(length + 1);
 *(temp + length) = 0;
 bcopy(name, temp, length+1);
 return(temp);
}

static void read_token()
{
  unsigned int c;


  yyleng=0;
  /* skip spaces, tabs , quotes, and newlines  */
  while((c=getc(df_stream)) != ' '
	&& !(iscntrl(c))
	&& c != '"'
	&& c != '{'
	&& c != '}'
	&& c != '('
	&& c != ')'
	&& c != '#'
	&& c != ','
	&& c != EOF) {
    yytext[yyleng++] = c;
  }
  ungetc((unsigned char)c,df_stream);
  yytext[yyleng] = '\0';
}

static void read_quoted_token()
{
  unsigned int c;


  yyleng=0;
  /* end at quote */
  while((c=getc(df_stream)) != '"' && c != EOF) {
    yytext[yyleng++] = c;
  }
  yytext[yyleng] = '\0';
}

static int input_equals(str)
     register char *str;
{
  register int counter;
  register unsigned char *tptr = yytext;

  counter = yyleng;
  if (strlen(str) > counter) counter = strlen(str);
  while(counter--) if (*str++ != *tptr++) return FALSE;;
  return TRUE;

}

#define CONTEXT_STACK_DEPTH 16
#define NO_CONTEXT 0
#define READFILE_CONTEXT 1
#define USEFILE_CONTEXT 2
#define KEYWORD_CONTEXT 3
#define MATH_CONTEXT 4
static int context_stack[CONTEXT_STACK_DEPTH], *cstackptr = context_stack;

#define switch_lex_context(ctx) *cstackptr = ctx;

static void push_lex_context(new_context)
     int new_context;
{
  if (cstackptr == context_stack + CONTEXT_STACK_DEPTH)
    yyerror("\nLex context stack full! (push_lex_context)\n");
  cstackptr++; *cstackptr = new_context;
}

static void pop_lex_context()
{
  if (cstackptr == context_stack)
    yyerror("\nLex context stack would be empty! (pop_lex_context)\n");
  /* pop */
  cstackptr--;
}

static int this_context(context)
     int context;
{
  return( *cstackptr == context );
}




/*****************************************************/
/*****************************************************/
/*****************************************************/





yywrap(){return(1);}

/*****************************************************/
/* warning                                           */
/*        Print warning message.                     */
/*****************************************************/
static void warning(s, t)
     char *s, *t;
{
  fprintf(stderr, "\n%s: %s", datafile_name, s);
  if (t != (char *)NULL) fprintf(stderr, "  %s", t);
}

/*****************************************************/
/* yyerror                                           */
/*        Called by yacc for syntax errors.          */
/*****************************************************/
yyerror (s)
     char *s;
{ extern unsigned char yytext[];
  extern int yyleng;
  char where[50];

  *where = '\0'; /* empty */
  if (yytext != (unsigned char *)NULL)
    {  char *token = am_alloc_mem(yyleng + 1);

       bcopy(yytext, token, yyleng);
       token[yyleng] = '\0'; /* end of string */
       sprintf(where, "(near \"%s\" somewhere around line %d)\n", yytext, lineno);
       am_free_mem(token);
    }/* end if */

  warning(s, where);
  error_code = 1;
  
}/* end yyerror */

/*****************************************************/
/* update_target_vector: Add numbers to target vector. */
/*****************************************************/
static void update_target_vector(x)
     float x;
{
  if (target_length == TARGET_LENGTH) yyerror("\nTarget vector too long!");
  target_vector[target_length++] = x;
}/* end update_target_vector */

/*****************************************************/
/* update_name_vector: Add names to pattern vector. */
/*****************************************************/
static void update_name_vector(name,x)
     char *name;
     int x;
{
  if (n_pattern_names == N_PATTERN_NAMES) yyerror("\nToo many pattern names!");
  pattern_names[n_pattern_names].index = x;
  pattern_names[n_pattern_names++].name = name;
}/* end update_target_vector */


/*****************************************************/
/* create_datafile: create datafile structure.
/*****************************************************/
static create_datafile(filename, type)
     char *filename;
     int type;
{
  DATAFILEPTR new_datafile;

  /* make new structure */
  new_datafile = (DATAFILEPTR)am_alloc_mem(sizeof(DATAFILE));
  new_datafile->filename = filename;

  new_datafile->type = type;

  new_datafile->usefile = FALSE;

  new_datafile->next = (DATAFILEPTR)NULL;

  new_datafile->genORpatterns = genORpatterns;
  genORpatterns = 0; /* reset */

  
  if (scroll_step) { /* scrolling data? */
    if (data->inputs_ydim == 1) /* 1D */
      new_datafile->scroll_step = scroll_step;
    else /* 2D */
      new_datafile->scroll_step = scroll_step * data->inputs_xdim;
    new_datafile->scroll_index = new_datafile->scroll_step; /* where to begin */
    new_datafile->genORpatterns = 0; /* scroll overrrides */
    menu_defaults = FALSE; /* scroll overrides */
    scroll_step = 0; /* reset */
    /* make a buffer for the scrolling data (if necessary) */
    if (data->input_buffer == (float *)NULL) {
      data->input_buffer = (float *)am_alloc_mem(data->inputs_size * sizeof(float)); 
    }/* end if */
    bzero((char *)data->input_buffer, data->inputs_size * sizeof(float)); 
  } else {
    new_datafile->size = data->inputs_size;
    new_datafile->xdim = data->inputs_xdim;
    new_datafile->ydim = data->inputs_ydim;
    new_datafile->scroll_step = 0;
    new_datafile->scroll_index = 0;
  }/* end if else scroll_step */

  new_datafile->switch_cycle = switch_cycle;
  switch_cycle = 1; /* reset */

  new_datafile->xoffset = xoffset;
  xoffset = 0; /* reset */
  new_datafile->yoffset = yoffset;
  yoffset = 0; /* reset */
  new_datafile->xlength = xlength;
  xlength = 0; /* reset */
  new_datafile->ylength = ylength;
  ylength = 0; /* reset */

  new_datafile->range = range;
  range = -1.0; /* reset */
  new_datafile->bias = bias;
  bias = 0.0; /* reset */
  new_datafile->scalar = scalar;
  scalar = 1.0; /* reset */
  new_datafile->normalize = normalize;
  normalize = 0; /* reset */
  new_datafile->threshold = threshold;
  threshold = AM_HUGE_VAL; /* reset */
  new_datafile->submean = submean;
  submean = 0; /* reset */
  new_datafile->math= math;
  math = 0; /* reset */
  new_datafile->swapbytes= swapbytes;
  swapbytes = 0; /* reset */

  new_datafile->clear_delays = clear_delays;
  clear_delays = FALSE; /* reset */

  new_datafile->menu_defaults = menu_defaults;
  menu_defaults = TRUE; /* reset */
  new_datafile->current_pattern = 0;

  new_datafile->user_label = user_label;
  user_label = (char *)NULL; /* reset */
  
  if (target_length) {
    new_datafile->user_target = (float *)am_alloc_mem(target_length * sizeof(float));
    /* copy */
    bcopy((char *)target_vector,
	  (char *)new_datafile->user_target,
	  (target_length * sizeof(float)));
    /* reset */
    target_length = 0;
  } else 
    new_datafile->user_target = (float *)NULL;


  new_datafile->self = self; self = FALSE;   /* use inputs as targets? */

  /* set the target file (type5) */
  new_datafile->target_file = target_file; target_file = NULL;

  if (n_pattern_names) {
    new_datafile->n_user_names = n_pattern_names;
    new_datafile->user_names = (USER_NAME_PTR)am_alloc_mem(n_pattern_names * sizeof(USER_NAME));
    /* copy */
    bcopy((char *)pattern_names,
	  (char *)new_datafile->user_names,
	  (n_pattern_names * sizeof(USER_NAME)));
    /* reset */
    n_pattern_names = 0;
  } else  {
    new_datafile->n_user_names = 0;
    new_datafile->user_names = (USER_NAME_PTR)NULL;
  }/* end else if */

  new_datafile->inputs = (float **)NULL;
  new_datafile->targets = (float **)NULL;
  new_datafile->input_labels = (char **)NULL;
  new_datafile->target_labels = (char **)NULL;

  /* push into list */
  data->n_datafiles += 1;
  if (data->datafiles == (DATAFILEPTR)NULL) {
    data->datafiles = new_datafile;    
    new_datafile->next = (DATAFILEPTR)NULL;
  } else {
    DATAFILEPTR temp;
    temp = data->datafiles;
    data->datafiles = new_datafile;
    new_datafile->next = temp;
  }/* end else */

}/* end create_datafile */

/*****************************************************/
/* find_datafile: Search and return named file     */
/*****************************************************/
DATAFILEPTR find_datafile(name)
     char *name;
{
  DATAFILEPTR ptr;

  ptr = data->datafiles;
  while(ptr != (DATAFILEPTR)NULL) {
    if (! ptr->usefile && ! strcmp(ptr->filename, name))
      return ptr;
    else
      ptr = ptr->next;
  }

  yyerror("Undefined file name for UseFile!");

}/* end find_datafile */

/*****************************************************/
/* use_datafile:   Just referenced a file            */
/*****************************************************/
static void use_datafile(name)
     char *name;
{
  DATAFILEPTR referenced_datafile, new_datafile;

  /* find name in list */
  referenced_datafile = find_datafile(name);

  /* make new structure */
  new_datafile = (DATAFILEPTR)am_alloc_mem(sizeof(DATAFILE));

  new_datafile->filename = name;

  /* mark so it won't be read */
  new_datafile->usefile = TRUE;

  /* push into list */
  data->n_datafiles += 1;
  {
    DATAFILEPTR temp;
    temp = data->datafiles;
    data->datafiles = new_datafile;
    new_datafile->next = temp;
  }/* end block */

}/* end use_datafile */

/*****************************************************/
/* rescale_data                                      */
/*****************************************************/
static void rescale_data(data, range, scalar, bias, n)
     register float *data;
     float range, scalar, bias;
     register int n;
{
  /* range */
  if (range > 0.0) {
    double max_val = -AM_HUGE_VAL, min_val = AM_HUGE_VAL;
    register int s = n;
    register float *ptr=data;
    
    /* max, min */
    while(s--) {
      if (*ptr > max_val) max_val = *ptr;
      if (*ptr < min_val) min_val = *ptr;
      ptr++;
    }
    
    max_val -= min_val;
    
    if (max_val != 0.0) {
      s = n;
      ptr = data;
      bias += range * -0.5;
      while(s--) *ptr++ = (range * ((*ptr - min_val)/max_val));
    } else  bzero(data, n * sizeof(float));
    
  } 

  /* scale */
  if (scalar != 1.0) {
    register int s=n;
    register float *ptr=data;

    while(s--) *ptr++ *= scalar;
  }


  /* bias */
  if (bias != 0.0) {
    register int s=n;
    register float *ptr=data;
    
      while(s--) *ptr++ += bias;
  }


}/* end rescale_data */

/*****************************************************/
/* swapbytes_data                                    */
/*****************************************************/
static void swapbytes_data(vector,n)
     register float *vector;
     register int n;
{
  
  /* for each value */
  while(n--) {
    union {
	float f;
	char c[sizeof(float)];
    } newval,oldval;
    int sz = sizeof(float);

    /* swap */
    oldval.f = *vector;
    while(sz--) newval.c[sz] = oldval.c[ sizeof(float) - 1 - sz ];
    *vector++ = newval.f;

  }/* end while */

}/* end swapbytes_data */


/*****************************************************/
/* math_data                                         */
/*****************************************************/
static void math_data(function,vector,n)
     int function;
     register float *vector;
     register int n;
{
  switch (function) {

  case DF_MATH_FABS :
    while (n--) {
      float x;
      
      x = *vector;
      *vector++ = AM_FABS(x);
    }
    break;

  case DF_MATH_SQUARE :
    while (n--) {
      float x;
      
      x = *vector;
      *vector++ = x *x;
    }
    break;

  case DF_MATH_LOG10 :
    while (n--) {
      float x;
      
      x = *vector;
      *vector++ = AM_LOG10(x);
    }
    break;

  case DF_MATH_PSEUDO_LOG10 :
    while (n--) {
      float x;
      
      x = *vector + 1.0;
      *vector++ = AM_LOG10(x);
    }
    break;

  }/* end switch */
  
}/* end math_data */

/*****************************************************/
/* submean_data                                      */
/*****************************************************/
static void submean_data(vector,n)
     register float *vector;
     register int n;
{
  register int counter=n;
  float mean=0.0, *ptr=vector;
  
  /* calc mean */
  while(counter--) mean += *ptr++;
  mean /= n;

  /* submean */
  counter = n;
  while(counter--)  *vector++ -= mean;

}/* end submean_data */

/*****************************************************/
/* threshold_data                                     */
/*****************************************************/
static void threshold_data(t,vector,n)
     float t;
     register float *vector;
     register int n;
{

  while(n--) {
    if (*vector < t) *vector = 0.0;
    vector++;
  }

}/* end threshold_data */

/*****************************************************/
/* normalize_data                                    */
/*****************************************************/
static void normalize_data(vector,n)
     register float *vector;
     register int n;
{
  register int counter=n;
  float power2=0.0, *ptr=vector;
  

  /* submean */
  submean_data(vector,n);
  
  /* calc power */
  counter = n;
  ptr = vector;
  while(counter--) {
    power2 += *ptr * *ptr;
    ptr++;
  }
  
  /* normalize power2 */
  if (power2 == 0.0) return;
  power2 = 1.0 / sqrt((double)power2);
  while(n--) *vector++ *= power2;
}/* end normalize_data */

/*****************************************************/
/* next_datafile: Goto next datafile. */
/*****************************************************/
static void next_datafile()
{
    data->current_datafile = data->current_datafile->next;
}/* end next_datafile */

/*****************************************************/
/* random_datafile: random next datafile. */
/*****************************************************/
static void random_datafile()
{
    data->current_datafile = *(data->datafile_table +
			       ( (int) (AM_RANDOM() * data->n_datafiles) ));
}/* end next_datafile */



#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		102
#define	YYFLAG		-32768
#define	YYNTBASE	42

#define YYTRANSLATE(x) ((unsigned)(x) <= 296 ? yytranslate[x] : 54)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   705,   706,   710,   711,   715,   716,   717,   722,   723,   724,
   725,   726,   727,   728,   732,   733,   736,   737,   738,   739,
   740,   741,   742,   743,   744,   746,   747,   748,   749,   750,
   751,   752,   753,   754,   755,   756,   757,   758,   759,   763,
   764,   771,   772,   775,   778,   782,   785,   787,   792,   795,
   796,   799
};

static const char * const yytname[] = {     0,
"error","$illegal.","NEWLINE","NUMBER","NAME","LCP","RCP","RP","LP","READFILE",
"USEFILE","RANDOM_SWITCH","ASCII","MATLAB","TYPE1","TYPE2","TYPE3","TYPE4","TYPE5","LABEL",
"GENERATOR","PATTERNS","TARGET","SELF","PATTERN_NAME","SWITCH","SCROLL","XOFF","XLENGTH","YOFF",
"YLENGTH","RANGE","NORMALIZE","THRESHOLD","SUBMEAN","SCALE","BIAS","CLEAR_DELAYS","SWAPBYTES","MATH",
"MATH_FUNCTION","datafile"
};
#endif

static const short yyr1[] = {     0,
    42,    42,    43,    43,    44,    44,    44,    45,    45,    45,
    45,    45,    45,    45,    46,    46,    47,    47,    47,    47,
    47,    47,    47,    47,    47,    47,    47,    47,    47,    47,
    47,    47,    47,    47,    47,    47,    47,    47,    47,    48,
    48,    49,    49,    50,    50,    50,    50,    50,    51,    52,
    52,    53
};

static const short yyr2[] = {     0,
     1,     2,     1,     1,     6,     4,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     2,     4,     3,     3,     4,
     4,     4,     5,     4,     4,     4,     4,     4,     4,     4,
     4,     4,     3,     4,     3,     4,     3,     3,     0,     1,
     2,     1,     2,     3,     4,     4,     3,     2,     1,     1,
     0,     1
};

static const short yydefact[] = {     0,
     0,     0,     0,     7,     0,     1,     3,     4,    42,    52,
     0,    48,     0,     0,     2,    43,    47,     0,    44,     0,
     0,    46,    45,     8,     9,    10,    11,    12,    13,    14,
    39,     6,     0,     0,    15,     0,     0,     0,     0,     0,
    51,    51,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     5,    16,     0,    18,    19,
    49,     0,     0,     0,    40,     0,     0,    50,     0,     0,
     0,     0,     0,     0,    33,     0,    37,     0,     0,    38,
    35,     0,    17,    22,    21,    20,    41,     0,    24,    25,
    27,    29,    28,    30,    26,    34,    32,    31,    36,    23,
     0,     0
};

static const short yydefgoto[] = {     5,
     6,     7,    31,    34,    35,    64,     8,     9,    65,    67,
    68
};

static const short yypact[] = {    47,
     3,    -4,    37,-32768,     1,-32768,-32768,     6,-32768,-32768,
    33,    43,    48,    49,-32768,-32768,-32768,    51,    56,    52,
    -5,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    53,-32768,    -6,    32,-32768,    58,    64,    65,    31,    56,
    56,    56,    56,    56,    56,    56,    57,    66,    57,    67,
    57,    57,    68,    69,    38,-32768,-32768,    70,-32768,-32768,
-32768,    72,    73,    -2,-32768,    77,    75,-32768,    76,    78,
    79,    80,    81,    82,-32768,    83,-32768,    84,    85,-32768,
-32768,    86,-32768,-32768,-32768,-32768,-32768,    87,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    96,-32768
};

static const short yypgoto[] = {-32768,
    92,-32768,-32768,-32768,    71,-32768,-32768,    90,     0,    59,
    -1
};


#define	YYLAST		105


static const short yytable[] = {    12,
   101,    61,    32,     1,    13,    86,    10,    11,     1,    18,
     2,     3,     4,    36,    37,    38,    39,    23,    40,    41,
    42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
    52,    53,    54,    55,    61,    62,    10,    17,    66,    56,
    33,    70,    71,    72,    73,    14,    74,    19,    76,     1,
    78,    79,    20,    21,    63,    22,     2,     3,     4,    10,
    61,    33,    58,    87,    24,    25,    26,    27,    28,    29,
    30,    59,    60,    75,    77,    80,    81,    83,    82,    84,
    85,    88,    89,    90,     0,    91,    92,    93,    94,    95,
    96,    97,    98,    99,   100,   102,    15,    16,     0,     0,
    69,     0,     0,     0,    57
};

static const short yycheck[] = {     1,
     0,     4,     8,     3,     9,     8,     4,     5,     3,    11,
    10,    11,    12,    20,    21,    22,    23,    19,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,     4,     5,     4,     5,    40,     8,
     9,    43,    44,    45,    46,     9,    47,     5,    49,     3,
    51,    52,     5,     5,    24,     5,    10,    11,    12,     4,
     4,     9,     5,    64,    13,    14,    15,    16,    17,    18,
    19,     8,     8,     8,     8,     8,     8,     8,    41,     8,
     8,     5,     8,     8,    -1,     8,     8,     8,     8,     8,
     8,     8,     8,     8,     8,     0,     5,     8,    -1,    -1,
    42,    -1,    -1,    -1,    34
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/gnu/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* Not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
#include <alloca.h>
#endif /* Sparc.  */
#endif /* Not GNU C.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYIMPURE
#define YYLEX		yylex()
#endif

#ifndef YYPURE
#define YYLEX		yylex(&yylval, &yylloc)
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYIMPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* YYIMPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#line 131 "/usr/local/gnu/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/

#define YYPOPSTACK   (yyvsp--, yysp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yysp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifndef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Next token is %d (%s)\n", yychar, yytname[yychar1]);
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      if (yylen == 1)
	fprintf (stderr, "Reducing 1 value via rule %d (line %d), ",
		 yyn, yyrline[yyn]);
      else
	fprintf (stderr, "Reducing %d values via rule %d (line %d), ",
		 yylen, yyn, yyrline[yyn]);
    }
#endif


  switch (yyn) {

case 5:
#line 715 "df.y"
{ create_datafile(yyvsp[-3].s, yyvsp[-2].i); ;
    break;}
case 6:
#line 716 "df.y"
{ use_datafile(yyvsp[-1].s); ;
    break;}
case 7:
#line 717 "df.y"
{ random_switch = TRUE; ;
    break;}
case 8:
#line 722 "df.y"
{ yyval.i = ASCII_FILE; ;
    break;}
case 9:
#line 723 "df.y"
{ yyval.i = MATLAB_FILE; ;
    break;}
case 10:
#line 724 "df.y"
{ yyval.i = TYPE1_FILE; ;
    break;}
case 11:
#line 725 "df.y"
{ yyval.i = TYPE2_FILE; ;
    break;}
case 12:
#line 726 "df.y"
{ yyval.i = TYPE3_FILE; ;
    break;}
case 13:
#line 727 "df.y"
{ yyval.i = TYPE4_FILE; ;
    break;}
case 14:
#line 728 "df.y"
{ yyval.i = TYPE5_FILE; ;
    break;}
case 17:
#line 736 "df.y"
{ user_label = yyvsp[-1].s; ;
    break;}
case 18:
#line 737 "df.y"
{ genORpatterns = 0; menu_defaults = FALSE; /* use generator */ ;
    break;}
case 19:
#line 738 "df.y"
{ genORpatterns = 1; menu_defaults = FALSE; /* use patterns */ ;
    break;}
case 21:
#line 740 "df.y"
{ self = TRUE ; ;
    break;}
case 22:
#line 741 "df.y"
{ target_file = yyvsp[-1].s; ;
    break;}
case 23:
#line 742 "df.y"
{ update_name_vector(yyvsp[-1].s,yyvsp[-2].i); ;
    break;}
case 24:
#line 743 "df.y"
{ switch_cycle = yyvsp[-1].i; ;
    break;}
case 25:
#line 744 "df.y"
{
	if (yyvsp[-1].i < 0) yyerror("You cannot have a negative scroll step!");scroll_step = yyvsp[-1].i; ;
    break;}
case 26:
#line 746 "df.y"
{ if (yyvsp[-1].f <= 0.0) yyerror("Range must be postive!"); range = yyvsp[-1].f; ;
    break;}
case 27:
#line 747 "df.y"
{ if (yyvsp[-1].i < 0) yyerror("xoffset: must be postive!"); xoffset = yyvsp[-1].i; ;
    break;}
case 28:
#line 748 "df.y"
{ if (yyvsp[-1].i < 0) yyerror("yoffset: must be postive!"); yoffset = yyvsp[-1].i; ;
    break;}
case 29:
#line 749 "df.y"
{ if (yyvsp[-1].i < 0) yyerror("xlength: must be postive!"); xlength = yyvsp[-1].i; ;
    break;}
case 30:
#line 750 "df.y"
{ if (yyvsp[-1].i < 0) yyerror("ylength: must be postive!"); ylength = yyvsp[-1].i; ;
    break;}
case 31:
#line 751 "df.y"
{ bias = yyvsp[-1].f; ;
    break;}
case 32:
#line 752 "df.y"
{ scalar = yyvsp[-1].f; ;
    break;}
case 33:
#line 753 "df.y"
{ normalize = 1; ;
    break;}
case 34:
#line 754 "df.y"
{ threshold = yyvsp[-1].f; ;
    break;}
case 35:
#line 755 "df.y"
{ swapbytes = 1; ;
    break;}
case 36:
#line 756 "df.y"
{ math = yyvsp[-1].i; ;
    break;}
case 37:
#line 757 "df.y"
{ submean = 1; ;
    break;}
case 38:
#line 758 "df.y"
{clear_delays = TRUE; ;
    break;}
case 40:
#line 763 "df.y"
{ update_target_vector(yyvsp[0].f); ;
    break;}
case 41:
#line 764 "df.y"
{ update_target_vector(yyvsp[0].f); ;
    break;}
case 44:
#line 775 "df.y"
{ lineno = yyvsp[-1].i;
 				datafile_name = yyvsp[0].s;
			      ;
    break;}
case 45:
#line 778 "df.y"
{ 
	                                   lineno = yyvsp[-2].i;
 				           datafile_name = yyvsp[-1].s;
			                 ;
    break;}
case 46:
#line 782 "df.y"
{ lineno = yyvsp[-1].i;
                                       datafile_name = yyvsp[0].s;
                                     ;
    break;}
case 47:
#line 785 "df.y"
{;
    break;}
case 48:
#line 787 "df.y"
{ lineno = yyvsp[0].i; ;
    break;}
case 49:
#line 792 "df.y"
{ yyval.f = yyvsp[0].f; ;
    break;}
case 50:
#line 795 "df.y"
{ yyval.i = yyvsp[0].i; ;
    break;}
case 51:
#line 796 "df.y"
{ yyval.i = 1; /* default */;
    break;}
case 52:
#line 799 "df.y"
{yyval.i = (int)yyvsp[0].f; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 362 "/usr/local/gnu/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) xmalloc(size + 15);
	  strcpy(msg, "parse error");

	  if (count < 5)
	    {
	      count = 0;
	      for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
		if (yycheck[x + yyn] == x)
		  {
		    strcat(msg, count == 0 ? ", expecting `" : " or `");
		    strcat(msg, yytname[x]);
		    strcat(msg, "'");
		    count++;
		  }
	    }
	  yyerror(msg);
	  free(msg);
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 801 "df.y"

  

yylex()
{
  unsigned int c;

  more :


  /* skip spaces and tabs */
  while((c=getc(df_stream)) == ' ' || c == '\t') ;

  if (c == '\n') {  ++lineno; goto more ; }

  if (iscntrl(c)) goto more ;
  
  if (c == EOF) return 0;

  if (c == '#') return(NEWLINE);

  if (c == '"') { /* quoted string */
    read_quoted_token();
    yylval.s = newstr(yytext, yyleng);
    return(NAME);
  }

  if (c == '(') {
    if (this_context(KEYWORD_CONTEXT))
      push_lex_context(KEYWORD_CONTEXT);
    return(LP);
  }/* end if */

  if (c == ')') {
    pop_lex_context();
    return(RP);
  }/* end if */


  /* ok, done with the single character stuff */
  ungetc((unsigned char)c, df_stream);
  read_token();

  if (isdigit((unsigned int)yytext[0]) ||
      (yyleng > 1 &&
       (yytext[0] == '-' || yytext[0] == '+' || yytext[0] == '.') &&
       isdigit((unsigned int)yytext[1])) ||
      (yyleng > 2 &&
       (yytext[0] == '-' || yytext[0] == '+') &&
       yytext[1] == '.' &&
       isdigit((unsigned int)yytext[2]))) { /* number */
    sscanf((char *)yytext, "%f", &(yylval.f)); 
    return(NUMBER);
  }/* end if number */ 

  if (this_context(NO_CONTEXT)) { /* global context */
    if (input_equals("RandomSwitch")) return(RANDOM_SWITCH);
  }

  if (this_context(NO_CONTEXT)) { /* global context */
    if (input_equals("UseFile")) {
      push_lex_context(USEFILE_CONTEXT);
      return(USEFILE);
    }
  }

  if (this_context(NO_CONTEXT)) { /* global context */
    if (input_equals("ReadFile")) {
      push_lex_context(READFILE_CONTEXT);
      return(READFILE);
    }
  }

  if (this_context(READFILE_CONTEXT)) {

    /* types */
    
    if (input_equals("Ascii")) {
      switch_lex_context(KEYWORD_CONTEXT);
      return(ASCII);
    }
    
    if (input_equals("Matlab")) {
      switch_lex_context(KEYWORD_CONTEXT);
      return(MATLAB);
    }
    
    if (input_equals("Type1")) {
      switch_lex_context(KEYWORD_CONTEXT);
      return(TYPE1);
    }

    if (input_equals("Type2")) {
      switch_lex_context(KEYWORD_CONTEXT);
      return(TYPE2);
    }

    if (input_equals("Type3")) {
      switch_lex_context(KEYWORD_CONTEXT);
      return(TYPE3);
    }

    if (input_equals("Type4")) {
      switch_lex_context(KEYWORD_CONTEXT);
      return(TYPE4);
    }

    if (input_equals("Type5")) {
      switch_lex_context(KEYWORD_CONTEXT);
      return(TYPE5);
    }
    
  }

  if (this_context(KEYWORD_CONTEXT)) {

    if (input_equals("Math->")) {
      push_lex_context(MATH_CONTEXT);
      return(MATH);
    }

    if (input_equals("ClearDelays->")) return(CLEAR_DELAYS);

    if (input_equals("SubMean->")) return(SUBMEAN);

    if (input_equals("Normalize->")) return(NORMALIZE);

    if (input_equals("Threshold->")) return(THRESHOLD);

    if (input_equals("Scale->")) return(SCALE);

    if (input_equals("Bias->")) return(BIAS);

    if (input_equals("Range->")) return(RANGE);

    if (input_equals("Yoffset->")) return(YOFF);

    if (input_equals("Xoffset->")) return(XOFF);

    if (input_equals("YLength->")) return(YLENGTH);

    if (input_equals("XLength->")) return(XLENGTH);

    if (input_equals("Scroll->")) return(SCROLL);

    if (input_equals("SwapBytes->")) return(SWAPBYTES);

    if (input_equals("Switch->")) return(SWITCH);

    if (input_equals("PatternName->")) return(PATTERN_NAME);

    if (input_equals("Target->")) return(TARGET);

    if (input_equals("Patterns->")) return(PATTERNS);

    if (input_equals("Generator->")) return(GENERATOR);

    if (input_equals("Label->")) return(LABEL);

    if (input_equals("All")) {yylval.f = -1.0; return(NUMBER);}

    if (input_equals("Self")) { return(SELF);}

  }

  if (this_context(MATH_CONTEXT)) {

    if (input_equals("abs[x]"))  yylval.i = DF_MATH_FABS;
    
    else if (input_equals("square[x]"))  yylval.i = DF_MATH_SQUARE;

    else if (input_equals("log10[x]"))  yylval.i = DF_MATH_LOG10;

    else if (input_equals("log10[x+1]"))  yylval.i = DF_MATH_PSEUDO_LOG10;

    else fprintf(stderr, "\nMath->: Unknown function!\n");

    pop_lex_context();

    return(MATH_FUNCTION);
  }


  /* names */
  {
    yylval.s = newstr(yytext, yyleng);
    return(NAME);
  }  

}/* end yylex */


/*****************************************************/
/* loaddata:       file = datafile specification from
                   which datafiles are read.
		   query_function = function
		   to interogate the network.
		   noise_type = type of noise to
		   corrupt input (if any)
		   mean = mean of noise distribution.
		   variance = variance of noise distribution.
 */
/*****************************************************/
int loaddata(file, query_function, noise_type, mean, variance)
     char *file;
     LB_PTR (*query_function)();
     int noise_type;
     float mean, variance;
{
  char *cpp_file;
  extern DATAPTR data;
  
  /******************************************/
  /* some basic init */
  threshold = AM_HUGE_VAL;
  datafile_name = file;
  
  /******************************************/
  /* run cpp on datafile */
  cpp_file = am_cpp(file,0);

  /******************************************/
  /* open  input from cpp */
  df_stream = am_fopen(cpp_file, "r");
  /* return on error */
  if (df_stream == NULL)  {
    fprintf(stderr, "\nUnable to open %s", cpp_file);
    am_perror("Reading .df file");
    return(1);
  }

  /******************************************/
  
  /******************************************/
  /* make the root */
  data = _file_init(query_function, noise_type, mean, variance);

  /******************************************/

  /******************************************/
  /* parse storing info in global variables */
  yyparse();
  if (error_code) return(error_code);
  /******************************************/

  /******************************************/
  /* close the stream */
  am_fclose(df_stream);
  /******************************************/

  /******************************************/
  /* read in the data                       */
  /******************************************/
  {
    DATAFILEPTR files = data->datafiles;

    if (files == (DATAFILEPTR)NULL) {
      fprintf(stderr, "\nNo data files!\n");
      return(1);
    }
    
    /* loop through each structure...read */
    while(files != (DATAFILEPTR)NULL) {
      if (!files->usefile) _readfile(files, data);
      files = files->next;
    }/* end while */

    
    /* set the first one */
    data->current_datafile = data->datafiles;

  }/* end block */
  
  /******************************************/
  /* Reference files w/UseFile              */
  /******************************************/
  {
    DATAFILEPTR files = data->datafiles;

    /* loop through each structure...reference (from UseFile) */
    while(files != (DATAFILEPTR)NULL) {

      if (files->usefile) { /* just a reference, don't read */
	DATAFILEPTR tmp_next = files->next; /* hold on */

	/* copy contents */
	*files = *(find_datafile(files->filename));

	/* fix list */
	files->next = tmp_next;

      }/* end if */

      files = files->next;
    }/* end while */

  }/* end block */

  /******************************************/  
  /* swapbytes                              */
  /******************************************/  
  {
    DATAFILEPTR files = data->datafiles;
    /* loop through each structure...read */
    while(files != (DATAFILEPTR)NULL) {
      
      if (files->swapbytes && !files->usefile) {
	int n = files->npatterns;
	int size = files->size; /* size of a data pattern */

	while (n--) {
	  swapbytes_data(*(files->inputs + n), size);
	}/* end swap inputs */

	/* swap targets */
	switch (files->type) {
	case TYPE2_FILE :
	  /* size of a target pattern */
	  size = data->targets_xdim * data->targets_ydim;
	  swapbytes_data(*(files->targets), size);
	  break;
	  
	case TYPE3_FILE :
	case TYPE4_FILE : 
	case TYPE5_FILE : 
	  n = files->npatterns;
	  /* size of a target pattern */
	  size = data->targets_xdim * data->targets_ydim;
	  
	  while (n--) {
	    swapbytes_data(*(files->targets + n), size);
	  }/* end swap inputs */
	  break;
	  
	}/* end switch */

      }/* end if swapbytes */
      
      files = files->next;
    }/* end while */
  }/* end block */
  /******************************************/  
  
  /******************************************/  
  /* math                                   */
  /******************************************/  
  {
    DATAFILEPTR files = data->datafiles;
    /* loop through each structure...read */
    while(files != (DATAFILEPTR)NULL) {
      
      if (files->math != DF_MATH_NONE && !files->usefile) {
	int n = files->npatterns;
	int size = files->size; /* size of a data pattern */
	
	while (n--) math_data(files->math, *(files->inputs + n), size);
      }/* end if submean */
      
      files = files->next;
    }/* end while */
  }/* end block */
  /******************************************/ 

  /******************************************/  
  /* threshold                              */
  /******************************************/  
  {
    DATAFILEPTR files = data->datafiles;
    /* loop through each structure...read */
    while(files != (DATAFILEPTR)NULL) {
      
      if (files->threshold != AM_HUGE_VAL && !files->usefile) {
	int n = files->npatterns;
	int size = files->size; /* size of a data pattern */
	
	while (n--) threshold_data(files->threshold, *(files->inputs + n), size);
      }/* end if submean */
      
      files = files->next;
    }/* end while */
  }/* end block */
  /******************************************/  
  
  /******************************************/  
  /* submean                                */
  /******************************************/  
  {
    DATAFILEPTR files = data->datafiles;
    /* loop through each structure...read */
    while(files != (DATAFILEPTR)NULL) {
      
      if (files->submean && !files->usefile) {
	int n = files->npatterns;
	int size = files->size; /* size of a data pattern */
	
	while (n--) submean_data(*(files->inputs + n), size);
      }/* end if submean */
      
      files = files->next;
    }/* end while */
  }/* end block */
  /******************************************/  
  
  
  /******************************************/  
  /* normalize                              */
  /******************************************/  
  {
    DATAFILEPTR files = data->datafiles;
    /* loop through each structure...read */
    while(files != (DATAFILEPTR)NULL) {
      
      if (files->normalize && !files->usefile) {
	int n = files->npatterns;
	int size = files->size; /* size of a data pattern */
	
	while (n--) normalize_data(*(files->inputs + n), size);
      }/* end if normalize */
      
      files = files->next;
    }/* end while */
  }/* end block */
  /******************************************/  
  
  
  /******************************************/  
  /* rescale                                */
  /******************************************/  
  {
    DATAFILEPTR files = data->datafiles;
    /* loop through each structure...read */
    while(files != (DATAFILEPTR)NULL) {
      int n = files->npatterns;
      int size = files->size; /* size of a data pattern */
      float range = files->range;
      float scalar = files->scalar;
      float bias = files->bias;
      
      
      if (!files->usefile) {
	if (range > 0.0 || bias != 0.0 || scalar != 1.0) /* leave alone? */
	  while (n--)
	    rescale_data(*(files->inputs + n),
			 range, scalar, bias, size);
      }/* end if */

      files = files->next;
    }/* end while */
  }/* end block */
  /******************************************/  

  /******************************************/
  /* setup for the next_file function       */
  /******************************************/
  {
    /* set the next file function */
    if (random_switch) { /* random */
      DATAFILEPTR files = data->datafiles, *file_ptr;
      
      data->datafile_table = (DATAFILEPTR *)am_alloc_mem(data->n_datafiles * sizeof(DATAFILEPTR));
      file_ptr = data->datafile_table;
      
      /* loop through each structure...set into table */
      while(files != (DATAFILEPTR)NULL) {
	*file_ptr++ = files;
	files = files->next;
      }/* end while */
      
      data->next_datafile = random_datafile;
      
    } else { /* cyclic */
      
      /* set function */
      data->next_datafile = next_datafile;
      
    }/* end else */
    
  }/* end block */



  /******************************************/
  /* make circular list                     */
  /******************************************/
  {
    DATAFILEPTR files = data->datafiles, last_file;

    /* loop through each structure...find the end */
    while(files != (DATAFILEPTR)NULL) {
      last_file = files;
      files = files->next;
    }/* end while */
    
    /* make circular list */
    if (data->datafiles != (DATAFILEPTR)NULL) 
      last_file->next = data->datafiles;
    
  }/* end block */
  
  /******************************************/
  /* remove cpp file */
  am_remove_cpp_file(cpp_file);
  /******************************************/

  return(error_code);
}



