/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
/* this is a hack but it works..oh well */

#include "BpDatafile.h"

#define TRUE  1
#define FALSE 0
static FILE *stream;
static int eof = FALSE;

/* ascii file reader : Ascii format files are files of patterns of ascii floating point
                       numbers. The format is:
		         <input pattern-1: list of ascii floats, length equal to input size>
		         <target pattern-1: list of ascii floats, length equal to target size>
		         <input pattern-2: list of ascii floats, length equal to input size>
		         <target pattern-2: list of ascii floats, length equal to target size>
			                         .
						 .
						 .
		      	 <input pattern-N: list of ascii floats, length equal to input size>
		         <target pattern-N: list of ascii floats, length equal to target size>

			C style comments are allowed as well as cpp macros.
*/

static float read_float()
{
  float result;
  
  if (!eof) { /* d'nat doo nufin' if eof */
    
    if (fscanf(stream, "%f", &result) == EOF) {
      eof = TRUE;
    }/* end if */

    return(result);
    
  } else 
    return(0.0);

}/* end read_float */



static void read_pattern(n, data_ptr)
     int n;
     float *data_ptr;
{
  int i;

  for (i=0; i<n; i++) {
    if (data_ptr == (float *) NULL)
      read_float();
    else
      *(data_ptr++) = read_float();
  }/* end for */

}/* end read_pattern */

void _ascii_reader(file_descriptor, datafile, data)
     int file_descriptor;                 /* open file (not used) */
     DATAFILEPTR datafile;                /* this file */
     DATAPTR data;                        /* root structure */
{
  int input_size = (data->inputs_xdim * data->inputs_ydim);
  int target_size = (data->targets_xdim * data->targets_ydim);
  char *cpp_file;
  int N_Patterns, i;

  /* run cpp on file to remove comments and macros */
  cpp_file = am_cpp(datafile->filename,1);

  /* open the preprocesessed file */
  stream = fopen(cpp_file, "r");
  if (stream == (FILE *)NULL) {
    fprintf(stderr,"\nUnable to open %s.\n", cpp_file);
    am_perror("ascii_reader.c");
    return;
  }/* end if */

  /* count input/output pairs */
  N_Patterns = -1; /* last pattern read is eof */
  while (!eof) {
    read_pattern(input_size + target_size, (float *)NULL);
    N_Patterns++;
  }/* end while */

  /* update the structure */
  datafile->npatterns = N_Patterns;
  datafile->inputs = (float **)am_alloc_mem((unsigned)(N_Patterns * sizeof(float *)));
  datafile->targets = (float **)am_alloc_mem((unsigned)(N_Patterns * sizeof(float *)));
  datafile->size = input_size;
  datafile->xdim = data->inputs_xdim;
  datafile->ydim = data->inputs_ydim;
  if (datafile->switch_cycle < 0) datafile->switch_cycle = N_Patterns; /* (switch: all) */

  for (i=0; i<N_Patterns; i++) {
    datafile->inputs[i] = (float *)am_alloc_mem((unsigned)(input_size * sizeof(float)));
    datafile->targets[i] = (float *)am_alloc_mem((unsigned)(target_size * sizeof(float)));
  }/* end for */

  /* back to the beginning...to read the data */
  (void)fclose(stream);
  eof = FALSE;

  /* open the preprocesessed file */
  stream = fopen(cpp_file, "r");
  if (stream == (FILE *)NULL) {
    perror("ascii_reader.c: ");
    return;
  }/* end if */

  for(i=0;i<N_Patterns;i++) {
    read_pattern(input_size, datafile->inputs[i]);
    read_pattern(target_size, datafile->targets[i]);
  }/* end while */

  /* done */
  (void)fclose(stream);

  /* remove the cpp file */
  am_remove_cpp_file(cpp_file);

}  /* end _ascii_reader */

