/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
/* data structures etc. for Aspirin/MIGRAINES data files */
#include "aspirin_bp.h"

typedef struct functions {
  VFPTR set_input;            /* bb function to set inputs */
  VFPTR set_target_output;    /* bb function to set targets */
  struct functions *next;     /* list */
}FUNCTIONS, *FUNCTIONSPTR;

typedef struct user_name {
  int index;                   /* index of pattern */
  char *name;                  /* user's name for this pattern */
}USER_NAME, *USER_NAME_PTR;


typedef struct datafile {
  char *filename;             /* pathname */
  int type;                   /* format */

  int usefile;                /* not zero if this is from UseFile */

  int xdim;                   /* xdim size */
  int ydim;                   /* ydim size */
  int size;                   /* xdim * ydim */
  int xoffset;                /* where to start reading */
  int yoffset;                /* where to start reading */
  int xlength;                /* how much */
  int ylength;                /* how much */

  float range;                /* max - min */
  float bias;                 /* (max - min)/2 */
  float scalar;               /* scalar * data when read */
  int normalize;              /* 1 if to normalize data */
  int submean;                /* 1 if to submean data */
  float threshold;            /* used to clip data */
  int math;                   /* set to function to do on data points */
  int swapbytes;              /* 1 if swapbytes on read */

  int clear_delays;           /* TRUE if clear delay buffers before using */

  int menu_defaults;          /* equals 1 if using default menu style */
  int genORpatterns;          /* 0 if generator, 1 if patterns */

  int current_pattern;        /* used for patterns w/graphics */
  int switch_cycle;           /* how often to switch files */
  int scroll_step;            /* step size when scrolling pattern */
  int scroll_index;           /* where I currently am in my scrolling */
  int npatterns;              /* number of patterns */


  char *target_file;          /* name of the target file */
  float *user_target;         /* ptr to user supplied target vector */
  int self;                   /* TRUE if using input as target vector */

  char *user_label;           /* label for this data from user */
  int n_user_names;           /* how many */
  USER_NAME_PTR user_names;   /* ptr to array of user's names for patterns */

  float **inputs;             /* ptr to array of ptrs to patterns */
  float **targets;            /* ptr to array of ptrs to patterns */
  char **input_labels;        /* ptr to array of ptrs to pattern labels */
  char **target_labels;       /* ptr to array of ptrs to pattern labels */

  struct datafile *next;      /* list */

}DATAFILE, *DATAFILEPTR;

typedef struct data {
  /* network input-output */
  int inputs_xdim;             /* x dimension */
  int inputs_ydim;             /* y dimension */
  int inputs_size;             /* x * y dimension */
  int targets_xdim;            /* x dimension */
  int targets_ydim;            /* y dimension */

  int n_datafiles;             /* the number of datafiles */
  DATAFILEPTR current_datafile;/* current datafile */
  

  FUNCTIONSPTR setfunctions;   /* list of pointers to bb functions */
  DATAFILEPTR  datafiles;      /* data of data from files */
  DATAFILEPTR *datafile_table; /* table of data files */
  VFPTR next_datafile;         /* function to get the next data file */
  
  PFFPTR noise;                /* function that corrupts input with noise */
  float mean, variance;        /* for noise */
  float *input_buffer;         /* holds corrupted/scrolled input */

}DATA, *DATAPTR;


/* datafile types */
#define ASCII_FILE 0 
#define TYPE1_FILE 1
#define TYPE2_FILE 2
#define TYPE3_FILE 3
#define TYPE4_FILE 4
#define TYPE5_FILE 5
#define MATLAB_FILE 6

#define MAX_USER_GENERATORS 20

typedef struct user_generator {
  VFPTR generator;
  char *item;
  char *string;
}USER_GENERATOR;

#define MAXPATTERNS 128 /* max patterns by default */

/* types of noise to add to signal */
#define NO_NOISE 0
#define NORMAL_NOISE 1
#define UNIFORM_NOISE 2

/* math functions */
#define DF_MATH_NONE 0
#define DF_MATH_FABS 1
#define DF_MATH_LOG10 3
#define DF_MATH_PSEUDO_LOG10 4
#define DF_MATH_SQUARE 5

