/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "aspirin_bp.h"	       

typedef struct test_struct {
  PFFPTR   out_function;
  PFFPTR   target_function;
  int      n_outputs;
  struct test_struct *next;
} TS, *TS_PTR;

static TS_PTR Test_List = (TS_PTR)NULL;

void Create_Test_List(query_function)
     LB_PTR (*query_function)();
{
  int i;
  LB_PTR layer_buffer;
  TS_PTR new_tester, results = (TS_PTR)NULL;

  if (Test_List == (TS_PTR)NULL) {
    for (i=0; (layer_buffer=query_function(i,0)) != (LB_PTR)NULL; i++)
      if ((layer_buffer->black_box_info.get_output != (PFFPTR)NULL) &&
	  (layer_buffer->black_box_info.get_target_output != (PFFPTR)NULL)) {

	new_tester = (TS_PTR)am_alloc_mem(sizeof(TS));

	new_tester->out_function =
	  layer_buffer->black_box_info.get_output;
	new_tester->target_function =
	  layer_buffer->black_box_info.get_target_output;
	layer_buffer =
	  query_function(i, layer_buffer->black_box_info.output_layer_index);
	new_tester->n_outputs = layer_buffer->n_nodes;
	new_tester->next = results;
	results = new_tester;
      }  /* if get_output != NULL */

    Test_List = results;
  }  /* if Test_List == NULL */
}  /* create_test_list() */

float RMS_Error()
{
  register int i, count=0;
  register float *output, *target, value;
  register double sum = 0.0;
  register TS_PTR tester;

  for (tester = Test_List; tester != (TS_PTR)NULL; tester = tester->next)
    if (((output = (tester->out_function)()) != (float *)NULL)  &&
	((target = (tester->target_function)()) != (float *)NULL))
      for (i=0; i<tester->n_outputs; i++, count++) {
	value = *output++ - *target++;
	sum += value * value;
      }

  if (count == 0) return( 0.0 );
  else {
    float result;
    result = sqrt( (double)(sum / count) );
    return( result );
  }
}  /* RMS_Error() */

float Max_Absolute_Error()
{
  register int i;
  register float *output, *target, value;
  register TS_PTR tester;
  float max_error = 0.0;

  for (tester = Test_List; tester != (TS_PTR)NULL; tester = tester->next)
    if (((output = (tester->out_function)()) != (float *)NULL)  &&
	((target = (tester->target_function)()) != (float *)NULL))
      for (i=0; i<tester->n_outputs; i++)
	if ((value = AM_FABS((double)(*output++ - *target++))) > max_error)
	  max_error = value;

  return( max_error );
}  /* Max_Absolute_Error() */

float Min_Absolute_Error()
{
  register int i, count=0;
  register float *output, *target, value;
  register TS_PTR tester;
  double min_error;

  min_error = AM_HUGE_VAL;
  for (tester = Test_List; tester != (TS_PTR)NULL; tester = tester->next)
    if (((output = (tester->out_function)()) != (float *)NULL)  &&
	((target = (tester->target_function)()) != (float *)NULL))
      for (i=0; i<tester->n_outputs; i++, count++)
	if ((value = AM_FABS((double)(*output++ - *target++))) < min_error)
	  min_error = value;

  if (count == 0) return(0.0);
  else return( min_error );
}  /* Min_Absolute_Error() */

float Mean_Absolute_Error()
{
  register int i, count=0;
  register float *output, *target;
  register double sum = 0.0;
  register TS_PTR tester;

  for (tester = Test_List; tester != (TS_PTR)NULL; tester = tester->next)
    if (((output = (tester->out_function)()) != (float *)NULL)  &&
	((target = (tester->target_function)()) != (float *)NULL))
      for (i=0; i<tester->n_outputs; i++, count++)
	sum += AM_FABS((double)(*output++ - *target++));

  if (count == 0) return(0.0);
  else return( sum / count );
}  /* Mean_Absolute_Error() */
