/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

/*---------------------------------------------------------------------------*/
/*                          GEA - GROUP ERROR ANALYSIS                       */
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <math.h>

#define MAXGROUPS 50
int	nl = 10;

double GroupErrors[MAXGROUPS];
double NrInGroups[MAXGROUPS];

double	Criterion = 0.4;
int	MaximumColumn = 0;
double	Target = 0.0;
double	Output = 0.0;
int	MaximumFlag = 0;
FILE	*TargetFile;
char	TargetFileName[100];
int	TargetFileFlag = 0;
FILE	*GroupsFile;
char	GroupsFileName[100];
int	GroupsFileFlag = 0;
FILE	*OutputFile;
char	OutputFileName[100];
int	OutputFileFlag = 0;
int	ErrorFlag = 0;

struct  GroupTable {
        char    Group[MAXGROUPS][100];
        int     NrOfGroups;
};
 
 
struct GroupTable       Groups;
 
#define TRUE 1
#define FALSE 0

int
lookahead(file)
FILE	*file;
{
	int	next;

	next = getc(file);
	ungetc(next, file);
	return(next);
}

InitGroupErrors()
{
	int	i,j;

	for (i=0; i< MAXGROUPS; i++)
		GroupErrors[i] = 0.0;
}

InitNrInGroups()
{
	int	i;

	for (i=0; i < MAXGROUPS; i++)
		NrInGroups[i] = 0.0;
}

PrintSummary()
{
	int	i;

	if (MaximumFlag)
		printf("maximum flag set.\n");
	else
		printf("Criterion = %lg\n", Criterion);
	printf("                    # in group     # errors    %% errors\n");
	for (i=0; i < Groups.NrOfGroups; i++){
		printf("%15s %12.5g %12.5g %12.3g\n", Groups.Group[i], NrInGroups[i], GroupErrors[i], GroupErrors[i]/NrInGroups[i]*100.0);
	};
}

int     GetGroupNr(groupname)
        char    groupname[100];
 
{
        int     i = 0;
        int     found = 0;
 
        while (!found && i < Groups.NrOfGroups) {
            found = (strcmp(groupname, Groups.Group[i]) == 0);
            i++;
        };
 
        if (found)
            return(i-1);
        else {
            strcpy(Groups.Group[i], groupname);
            Groups.NrOfGroups++;
            return(i);
        };
 
}

/*****************************************************************************/
/*                              INITIALIZE				     */
/*****************************************************************************/

Initialize()
{
	InitGroupErrors();
	InitNrInGroups();
}

whitespace(f)
FILE	*f;
{
	/* soak up non newline whitespace in target file*/
	while (lookahead(f) == ' ' || lookahead(f) == '\t')
		getc(f);
}

/*****************************************************************************/
/*                           GET GROUP ERROR STATS                           */
/*****************************************************************************/

GetGroupErrorStats()
{
	double	Number;
	int	col, groupNr, i, j, k;
	char	groupname[100];
	int	Correct;
	int	MaxTargetNr, MaxOutputNr;
	double	MaxTarget, MaxOutput;

	groupNr = 0;
	while (lookahead(TargetFile) != EOF && lookahead(OutputFile) != EOF){


		if (GroupsFileFlag){
			if (lookahead(GroupsFile) == EOF){
				printf("Groups file ended prematurely.\n");
				exit(-1);
			};
			/* Get group identifier from group file */
			if (fscanf(GroupsFile, "%[^\n]\n", groupname) == nl){
				printf("Error in groups file - group name missing.\n");
				exit(-1);
			}
			else {
				groupNr = GetGroupNr(groupname);
			};
		};

		col = 0;
		Correct = TRUE;
		MaxTargetNr = 0;
		MaxOutputNr = 0;
		MaxTarget = -1.0e99;
		MaxOutput = -1.0e99;
		while ((lookahead(OutputFile) != EOF) && (lookahead(OutputFile) != nl) && (lookahead(TargetFile) != EOF) && (lookahead(TargetFile) != nl)) {

			if (fscanf(TargetFile, "%lg", &Target) != 1){
				printf("Error in target file.\n");
				exit(-1);
				};

			if (fscanf(OutputFile, "%lg", &Output) != 1){
				printf("Error in output file.\n");
				exit(-1);
				};

			if (MaximumFlag){
				if (MaxTarget < Target){
					MaxTarget = Target;
					MaxTargetNr = col;
					};

				if (MaxOutput < Output){
					MaxOutput = Output;
					MaxOutputNr = col;
					};
				Correct = (MaxOutputNr == MaxTargetNr);
				}
			else
				Correct = Correct && (fabs(Target-Output) < Criterion);

			whitespace(OutputFile);
			whitespace(TargetFile);
			col++;
		};

		if (lookahead(TargetFile) == nl){
			getc(TargetFile); /* soak up nl */
			getc(OutputFile); /* soak up nl */
			NrInGroups[groupNr] = NrInGroups[groupNr] + 1.0;
			if (!Correct){
				GroupErrors[groupNr] += 1.0; 
				};
			}
		};
}

/*****************************************************************************/
/*                       PROCESS COMMAND LINE OPTIONS                        */
/*****************************************************************************/

ProcessCommandLineOptions(argc, argv)
int argc;
char **argv;
{
	extern char *optarg;
	extern int optind;
	int c;

	while ((c = getopt(argc, argv, "mo:t:c:g:")) != -1)
	    switch (c) {
	    case 'o':
			OutputFileFlag++;
			sscanf(optarg, "%s", OutputFileName);
			break;
	    case 'g':
			GroupsFileFlag++;
			sscanf(optarg, "%s", GroupsFileName);
			break;
	    case 't':
			TargetFileFlag++;
			sscanf(optarg, "%s", TargetFileName);
			break;
	    case 'c': 
			sscanf(optarg, "%lg", &Criterion);
			break;
	    case 'm':
			MaximumFlag++;
			break;
	    case '?':
			ErrorFlag++;
	    };

	if (ErrorFlag) {
	    (void) fprintf(stderr, "Group Error Analysis: gea -o <Output File> -t <Target File> [-g <Groups File>] [-c <Criterion>]\n");
	    exit (1);
	};

	if (!TargetFileFlag){
		printf("No target file was supplied.\n");
		exit(-1);
		};

	TargetFile = fopen(TargetFileName, "r");
	if (TargetFile == NULL){
		printf("%s does not exit.\n", TargetFileName);
		exit(-1);
		};

	if (!OutputFileFlag){
		printf("No output file was supplied.\n");
		exit(-1);
		};

	OutputFile = fopen(OutputFileName, "r");
	if (OutputFile == NULL){
		printf("%s does not exit.\n", OutputFileName);
		exit(-1);
		};

	if (GroupsFileFlag){
		GroupsFile = fopen(GroupsFileName, "r");
		if (GroupsFile == NULL){
			printf("%s does not exit.\n", GroupsFileName);
			exit(-1);
			};
		}
	else {
		sprintf(&Groups.Group[0][0], "all");
		Groups.NrOfGroups = 1;
		};
}

main(argc, argv)
int	argc;
char	*argv[];
{

	Initialize();

	ProcessCommandLineOptions(argc, argv);

	GetGroupErrorStats();
	PrintSummary();

}
