/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "header.h"

#ifndef PADDING
# define PADDING 0
#endif

/* align on quad word boundry */
#ifdef MCOS
# define ALIGN (PADDING * sizeof(float))
#endif

/* align on quad word boundry */
#ifdef MEIKO860
# define ALIGN (PADDING * sizeof(float))
#endif

/* am_mem: Aspirin/Migraines memory allocation. */
char *am_alloc_mem(length)
     unsigned int length; /* number of bytes */
{
  char *results = NULL;
  
  /* printf("\n%d bytes.", length); */
  
  if (length) { /* don't call with 0!!! */
    
    results = (char *)malloc( length + (PADDING * sizeof(float)) );
    if (results == (char *)NULL) {
      fprintf(stderr,
	      "Error: cannot allocate %d bytes of memory!\n", length);
      exit(1);
    }  /* if */
    
  } else {
    fprintf(stderr,
	    "Warning: _alloc_mem called with 0 bytes argument. Returning NULL.\n");
  }/* end if */


  /* align ? */
#ifdef ALIGN
  {
    unsigned int align;

    align = ( ((unsigned int)results) + ALIGN )/ALIGN;
    results  = (char *) ( align * ALIGN );
  }
#endif
  
  return(results);
}/* end am_alloc_mem */

/* am_free_mem: Free it */
void am_free_mem(mem)
     char *mem;
{
  free(mem);
}/* end am_free_mem */
