/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "header.h"

/* extern int read(), write(), open(), close(), creat(), fstat(); */

/* extern char *sprintf(); */

static char *ftemp_string = ".nn.temp.XXXXXXXXXXXXXXXXXXXX";
static int  ftemp_counter=0;

char *am_mktemp()
{
  (void)sprintf((ftemp_string+9), "%d", ftemp_counter);
  ftemp_counter++;
  return( ftemp_string );
}

int am_fread(ptr, size, nitems, stream)
     char *ptr;
     int size, nitems;
     FILE *stream;
{
  return ( fread(ptr, size, nitems, stream) );
}

int am_read(fd, b, nbytes)
     int fd;
     char *b;
     int nbytes;
{
  return ( read(fd, b, nbytes) );
}

int am_write(fd, b, nbytes)
     int fd;
     char *b;
     int nbytes;
{
  return ( write(fd, b, nbytes) );
}

int am_create(path)
     char *path;
{
  return ( (int) creat(path, 0644) );
}


int am_open(path)
     char *path;
{
  return ( (int) open(path, 0) ); /* read only */
}

void am_close(fd)
     int fd;
{
  close (fd);
}

FILE *am_freopen(path, type, stream)
     char *path, *type;
     FILE *stream;
{
  return ( freopen(path, type, stream) );
}

FILE *am_fopen(path, type)
     char *path, *type;
{
  return ( fopen(path, type) );
}

void am_fclose(stream)
     FILE *stream;
{
  fclose (stream);
}

int am_file_size(filename)
     char *filename;
{
  struct stat buf;
  int fd;

  fd = open(filename, 0);
  fstat(fd, &buf);
  close(fd);
  return(buf.st_size);
}

void am_perror(s)
     char *s;
{
  perror(s);
}

FILE *am_popen(s, type)
     char *s, *type;
{
#ifdef NOPOPEN
  fprintf(stderr, "\nam_popen: popen not supported on this platform!\n");
  return(NULL);
#else
  return ( popen(s, type) );
#endif

}

int am_pclose(stream)
     FILE *stream;
{
#ifdef NOPOPEN
  fprintf(stderr, "\nam_pclose: pclose not supported on this platform!\n");
  return(0);
#else
  fclose(stream); /* this seems to be necessary on the NeXT??? */
  return ( pclose(stream) );
#endif

}
