/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

/* This defines OS specific headers, constants, math stuff, etc. */

#ifndef AM_OS_HEADER

# define AM_OS_HEADER
# define DEFAULT_HEADERS 


#ifdef __GNUC__

# define alloca __builtin_alloca

#else /* Not GNU C.  */

# define alloca am_alloc_mem
# if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
#  undef alloca
#  include <alloca.h>
# endif /* Sparc.  */

#endif /* Not GNU C.  */


#ifdef ANSI_COMPILER

# undef  DEFAULT_HEADERS 
# define ANSI_HEADERS

#endif

#ifdef SKYBOLT /* Sky i860 Coprocessor */

#include <vector.h>
extern int skyvec_ ;   /* holds vector length */
# define PADDING 4
# define NO_SYSTEM /* no unix system calls */
# define NOPOPEN
#endif


#ifdef MC860 /* Mercury i860 Coprocessor */
# define PADDING 4
# define NO_SYSTEM /* no unix system calls */
# define NOPOPEN
#endif

#ifdef MEIKO860 /* Meiko i860 Coprocessor */
# define PADDING 4
# define NOPOPEN
#endif


#ifdef IWARP
# define NO_SYSTEM /* no unix system calls */
# define NOPOPEN
# undef  DEFAULT_HEADERS 

/* iwarp Unix Headers */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <filehdr.h>
#include <sys/stat.h>
#include <ctype.h>
#include <math.h>

#endif


#ifdef ANSI_HEADERS

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <float.h>
#include <sys/types.h>
#include <sys/stat.h>

extern int read(), write(), open(), close(), creat(), fstat(); 

#endif


#ifdef DEFAULT_HEADERS 

/* Normal Unix Headers */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <ctype.h>
#include <math.h>

#endif


/* ############################## MATH #################################### */

typedef struct {
  double real, imag;
} AM_COMPLEX;

#define DEFAULT_MATH


#ifdef CONVEX

#define AM_CEIL(x) (ceil((double)(x)))
#define AM_LOG10(x) (log10((double)(x)))
#define AM_LOG(x) (log((double)(x)))
#define AM_COS(x) (cos((double)(x)))
#define AM_SIN(x) (sin((double)(x)))
#define AM_ACOS(x) (acos((double)(x)))
#define AM_POW(x,y) (pow((double)(x),(double)(y)))
#define AM_EXP(x) (exp((double)(x)))
#define AM_FABS(x) (fabs((double)(x)))
#define AM_FMOD(x,y) (( ((float)((x))/(float)(y)) - ((int)((x))/(int)(y)) ))

extern long random();
#define AM_RANDOM_RANGE 2147483647.0
#define AM_RANDOM() ( ((float)random()) / (AM_RANDOM_RANGE + 1.0) )
#define AM_SEED_RANDOM(x) ((void)srandom((int)(x)))

#define AM_HUGE_VAL HUGE

#undef DEFAULT_MATH

#endif


#ifdef MC860

#define AM_CEIL(x) (ceil((double)(x)))
#define AM_LOG10(x) (log10((double)(x)))
#define AM_LOG(x) (log((double)(x)))
#define AM_COS(x) (cos((double)(x)))
#define AM_SIN(x) (sin((double)(x)))
#define AM_ACOS(x) (acos((double)(x)))
#define AM_POW(x,y) (pow((double)(x),(double)(y)))
#define AM_SQRT(x) (sqrt((double)(x)))
#define AM_EXP(x) (exp((double)(x)))
#define AM_FABS(x) (fabs((double)(x)))
#define AM_FMOD(x,y) ( (float)fmod((double)((x)),(double)(y)) )

extern int rand();
extern void srand();
#define AM_RANDOM_RANGE RAND_MAX
#define AM_RANDOM() ( ((float)rand()) / (AM_RANDOM_RANGE + 1.0) )
#define AM_SEED_RANDOM(x) ((void)srand((int)(x)))

#define AM_HUGE_VAL FLT_MAX

#undef DEFAULT_MATH

#endif

#ifdef SKYBOLT

#define AM_CEIL(x) (ceil((double)(x)))
#define AM_LOG10(x) (log10((double)(x)))
#define AM_LOG(x) (log((double)(x)))
#define AM_COS(x) (cos((double)(x)))
#define AM_SIN(x) (sin((double)(x)))
#define AM_ACOS(x) (acos((double)(x)))
#define AM_POW(x,y) (pow((double)(x),(double)(y)))
#define AM_SQRT(x) (sqrt((double)(x)))
#define AM_EXP(x) (exp((double)(x)))
#define AM_FABS(x) (fabs((double)(x)))
#define AM_FMOD(x,y) ( (float)fmod((double)((x)),(double)(y)) )

extern int rand();
extern void srand();
#define AM_RANDOM_RANGE RAND_MAX
#define AM_RANDOM() ( ((float)rand()) / (AM_RANDOM_RANGE + 1.0) )
#define AM_SEED_RANDOM(x) ((void)srand((int)(x)))

#define AM_HUGE_VAL FLT_MAX

#undef DEFAULT_MATH

#endif


#ifdef MEIKO860

#define AM_CEIL(x) (ceil((double)(x)))
#define AM_LOG10(x) (log10((double)(x)))
#define AM_LOG(x) (log((double)(x)))
#define AM_COS(x) (cos((double)(x)))
#define AM_SIN(x) (sin((double)(x)))
#define AM_ACOS(x) (acos((double)(x)))
#define AM_POW(x,y) (pow((double)(x),(double)(y)))
#define AM_SQRT(x) (sqrt((double)(x)))
#define AM_EXP(x) (exp((double)(x)))
#define AM_FABS(x) (fabs((double)(x)))
#define AM_FMOD(x,y) ( (float)fmod((double)((x)),(double)(y)) )

extern int rand();
extern void srand();
#define AM_RANDOM_RANGE RAND_MAX
#define AM_RANDOM() ( ((float)rand()) / (AM_RANDOM_RANGE + 1.0) )
#define AM_SEED_RANDOM(x) ((void)srand((int)(x)))

#define AM_HUGE_VAL FLT_MAX

#undef DEFAULT_MATH

#endif



#ifdef NEXT

#define AM_CEIL(x) (ceil((double)(x)))
#define AM_ATANH(x) (atanh((double)(x)))
#define AM_LOG10(x) (log10((double)(x)))
#define AM_LOG(x) (log((double)(x)))
#define AM_COS(x) (cos((double)(x)))
#define AM_SIN(x) (sin((double)(x)))
#define AM_ACOS(x) (acos((double)(x)))
#define AM_POW(x,y) (pow((double)(x),(double)(y)))
#define AM_SQRT(x) (sqrt((double)(x)))
#define AM_EXP(x) (exp((double)(x)))
#define AM_FABS(x) (fabs((double)(x)))
#define AM_FMOD(x,y) ( (float)fmod((double)((x)),(double)(y)) )

extern int rand();
extern void srand();
#define AM_RANDOM_RANGE 2147483647.0
#define AM_RANDOM() ( ((float)rand()) / (AM_RANDOM_RANGE + 1.0) )
#define AM_SEED_RANDOM(x) ((void)srand((int)(x)))

 /* What's the biggest float ? */
# ifdef MAXFLOAT
#    define AM_HUGE_VAL MAXFLOAT
# else
#    ifdef HUGE_VAL
#       define AM_HUGE_VAL HUGE_VAL
#    else
#       ifdef HUGE
#         define AM_HUGE_VAL HUGE
#       else
#         define AM_HUGE_VAL (infinity())
#       endif
#    endif
# endif

#undef DEFAULT_MATH

#endif



#ifdef DEFAULT_MATH
/* use typical math.h functions */

#define AM_CEIL(x) (ceil((double)(x)))
#define AM_ATANH(x) (atanh((double)(x)))
#define AM_LOG10(x) (log10((double)(x)))
#define AM_LOG(x) (log((double)(x)))
#define AM_COS(x) (cos((double)(x)))
#define AM_SIN(x) (sin((double)(x)))
#define AM_ACOS(x) (acos((double)(x)))
#define AM_POW(x,y) (pow((double)(x),(double)(y)))
#define AM_SQRT(x) (sqrt((double)(x)))
#define AM_EXP(x) (exp((double)(x)))
#define AM_FABS(x) (fabs((double)(x)))
#define AM_FMOD(x,y) ( (float)fmod((double)((x)),(double)(y)) )

extern double drand48();                           /* for random init */
extern void srand48();                             /* for random init */

#define AM_RANDOM() ((float)drand48())
#define AM_SEED_RANDOM(x) (srand48((long)(x)))

 /* What's the biggest float ? */
# ifdef MAXFLOAT
#    define AM_HUGE_VAL MAXFLOAT
# else
#    ifdef HUGE_VAL
#       define AM_HUGE_VAL HUGE_VAL
#    else
#       ifdef HUGE
#         define AM_HUGE_VAL HUGE
#       else
#         define AM_HUGE_VAL (infinity())
#       endif
#    endif
# endif

#endif


/* PI */
#define AM_PI 3.14159265358979323846


/* ############################ VECTOR ############################ */

/* For machine specific vector compilation of BpSim.c */

/* Port to Convex */
#ifdef CONVEX 
#  define SDOT  sdot_
#  define SAXPY saxpy_
#  define SCOPY scopy_
#  define SGEMV sgemv_
#  define SSCAL sscal_
#endif


/* Port to Meiko i860 Coprocessor Board */
#ifdef MEIKO860 
#  define SDOT  sdot_
#  define SAXPY saxpy_
#  define SCOPY scopy_
#  define SGEMV sgemv_
#  define SSCAL sscal_
#endif


/* Some vectorizing compilers are very STUPID and 
   insist on only vectorizing using "for" loops.
   Will FORTRAN ever die?
   If this is the case on your system then
   define FORLOOPS and the "while" loops
   on the basic vector routines will be 
   turned into "for" loops.
*/


#ifdef CONVEX
#  define FORLOOPS 1
#endif

/* default */
#ifndef FORLOOPS
#  define FORLOOPS 0
#endif

/* ############################ bcopy ############################ */

#ifndef bcopy
# define bcopy(s1,s2,n) memcpy(s2,s1,n)
#endif

#ifndef bzero
# define bzero(s,n) memset(s,0,n)
#endif

/* use real bcopy */
#ifdef CONVEX 
# undef bcopy
#endif

/* ############################ cpp ############################ */

#ifdef CRAY
# define CPP_CMD "/lib/pcpp"
#endif

#ifndef CPP_CMD
# define CPP_CMD "/lib/cpp"
#endif

/* ############################ copyright ############################ */

#define BASIC_COPYRIGHT "Copyright (C) 1988,1989,1990,1991,1992 The MITRE Corporation."

/* rules of the road... */
#define MITRE_COPYRIGHT "\n\n\n    ****************   NO WARRANTY  *****************\n\
Since the Aspirin/MIGRAINES system is licensed free of charge,\n\
the MITRE Corporation provides absolutley no warranty. Should\n\
the Aspirin/MIGRAINES system prove defective, you must assume\n\
the cost of all necessary servicing, repair or correction.\n\
In no way will the MITRE Corporation be liable to you for\n\
damages, including any lost profits, lost monies, or other\n\
special, incidental or consequential damages arising out of\n\
the use or in ability to use the Aspirin/MIGRAINES system.\n\
\n\
    *****************   COPYRIGHT  *******************\n\
This software is the copyright of The MITRE Corporation. \n\
It may be freely used and modified for research and development\n\
purposes. We require a brief acknowledgement in any research paper\n\
or other publication where this software has made a significant\n\
contribution. If you wish to use it for commercial gain, you must\n\
contact The MITRE Corporation for conditions of use. The MITRE\n\
Corporation provides absolutely NO WARRANTY for this software.\n\
"

#define EMAIL "leighton@mitre.org or russ@dash.mitre.org"

#endif  /* end AM_OS_HEADER */




/* exported functions from $NNTOOLS/os */

extern void am_free_mem();
extern char *am_alloc_mem();
extern int am_system();
extern void am_close();
extern void am_fclose();
extern void am_perror();
extern int am_fread();
extern int am_read();
extern int am_write();
extern int am_create();
extern int am_open();
extern int am_file_size();
extern int am_pclose();
extern char *am_mktemp();
extern FILE *am_freopen();
extern FILE *am_fopen();
extern FILE *am_popen();
extern void am_remove_cpp_file();
extern char *am_cpp();
