/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

/*  A Bison parser, made from aspirin_yacc.y  */

#define	NEWLINE	258
#define	INPUT_FIELDS	259
#define	INPUT_SIZE	260
#define	COMPONENTS	261
#define	OUTPUT_LAYER	262
#define	INPUTS_FROM	263
#define	STATIC	264
#define	CLRDELAYS	265
#define	UPDATE_INTERVAL	266
#define	DISABLE_FEEDBACK_LEARNING	267
#define	DISABLE_FEEDFORWARD_LEARNING	268
#define	INPUT_FILTER	269
#define	OUTPUT_FILTER	270
#define	ERROR_FUNCTION	271
#define	BBD	272
#define	ORDER	273
#define	PDPNODE1	274
#define	PDPNODE2	275
#define	PDPNODE3	276
#define	LINEAR_NODE	277
#define	QUAD_NODE	278
#define	USER_NODE	279
#define	CONJ	280
#define	DIMENSION	281
#define	LOAD_DATA	282
#define	INTO	283
#define	FROM	284
#define	IN	285
#define	LINE_SRCH	286
#define	LINE_SRCH_VERBOSE	287
#define	CONJ_GRAD	288
#define	NUMBER	289
#define	NAME	290
#define	QUOTE	291
#define	COMMA	292
#define	LCP	293
#define	RCP	294
#define	RP	295
#define	LP	296
#define	LB	297
#define	RB	298
#define	TESSELLATION	299
#define	SHARED	300
#define	WITH	301
#define	USING	302
#define	XOVERLAP	303
#define	YOVERLAP	304
#define	XOFFSET	305
#define	YOFFSET	306
#define	AT	307
#define	TIME	308
#define	INIT	309
#define	BIAS	310
#define	EQUALS	311

#line 13 "aspirin_yacc.y"

#include "aspirin.h"

#define TRUE 1
#define FALSE 0

/* some macros for symbol manipulation */
#define sym_name(string) (((SYM_PTR)fetch_dictionary(string, network->symbol_table))->pname)
#define sym_bbd(string) (((SYM_PTR)fetch_dictionary(string, network->symbol_table))->bbd)
#define sym_dict(string) (((SYM_PTR)fetch_dictionary(string, network->symbol_table))->dict)

/* input buffer */
static unsigned char yytext[256];
static int yyleng;
  
/* holds network structures */
ND_PTR network;

/* holds current black box decriptor */
static  BD_PTR current_bbd = (BD_PTR)NULL;

/* name of current layer */
static char *to_layer;

/* integer code for type of nodes in layer */
static int type;

/* x and y dimensions for a layer */
static int layer_xdim, layer_ydim;

/* x and y dimensions for a tessellation */
static int tess_xdim, tess_ydim;

/* x and y start offsets for a tessellation */
static int tess_xoffset, tess_yoffset;

/* x and y start overlap */
static int tess_xoverlap, tess_yoverlap;

/* string w/name of C user function to initialize weights */
static char *C_init_function = NULL;

/* strings w/names of C user transfer and derivative functions */
static char *C_transfer = NULL;
static char *C_transfer_prime = NULL;

/* int var for order of node feedback */
static int layer_order = 0;

/* init vars for layer thresholds */
static int bias_init;
static float layer_bias;      /* constant */
static char *layer_bias_init; /* C function */

/* used to hold delay info */
DD delay_struct;

/* globals for the parser, used for error messages */
int lineno = 1; 
static char *aspirin_file;




/*****************************************************/
/* make_name:  Make a new string by appending        */
/*             the black box name to the name;       */
/*             a '!' means that this string refers   */
/*             to another black box.                 */
/*****************************************************/
static char *make_name(name, bbd)
     char *name;
     BD_PTR bbd;
{
  extern BD_PTR current_bbd;
  char *black_box_name = bbd->name;
  char *new_string;
  SYM_PTR sym_ptr; 
  
  /* if this is a reference to an extrernal black box
     then just return the black box name.
     */
  if (*name == '!')
    {
      new_string = ++name;
      /* record this name in the current black box
         as being an external input
       */
      insert_dictionary(new_string,
			(GENERIC_PTR)new_string,
			current_bbd->input_bbds); 
    }/* end if */
  /* those symbols prepended with '$' are special and should be returned */
  else if (*name == '$')
    {
      return(name);
    }/* end if */
  /* else this is a symbol in this black box, so
     prepend the black box name.
     */
  else
    {
      new_string = am_alloc_mem(strlen(name) + strlen(black_box_name) + 2); /* add 2 for ':' and \0 */
      sprintf(new_string, "%s:%s", black_box_name, name);
    }/* end else */

  /* record this symbol in global symbol table,
     uses structure like LISP atom...sort of
   */
  sym_ptr = (SYM_PTR)am_alloc_mem(sizeof(SYM_STRUCT));
  sym_ptr->black_box = current_bbd;
  sym_ptr->dict = current_bbd->lookup,
  sym_ptr->pname = name;
  insert_dictionary(new_string,
		    (GENERIC_PTR)sym_ptr,
		    network->symbol_table); 

  return(new_string);
}/* end  make_name */

/*****************************************************/
/* warning                                           */
/*        Print warning message.                     */
/*****************************************************/
static void warning(s, t)
     char *s, *t;
{
  fprintf(stderr, "\n%s: %s", aspirin_file, s);
  if (t != (char *)NULL) fprintf(stderr, "  %s", t);
  
}


/*****************************************************/
/* yyerror                                           */
/*        Called by yacc for syntax errors.          */
/*****************************************************/
int yyerror (s)
     char *s;
{
  char where[50];

  *where = '\0'; /* empty */
  if (yytext != (unsigned char *)NULL)
    {  char *token = am_alloc_mem(yyleng + 1);

       bcopy(yytext, token, yyleng);
       token[yyleng] = '\0'; /* end of string */
       sprintf(where, "(near \"%s\" somewhere around line %d)\n", yytext, lineno);
       am_free_mem(token);
    }/* end if */

  warning(s, where);
  exit(1);
}


/*****************************************************/
/* create_matrix_name                                */
/*        Make a string of the right size.           */
/*****************************************************/
static char *create_matrix_name(to,connection_number)
     char *to;
     int connection_number;
{
  int string_size;
  char *name;

  to = sym_name(to);

  /* because this is used in macro names for cpp and
     some cpp's puke if the names are too big 
  */
  if (strlen(to) > 14) 
    yyerror("\nLayer name is greater than 14 characters! (sorry)");

  string_size = 1; /* for cr */

  if (connection_number < 10) /* 1 character */
    string_size++;
  else
    string_size += (int)AM_CEIL(AM_LOG10((double)(connection_number)));

  string_size += strlen(to);

  name = (char *)am_alloc_mem(string_size);

  sprintf(name, "%s%d",to,connection_number);

  return(name);
  
}/* end create_matrix_name */

/*****************************************************/
/* copy_connection Return a copy of the connection.  */
/*****************************************************/
static CD_PTR copy_connection(connection)
     CD_PTR connection;
{
  CD_PTR new_connection;

  new_connection = (CD_PTR)am_alloc_mem(sizeof(CD));
  bcopy((char *)connection, (char *)new_connection, sizeof(CD));
  return(new_connection);
  
}/* end copy_connection */

/*****************************************************/
/* create_connection                                 */
/*        Create a connection structure              */
/*****************************************************/
static CD_PTR create_connection(from, to, type, shared,
			 xoffset, xrange, xoverlap,
			 yoffset, yrange, yoverlap,
			 init_function, delay, order)

     char *from, *to;
     int type, shared;
     int xoffset, yoffset; /* used for tessellation */
     int xrange, xoverlap; /* used for tessellation functions */
     int yrange, yoverlap; /* used for tessellation functions */
     int init_function;    /* code for type of weight initialization */
     DD_PTR delay;         /* connected at this time delay */
     int order;            /* the order of the connection */
{
  extern BD_PTR current_bbd;
  CD_PTR new_connection;

  /*** ERROR CHECKS ***/
  
  if ((xrange < xoverlap) || (xoverlap < 0))
    {
      yyerror("Your tessellation x-overlap is greater than your tessellation.");
    }/* end if */

  if ((yrange < yoverlap) || (xoverlap < 0))
    {
      yyerror("Your tessellation y-overlap is greater than your tessellation.");
    }/* end if */

  /* record */
  current_bbd->n_cds += 1;

  /* create a new connection structure */
  new_connection = (CD_PTR)am_alloc_mem(sizeof(CD));
  new_connection->from = from;
  new_connection->to = to;
  if (delay->n) network->temporal = TRUE;  /* there is state info */
  if (delay->start > 0 || delay->end > 0 )
    yyerror("Your delay time cannot be a positive integer!");
  new_connection->delay.start = -1 * delay->start;
  new_connection->delay.end = -1 * delay->end;
  new_connection->delay.n = -1 * delay->n;
  new_connection->delay.next = (DD_PTR)NULL;
  new_connection->lookup = create_dictionary();
  new_connection->type = type; 
  new_connection->shared = shared;
  new_connection->xoffset = xoffset;
  new_connection->xrange = xrange;
  new_connection->xoverlap = xoverlap;
  new_connection->yoffset = yoffset;
  new_connection->yrange = yrange;
  new_connection->yoverlap = yoverlap;
  new_connection->next = (CD_PTR)NULL;
  new_connection->array_name = create_matrix_name(to,current_bbd->n_cds);
  new_connection->size = 0; /* reset */
  new_connection->first_order_size = 0; /* reset */
  new_connection->second_order_size = 0; /* reset */

  /* order of connection */
  if (order == 0 || order > 1)
    yyerror("Only 1st order connections are supported!");
  new_connection->order = order;

  /* function to initialize weights */
  new_connection->init_function = init_function;

  if (init_function == C_INIT)
    {
      new_connection->C_init = C_init_function; /* set the name of user function */
    }/* end else if */
  else if (init_function == CONSTANT_INIT) /* not presently used */
    {
      new_connection->constant = 0.0;
    }/* end else if */      

  return(new_connection);
  
} /* end create_connection */

/*****************************************************/
/* insert_TDNN_connection:                           */
/*        Inserts connections with unique [start,end]*/
/*****************************************************/
static DD_PTR insert_TDNN_connection(list, delay)
     DD_PTR list, delay;
{
  DD_PTR ptr = list;

  if (delay->end == delay->start) return(list);       /* is  a TDNN style ? */

  if (list == (DD_PTR)NULL) return(delay); /* first one */

  while(1) {

    if (ptr->start == delay->start &&  /* not unique, no insert */
	ptr->end == delay->end)
      break;

    if (ptr->next == (DD_PTR)NULL) {
      ptr->next = delay;
      break;
    }
      
    ptr = ptr->next;
  }
  
  return(list);
}

/*****************************************************/
/* create_layer                                      */
/*        Create a layer structure                   */
/*****************************************************/
static LD_PTR create_layer (name, size, xdim, ydim, input_connections)
     char *name;
     int size, xdim, ydim;
     CD_PTR input_connections;
{
  extern BD_PTR current_bbd;
  extern int type;
  LD_PTR new_layer;
  DICTIONARYPTR d;


  new_layer = (LD_PTR)am_alloc_mem(sizeof(LD));
  new_layer->name = name;
  new_layer->type = type; /* this was set in a production */
  if (size <= 0) yyerror("\nThe number of nodes is <= 0.");
  new_layer->n_nodes = size;
  new_layer->xdim = xdim;
  new_layer->ydim = ydim;

  if (layer_order) network->temporal = TRUE; /* time varying */
  new_layer->last_delay = layer_order;
  new_layer->layer_order = layer_order;
  /* little hack...probably doesn't belong here */
  if (layer_order < 0 || layer_order > 2)               
    yyerror("\nLayer order must be between 0 and 2.");
  layer_order = 0; /* reset */

  new_layer->TDNN_connections = (DD_PTR)NULL;
  new_layer->bbd = current_bbd; /* back pointer */
  new_layer->inputs_from = input_connections;
  new_layer->next = (LD_PTR)NULL;
  new_layer->previous = (LD_PTR)NULL;

  new_layer->init_function = bias_init;
  new_layer->C_transfer = C_transfer;
  new_layer->C_transfer_prime = C_transfer_prime;
  C_transfer_prime = C_transfer = (char *)NULL;   /* reset */
  if (bias_init == CONSTANT_INIT) new_layer->bias = layer_bias;
  else if (bias_init == C_INIT) new_layer->C_bias_init = layer_bias_init;

  new_layer->lookup = create_dictionary();
  /* add the new nodes to the total */
  current_bbd->n_nodes += size;
  /* record a new layer */
  new_layer->number = current_bbd->n_layers;
  current_bbd->n_layers += 1;
  d = current_bbd->lookup;
  if(fetch_dictionary(name, d) != (GENERIC_PTR)NULL)
    yyerror("\nRedefined layer\n"); 
  insert_dictionary(name, (GENERIC_PTR)new_layer, d); 
  /* this is the current to_layer */
  return(new_layer);
  
}/* end create_layer */

/*****************************************************/
/* create_black_box                                  */
/*             create a black box descriptor and     */
/*             store it in the network dictionary    */
/*****************************************************/
static void create_black_box(name)
     char *name;
{
  extern ND_PTR network;
  extern BD_PTR current_bbd;
  DICTIONARYPTR d;
  BD_PTR bbd;

  d = network->lookup; 
  bbd = (BD_PTR)am_alloc_mem(sizeof(BD));
  if(fetch_dictionary(name, d) != (GENERIC_PTR)NULL)
    yyerror("\nRedefined black box\n");
  insert_dictionary(name, (GENERIC_PTR)bbd, d);
  current_bbd = bbd;
  bbd->name = name;
  /* assign an index to black box */
  bbd->number = network->n_bbds;
  network->n_bbds++;
  bbd->lookup = create_dictionary();
  bbd->input_bbds = create_dictionary();
  bbd->output_bbds = create_dictionary();
  bbd->n_nodes = 0;
  bbd->n_layers = 0;
  bbd->n_cds = 0;
  bbd->n_inputs = 0;
  bbd->clear_delay = 0;
  bbd->update_interval = 1; /* default */
  bbd->last_input_delay = 0;
  bbd->TDNN_connections = (DD_PTR)NULL;
  bbd->n_outputs = 0;
  bbd->dynamic = BBDYNAMIC;
  bbd->ar_learning = TRUE;
  bbd->ff_learning = TRUE;
  bbd->input_connections = (CD_PTR)NULL;
  bbd->output_layer_name = (char *)NULL;
  bbd->output_layer = (LD_PTR)NULL;
  bbd->input_filter = (char *)NULL;
  bbd->output_filter = (char *)NULL;
  bbd->error_function = (char *)NULL;
  bbd->efferent = 1; /* assume no one connects until someone does */
  bbd->layers = (LD_PTR)NULL;
  bbd->network = network; /* back pointer to root */
  bbd->n_bb_inputs = 0;
  bbd->n_bb_outputs = 0;

}/* end create_black_box */

/*****************************************************/
/* Create_network                                    */
/*        Create a network structure and store       */
/*        into a global variable.                    */
/*****************************************************/
static void create_network()
{
  extern char *aspirin_file;
  extern ND_PTR network;

  network = (ND_PTR)am_alloc_mem(sizeof(ND));

  network->name = aspirin_file; /* name of the aspirin file */

  network->temporal = FALSE; /* assume no feedback */

  network->line_search = NO_LINE_SEARCH; /* assume no line search */
  network->line_search_timeout = -1;
  network->line_search_update = -1;

  network->conjugate_gradient = NO_CONJ_GRAD; /* assume no conjugate gradient */

  network->n_bbds = 0; /* how many black box descriptiors */

  /* symbol tables */
  network->lookup = create_dictionary();
  network->symbol_table = create_dictionary(); /* maps symbol => dictionary */
    
}/* end create_network */

/*****************************************************/
/* update_connection: Error check, and keep sure all data is in place. */
/*****************************************************/
static void update_connection(connection, to_layer, from_layer, bbd)
     CD_PTR connection;
     LD_PTR to_layer, from_layer;
     BD_PTR bbd;
{
  char error_string[50];
  int xresidue, xretina_size, yresidue, yretina_size;
  int to_size, from_size;
  int to_xdim, from_xdim, to_ydim, from_ydim;
  
  to_size = to_layer->n_nodes;
  to_xdim = to_layer->xdim;
  to_ydim = to_layer->ydim;
  
  if (from_layer == (LD_PTR)NULL) { /* must be from the bb's input */
    from_xdim = bbd->inputs_xdim;
    from_ydim = bbd->inputs_ydim;
    from_size = bbd->n_inputs;
  } else {
    from_xdim = from_layer->xdim;
    from_ydim = from_layer->ydim;
    from_size = from_layer->n_nodes;
  }/* end if */
  
  
  /* fix the type (there is an ambiguity for 1D) */
  if (connection->type == TESS_1D_CONNECTION_TYPE &&
      from_ydim != 1)
    connection->type = TESS_2D_CONNECTION_TYPE; 
  
  connection->to_layer = to_layer;
  connection->from_layer = from_layer;
  connection->bbd = bbd;
  
  /* Check the connection structures */
  switch (connection->type)    {
  case NXM_CONNECTION_TYPE : {
    /* need to set the xrange, yrange here because
       this is the first time you have to info to do so.
       */
    connection->xrange = from_size;
    connection->yrange = 1;
    connection->xoverlap = from_size;
    connection->yoverlap = 0;
    break;
  }/* end case */
  case TESS_1D_CONNECTION_TYPE : {
    int x_unconnected = 0;
    
    /* check size */
    if (connection->xrange > from_xdim)
      {
	fprintf(stderr,
		"\nError: Connection from %s to %s has too large tessellation.\n",
		connection->to,
		connection->from);
	exit(1);
      }/* end if */
    /* check the mapping of receptive fields */
    xretina_size = ((to_xdim *
		     (connection->xrange -
		      connection->xoverlap))
		    + connection->xoverlap);
    xresidue = xretina_size - (from_xdim - connection->xoffset);
    if (xresidue < 0)
      {
	/* in this case the to_nodes do NOT connect to every 
	   from_node, but all are connected.
	   */
	printf("\nWarning: Connections of %s do not fully cover %s in the x direction.",
	       connection->to,
	       connection->from);
	x_unconnected = (-1 * xresidue);
	printf("\n         %s has %d nodes unconnected.",
	       connection->from,
	       x_unconnected);
	if (connection->xoffset > 0)
	  printf(" (plus %d from offset)", connection->xoffset);
      }/* end if */
    else if (xresidue > 0)
      {
	/* in this case the to_nodes may not connect
	   to a from node*/
	printf("\nError: Incomplete connections to %s from %s.\n",
	       connection->to,
	       connection->from);
	if ((xresidue / connection->xrange) > 0)
	  printf("\n      %d nodes in %s are not connected to %s in the x direction.\n",
		 (xresidue / connection->xrange),
		 connection->to,
		 connection->from);
	exit(1);
      }/* end else */
    /* record for future use */
    connection->xresidue = x_unconnected;
    
    break;
  }/* end case */
  case TESS_2D_CONNECTION_TYPE : {
    int xrange = connection->xrange;
    int yrange = connection->yrange;
    int xoverlap = connection->xoverlap;
    int yoverlap = connection->yoverlap;
    int x_unconnected = 0, y_unconnected = 0;
    
    /* check size */
    if (xrange > from_xdim) {
      fprintf(stderr,
	      "\nError: Connection from %s to %s has too large x tessellation.\n",
	      connection->to,
	      connection->from);
      exit(1);
    }/* end if */
    if (yrange > from_ydim) {
      fprintf(stderr,
	      "\nError: Connection from %s to %s has too large y tessellation.\n",
	      connection->to,
	      connection->from);
      exit(1);
    }/* end if */
    
    /* check the mapping of receptive fields in x dimension */
    xretina_size = ((to_xdim * (xrange - xoverlap)) + xoverlap);
    xresidue = xretina_size - (from_xdim - connection->xoffset);
    if (xresidue < 0)  {
      /* in this case the to_nodes do NOT connect to every 
	 from_node, but all are connected.
	 */
      printf("\nWarning: Connections of %s do not fully cover %s in the x dimension.",
	     connection->to,
	     connection->from);
      x_unconnected = (-1 * xresidue);
      printf("\n\t%d under shoot in the x dimension.",
	     x_unconnected);
      if (connection->xoffset > 0)
	printf(" (plus %d from offset)", connection->xoffset);
    }/* end if */
    else if (xresidue > 0) {
      /* in this case the to_nodes may not connect
	 to a from node*/
      printf("\nError: Incomplete connections to %s from %s.\n",
	     connection->to,
	     connection->from);
      if ((xresidue / connection->xrange) > 0)
	printf("\n      %d over shoot in x dimension.",
	       (xresidue / connection->xrange));
      exit(1);
    }/* end else */
    /* record for future use */
    connection->xresidue = x_unconnected;
    
    /* check the mapping of receptive fields in y dimension */
    yretina_size = ((to_ydim * (yrange - yoverlap)) + yoverlap);
    yresidue = yretina_size - (from_ydim - connection->yoffset);
    if (yresidue < 0)  {
      /* in this case the to_nodes do NOT connect to every 
	 from_node, but all are connected.
	 */
      printf("\nWarning: Connections of %s do not fully cover %s in the y dimension.",
	     connection->to,
	     connection->from);
      y_unconnected = (-1 * yresidue);
      printf("\n\t%d under shoot in the y dimension.",
	     y_unconnected);
      if (connection->yoffset > 0)
	printf(" (plus %d from offset)", connection->yoffset);
    }/* end if */
    else if (yresidue > 0) {
      /* in this case the to_nodes may not connect
	 to a from node*/
      printf("\nError: Incomplete connections to %s from %s.\n",
	     connection->to,
	     connection->from);
      if ((yresidue / connection->yrange) > 0)
	printf("\n      %d over shoot in y dimension.",
	       (yresidue / connection->yrange));
      exit(1);
    }/* end else */
    /* record for future use */
    connection->yresidue = y_unconnected;
    
    break;
  }/* end case */
    default :	{
      sprintf(error_string,
	      "Unknown connection type from %s to %s",
	      connection->from,
	      connection->to);
      warning(error_string, (char *)NULL);
    }/* end default */
  } /* end switch */  
  
}/* end check connection */

/*****************************************************/
/* update_io_dictionaries: Replace the string with
                            the named structure pointer.
			    Update output dictionary.
*/
/*****************************************************/
static void update_io_dictionaries(bbd_name)
     char *bbd_name;
{
  extern ND_PTR network;
  extern BD_PTR current_bbd;
  BD_PTR input_bbd;

  input_bbd = (BD_PTR)fetch_dictionary(bbd_name, network->lookup);

  /* inputs */
  insert_dictionary(bbd_name,
		    (GENERIC_PTR)input_bbd,
		    current_bbd->input_bbds);
  /* outputs */
  insert_dictionary(current_bbd->name,
		    (GENERIC_PTR)current_bbd,
		    input_bbd->output_bbds);

}/* end update_io_dictionaries */

/*****************************************************/
/* update_black_box:  Fill the slots, back pointers, etc. */
/*****************************************************/
static void update_black_box(bbd)
     BD_PTR bbd;
{
  extern ND_PTR network;
  DICTIONARYPTR d = bbd->lookup; /* holds the layers */
  LD_PTR out_layer, to_layer, from_layer; 
  CD_PTR input_connection, new_connection;
  BD_PTR from_bbd;
  int to_size;
  char error_string[64];

  /* add the outputs_to for every layer */
  to_layer = bbd->layers;
  while (to_layer != (LD_PTR)NULL)
    {
      /* for every input find the connected layer and update outputs */
      input_connection = to_layer->inputs_from;
      to_size = to_layer->n_nodes;
      while (input_connection != (CD_PTR)NULL)
	{
	  /* is from layer is $INPUTS?, then push connection into
	     input_connections.
	   */
	  if (strcmp(input_connection->from, "$INPUTS") == 0)
	    {
	      /* you cannot connect to $INPUTS if they don't exist */
	      if (bbd->n_inputs == 0)
		{
		  sprintf(error_string,
			  "\nLayer %s in black box %s needs InputSize-> declared.\n",
			  to_layer->name,
			  bbd->name);
		  fprintf(stderr, error_string);
		  fflush(stderr);
		  exit(1);
		}/* end if */

	      /* check connection structure */
	      update_connection(input_connection,
				to_layer,
				(LD_PTR)NULL,
				bbd);
	      new_connection = copy_connection(input_connection);
	      new_connection->next = bbd->input_connections;
	      bbd->input_connections = new_connection;
	      /* update the delay */
	      if (new_connection->delay.end > bbd->last_input_delay) {
		bbd->last_input_delay = new_connection->delay.end;
	      }
	      bbd->TDNN_connections = insert_TDNN_connection(bbd->TDNN_connections, &(new_connection->delay));

	    }/* end if */
	  else
	    {
	      from_layer = (LD_PTR)fetch_dictionary(input_connection->from, d);
	      /* if we cannot find the layer in this black box then
		 look for a black box with that name */
	      if (from_layer == (LD_PTR)NULL)
		 {
		   /* see if connection is to another black box */
		   from_bbd = (BD_PTR)fetch_dictionary(input_connection->from,
						       network->lookup);
 		   if (from_bbd == (BD_PTR)NULL)
		     {
		       sprintf(error_string,
			       "\nUnknown layer or black box name: %s\n",
			       input_connection->from);
		       fprintf(stderr, error_string);
		       exit(1);
		     }/* end if */
		   else
		     {
		       /* mark this black box as internal to the system */
		       from_bbd->efferent = 0;
		       /* inc inter bb connection counters */
		       bbd->n_bb_inputs++;
		       from_bbd->n_bb_outputs++;
		       /* update the layer outputs */
		       if (from_bbd->output_layer_name == (char *)NULL) 
			 {
			   fprintf(stderr,
				  "\nNo output layer declared for black box.");
			   exit(1);
			 }/* end if */
		       from_layer =
			 ((LD_PTR)
			  fetch_dictionary(from_bbd->output_layer_name,
					   from_bbd->lookup));
		       /* check connection structure */
		       update_connection(input_connection,
					 to_layer,
					 from_layer,
					 bbd);
                       new_connection = copy_connection(input_connection);
		       new_connection->next = from_layer->outputs_to;
		       from_layer->outputs_to = new_connection; 
		       /* update the delay */
		       if (new_connection->delay.end > from_layer->last_delay) {
			 from_layer->last_delay = new_connection->delay.end;
		       }
		       from_layer->TDNN_connections = insert_TDNN_connection(from_layer->TDNN_connections,
									     &(new_connection->delay));
		     }/* end else */
		 }/* end if */
	      else
		{
		  /* check connection structure */
		  update_connection(input_connection,
				    to_layer,
				    from_layer,
				    bbd);
		  new_connection = copy_connection(input_connection);
		  new_connection->next = from_layer->outputs_to;
		  from_layer->outputs_to = new_connection;
		  /* update the delay */
		  if (new_connection->delay.end > from_layer->last_delay) {
		    from_layer->last_delay = new_connection->delay.end;
		  }
		  from_layer->TDNN_connections = insert_TDNN_connection(from_layer->TDNN_connections,
									&(new_connection->delay));
		}/* end else */
	    }/* end else */

	  /* next */
	  input_connection = input_connection->next;
	}/* end while */
      /* next */
      to_layer = to_layer->next;
    }/* end while */

  /* add the output layer */
  if (bbd->output_layer_name == (char *)NULL) 
    {
      fprintf(stderr, "\nNo output layer declared for black box.");
      exit(1);
    }/* end if */
  out_layer = (LD_PTR)fetch_dictionary(bbd->output_layer_name, d);
  if (out_layer == (LD_PTR)NULL)
    {
      fprintf(stderr, "\nUnknown output layer declared for black box.");
      exit(1);
    }/* end if */
  bbd->output_layer = out_layer;
  bbd->n_outputs = out_layer->n_nodes;

  /* error check */
  if(bbd->n_outputs <= 0)
    {
      fprintf(stderr, "Number of outputs to black box <= 0");
      exit(1);
    }/* end if */
  
  /* update the dictionary holding the input
     black box names with an actual structure
     pointer.
   */
  current_bbd = bbd;
  map_dictionary(update_io_dictionaries, bbd->input_bbds);

}/* end update_black_box */

/*****************************************************/
/* update     Link all the data structures.
 */
/*****************************************************/
static void update()
{
  extern ND_PTR network;

  /* update the connection structures */
  map_dictionary(update_black_box, network->lookup);
  
}/* end update */

/*****************************************************/
/* mark_static_black_boxes Change a BBSTATIC -> BBSTATIC_DEPEND.
*/
/*****************************************************/
static mark_static_black_boxes(bbd)
     BD_PTR bbd;
{
  if ( bbd->dynamic == BBSTATIC)  bbd->dynamic = BBSTATIC_DEPEND;
}/* end mark_static_black_boxes */

/*****************************************************/
/* depend_black_box  for every BBDYNAMIC or BBSTATIC_DEPEND black box,
                     if it outputs to another black box,
                     then check all black boxes that
                     depend on this black box and
                     mark static bbs as BBSTATIC_DEPEND. 
*/
/*****************************************************/
static void depend_black_box(bbd)
     BD_PTR bbd;
{
  if ( bbd->dynamic == BBSTATIC) return;

  if ( bbd->n_bb_outputs ) { /* if I output to another bb */

    map_dictionary(mark_static_black_boxes, bbd->output_bbds);

  }/* end if */

}/* end depend_black_box */


/*****************************************************/
/* check_dependencies   Make sure static bbs are
                        marked if there is a dependence.
 */
/*****************************************************/
static void check_dependencies()
{
  extern ND_PTR network;
  int n_bbds = network->n_bbds;

  /* looping for n_bbds guarantees all dependencies
     have been checked (brush fire search).
   */
  while(n_bbds--)
    map_dictionary(depend_black_box, network->lookup);
  
}/* end check_dependencies */



#line 932 "aspirin_yacc.y"
typedef union {
	int i;    /* integer                */
	float f;  /* float                  */
	char *s;  /* string                 */
	DD_PTR d; /* delay struct  ptr      */
	CD_PTR c; /* connection struct ptr  */
	LD_PTR l; /* layer struct ptr       */
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		164
#define	YYFLAG		-32768
#define	YYNTBASE	57

#define YYTRANSLATE(x) ((unsigned)(x) <= 311 ? yytranslate[x] : 87)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
    56
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
  1042,  1043,  1046,  1047,  1048,  1049,  1054,  1059,  1068,  1069,
  1072,  1090,  1091,  1094,  1097,  1100,  1103,  1104,  1115,  1116,
  1119,  1122,  1125,  1126,  1130,  1144,  1145,  1146,  1147,  1148,
  1154,  1156,  1162,  1163,  1164,  1169,  1170,  1176,  1186,  1196,
  1206,  1216,  1228,  1240,  1259,  1264,  1267,  1272,  1273,  1282,
  1299,  1321,  1322,  1326,  1331,  1336,  1344,  1345,  1350,  1351,
  1359,  1364,  1369,  1378,  1381,  1385,  1392,  1395,  1399,  1403,
  1409,  1412,  1416,  1420,  1427,  1430,  1435,  1440,  1446,  1447,
  1452,  1454
};

static const char * const yytname[] = {     0,
"error","$illegal.","NEWLINE","INPUT_FIELDS","INPUT_SIZE","COMPONENTS","OUTPUT_LAYER","INPUTS_FROM","STATIC","CLRDELAYS",
"UPDATE_INTERVAL","DISABLE_FEEDBACK_LEARNING","DISABLE_FEEDFORWARD_LEARNING","INPUT_FILTER","OUTPUT_FILTER","ERROR_FUNCTION","BBD","ORDER","PDPNODE1","PDPNODE2",
"PDPNODE3","LINEAR_NODE","QUAD_NODE","USER_NODE","CONJ","DIMENSION","LOAD_DATA","INTO","FROM","IN",
"LINE_SRCH","LINE_SRCH_VERBOSE","CONJ_GRAD","NUMBER","NAME","QUOTE","COMMA","LCP","RCP","RP",
"LP","LB","RB","TESSELLATION","SHARED","WITH","USING","XOVERLAP","YOVERLAP","XOFFSET",
"YOFFSET","AT","TIME","INIT","BIAS","EQUALS","aspirin"
};
#endif

static const short yyr1[] = {     0,
    57,    57,    58,    58,    58,    58,    58,    58,    59,    59,
    60,    61,    61,    62,    62,    62,    62,    62,    63,    63,
    64,    65,    66,    66,    67,    67,    67,    67,    67,    67,
    67,    67,    67,    67,    67,    68,    68,    69,    70,    70,
    70,    70,    70,    70,    70,    71,    72,    73,    73,    74,
    74,    75,    75,    76,    76,    76,    77,    77,    78,    78,
    79,    79,    79,    80,    80,    80,    81,    81,    81,    81,
    82,    82,    82,    82,    83,    83,    83,    83,    84,    84,
    85,    86
};

static const short yyr2[] = {     0,
     1,     2,     1,     1,     1,     3,     3,     1,     1,     2,
     7,     1,     2,     3,     4,     4,     2,     3,     1,     2,
     5,     1,     1,     2,     2,     4,     1,     1,     1,     2,
     2,     2,     2,     2,     2,     1,     2,     6,     2,     2,
     2,     2,     2,     4,     1,     1,     2,     1,     3,     4,
    12,     0,     3,     0,     6,    10,     0,     1,     0,     3,
     1,     3,     5,     1,     3,     5,     0,     6,     3,     3,
     0,     6,     3,     3,     0,     3,     3,     1,     0,     3,
     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     0,     0,     0,     8,     0,     1,     4,     9,
     5,    12,     3,    19,    82,     0,    17,    22,     0,     0,
     0,     0,     2,    10,    13,    20,    18,     0,    14,     0,
     0,     6,     7,    16,    15,     0,     0,     0,    27,     0,
     0,    28,    29,     0,     0,     0,     0,    23,     0,     0,
    25,    61,     0,    31,    30,    32,    33,    34,    35,    21,
    24,     0,     0,     0,     0,     0,     0,     0,     0,    45,
     0,    36,     0,     0,     0,    62,    39,    40,    41,    42,
    43,     0,    26,    37,    75,    11,     0,     0,     0,     0,
     0,    78,    63,    44,     0,     0,     0,    80,    81,    77,
    76,     0,     0,    46,    52,    47,    48,    38,     0,    54,
     0,     0,     0,    59,    49,    53,     0,     0,     0,    50,
     0,    57,     0,     0,    58,     0,    60,     0,     0,     0,
     0,    64,     0,    55,     0,    67,     0,     0,    65,     0,
    71,     0,     0,     0,     0,    59,     0,    66,    69,    70,
     0,     0,    56,     0,    73,    74,    51,     0,     0,    68,
     0,    72,     0,     0
};

static const short yydefgoto[] = {     7,
     8,     9,    10,    11,    12,    13,    14,    19,    47,    48,
    71,    72,    73,   103,   104,   106,   107,   110,   114,   126,
   120,    51,   131,   141,   146,    91,    92,   101,    52
};

static const short yypact[] = {    51,
     7,   -22,    29,    14,    14,-32768,    44,-32768,    31,-32768,
    57,-32768,    45,-32768,-32768,    11,    28,-32768,    26,    30,
    14,    14,-32768,-32768,-32768,-32768,-32768,    32,    14,   103,
    37,-32768,-32768,-32768,-32768,   -28,    34,    35,-32768,    14,
    14,-32768,-32768,    38,    46,    56,    20,-32768,    58,    14,
-32768,-32768,   -12,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,    39,   -24,    60,    61,    62,    63,    64,    65,-32768,
    66,-32768,   -28,    67,    14,-32768,-32768,-32768,-32768,-32768,
-32768,    68,-32768,-32768,   -17,-32768,    36,    69,    24,    50,
    54,-32768,-32768,-32768,    14,    18,    99,-32768,-32768,-32768,
-32768,    85,    82,-32768,   104,   101,-32768,-32768,    72,    78,
    85,    14,    83,    -4,-32768,-32768,    79,    87,    88,-32768,
    75,    90,   105,   -18,-32768,     9,-32768,    14,    98,    14,
    97,-32768,   106,-32768,   -21,    95,    14,    14,-32768,    14,
   100,   102,   107,   -31,    14,    93,   108,-32768,   124,-32768,
     5,   111,-32768,    14,   127,-32768,-32768,   110,    14,-32768,
   109,-32768,   154,-32768
};

static const short yypgoto[] = {-32768,
   148,-32768,   147,-32768,   146,-32768,   149,-32768,-32768,   114,
-32768,    92,-32768,-32768,-32768,-32768,    53,-32768,-32768,-32768,
    19,    94,-32768,-32768,-32768,-32768,-32768,-32768,    -1
};


#define	YYLAST		167


static const short yytable[] = {    17,
    89,    75,    21,    22,   138,    15,    64,    65,    66,    67,
    68,    69,    18,    50,    28,    15,   149,   150,    76,    32,
    33,   139,    70,   128,    36,    37,    38,    35,    39,    40,
    41,    42,    43,    44,    45,    46,   118,    90,    55,    56,
    15,    16,    15,   163,    15,    27,     1,    15,    63,   119,
   130,    99,   100,     1,   155,   156,    20,     3,    60,     1,
     2,     2,    29,    30,    31,    49,    34,     2,    74,    54,
     3,    53,    57,    87,     4,     5,     6,     3,    93,    95,
    58,     4,     5,     6,    64,    65,    66,    67,    68,    69,
    59,    97,    62,    98,    77,    78,    79,    80,    81,    82,
    70,    86,    88,    94,    83,    96,   102,    36,    37,    38,
   116,    39,    40,    41,    42,    43,    44,    45,    46,   105,
   108,   109,   129,   117,   132,   111,   133,   112,   135,   113,
   124,   121,   122,   123,   125,   142,   143,   134,   144,   127,
   136,   140,   137,   151,   147,   145,   119,   153,   154,   148,
   157,   159,   158,   164,    23,    24,    25,   161,   160,   162,
    61,    26,    84,   115,   152,     0,    85
};

static const short yycheck[] = {     1,
    18,    26,     4,     5,    26,    34,    19,    20,    21,    22,
    23,    24,    35,    42,    16,    34,    48,    49,    43,    21,
    22,    43,    35,    42,     5,     6,     7,    29,     9,    10,
    11,    12,    13,    14,    15,    16,    41,    55,    40,    41,
    34,    35,    34,     0,    34,    35,     3,    34,    50,    54,
    42,    34,    35,     3,    50,    51,    28,    27,    39,     3,
    17,    17,    35,    38,    35,    29,    35,    17,    30,    35,
    27,    38,    35,    75,    31,    32,    33,    27,    43,    56,
    35,    31,    32,    33,    19,    20,    21,    22,    23,    24,
    35,    38,    35,    95,    35,    35,    35,    35,    35,    35,
    35,    35,    35,    35,    39,    56,     8,     5,     6,     7,
   112,     9,    10,    11,    12,    13,    14,    15,    16,    35,
    39,    18,   124,    41,   126,    25,   128,    56,   130,    52,
    56,    53,    46,    46,    45,   137,   138,    40,   140,    35,
    44,    47,    37,   145,    43,    46,    54,    40,    25,    43,
    40,    25,   154,     0,     7,     9,    11,   159,    49,    51,
    47,    13,    71,   111,   146,    -1,    73
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/gnu/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* Not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
#include <alloca.h>
#endif /* Sparc.  */
#endif /* Not GNU C.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYIMPURE
#define YYLEX		yylex()
#endif

#ifndef YYPURE
#define YYLEX		yylex(&yylval, &yylloc)
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYIMPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* YYIMPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#line 131 "/usr/local/gnu/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/

#define YYPOPSTACK   (yyvsp--, yysp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yysp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifndef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Next token is %d (%s)\n", yychar, yytname[yychar1]);
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      if (yylen == 1)
	fprintf (stderr, "Reducing 1 value via rule %d (line %d), ",
		 yyn, yyrline[yyn]);
      else
	fprintf (stderr, "Reducing %d values via rule %d (line %d), ",
		 yylen, yyn, yyrline[yyn]);
    }
#endif


  switch (yyn) {

case 6:
#line 1049 "aspirin_yacc.y"
{
                 network->line_search = LINE_SEARCH;
                 network->line_search_update = yyvsp[-1].i;
                 network->line_search_timeout = yyvsp[0].i;
              ;
    break;}
case 7:
#line 1054 "aspirin_yacc.y"
{
                 network->line_search = LINE_SEARCH_VERBOSE;
                 network->line_search_update = yyvsp[-1].i;
                 network->line_search_timeout = yyvsp[0].i;
              ;
    break;}
case 8:
#line 1059 "aspirin_yacc.y"
{
                network->conjugate_gradient = CONJ_GRAD_SIMPLE;
              ;
    break;}
case 11:
#line 1072 "aspirin_yacc.y"
{BD_PTR black_box;
  	                           black_box = (BD_PTR)fetch_dictionary(yyvsp[-4].s, network->lookup);
				   if (black_box == (BD_PTR)NULL)
				     {
				       yyerror("Unknown Black Box name.");
				     }/* end if */
				   else
				     {
				       black_box->load_key = yyvsp[-2].s;
				       black_box->datafile = yyvsp[0].s;
				     }/* end else */
			        ;
    break;}
case 14:
#line 1094 "aspirin_yacc.y"
{ lineno = yyvsp[-1].i;
 				  aspirin_file = yyvsp[0].s;
			        ;
    break;}
case 15:
#line 1097 "aspirin_yacc.y"
{ lineno = yyvsp[-2].i;
 				           aspirin_file = yyvsp[-1].s;
			                 ;
    break;}
case 16:
#line 1100 "aspirin_yacc.y"
{ lineno = yyvsp[-1].i;
                                       aspirin_file = yyvsp[0].s;
                                     ;
    break;}
case 17:
#line 1103 "aspirin_yacc.y"
{ lineno = yyvsp[0].i; ;
    break;}
case 18:
#line 1104 "aspirin_yacc.y"
{;
    break;}
case 22:
#line 1122 "aspirin_yacc.y"
{ create_black_box(yyvsp[0].s); ;
    break;}
case 25:
#line 1130 "aspirin_yacc.y"
{
            if (current_bbd->n_inputs == 0)
	      {
		/* black box */
		current_bbd->n_inputs = yyvsp[0].i;
		current_bbd->inputs_xdim = layer_xdim;
		current_bbd->inputs_ydim = layer_ydim;
	      }/* end if */
	    else
	      {
		/* already specified # of inputs */
		yyerror("Sorry, number of inputs already specified. ");
	      }/* end else */
	   ;
    break;}
case 26:
#line 1144 "aspirin_yacc.y"
{ current_bbd->layers = yyvsp[-1].l; ;
    break;}
case 27:
#line 1145 "aspirin_yacc.y"
{ current_bbd->dynamic = BBSTATIC; ;
    break;}
case 28:
#line 1146 "aspirin_yacc.y"
{ current_bbd->ar_learning = FALSE; ;
    break;}
case 29:
#line 1147 "aspirin_yacc.y"
{ current_bbd->ff_learning = FALSE; ;
    break;}
case 30:
#line 1148 "aspirin_yacc.y"
{ 
	        if (yyvsp[0].i < 0) {
		  yyerror("The argument to ClearDelays-> must be a positive integer ");
		}
	        current_bbd->clear_delay = yyvsp[0].i; 
	      ;
    break;}
case 31:
#line 1154 "aspirin_yacc.y"
{ current_bbd->output_layer_name =
				    make_name(yyvsp[0].s, current_bbd); ;
    break;}
case 32:
#line 1156 "aspirin_yacc.y"
{ 
	        if (yyvsp[0].i <= 0) {
		  yyerror("The argument to UpdateInterval-> must be a positive integer ");
		}
                current_bbd->update_interval = yyvsp[0].i; 
             ;
    break;}
case 33:
#line 1162 "aspirin_yacc.y"
{ current_bbd->input_filter = yyvsp[0].s; ;
    break;}
case 34:
#line 1163 "aspirin_yacc.y"
{ current_bbd->output_filter = yyvsp[0].s; ;
    break;}
case 35:
#line 1164 "aspirin_yacc.y"
{ current_bbd->error_function = yyvsp[0].s; ;
    break;}
case 36:
#line 1169 "aspirin_yacc.y"
{ yyval.l = yyvsp[0].l; ;
    break;}
case 37:
#line 1170 "aspirin_yacc.y"
{ (yyvsp[0].l)->next = yyvsp[-1].l; /* push into list (double links) */
			  (yyvsp[-1].l)->previous = yyvsp[0].l;
			  yyval.l = yyvsp[0].l;
			;
    break;}
case 38:
#line 1176 "aspirin_yacc.y"
{ 
                                                      yyval.l = create_layer(yyvsp[-5].s,   /* name */
							   	        yyvsp[-4].i,   /* size */
								        layer_xdim, /* x size */
								        layer_ydim, /* y size */
								        yyvsp[-1].c);  /* connections */
	    			                    ;
    break;}
case 39:
#line 1186 "aspirin_yacc.y"
{ /* set global for access by
			           connection_specs
		      	         */
                                 to_layer =
			            make_name(yyvsp[0].s, current_bbd);
			         /* set for use when creating a new layer */
			         type = PDP_LAYER_TYPE1;

			         yyval.s = to_layer;
			       ;
    break;}
case 40:
#line 1196 "aspirin_yacc.y"
{ /* set global for access by
			           connection_specs
		      	         */
                                 to_layer =
			            make_name(yyvsp[0].s, current_bbd);
			         /* set for use when creating a new layer */
			         type = PDP_LAYER_TYPE2;

			         yyval.s = to_layer;
			       ;
    break;}
case 41:
#line 1206 "aspirin_yacc.y"
{ /* set global for access by
			           connection_specs
		      	         */
                                 to_layer =
			            make_name(yyvsp[0].s, current_bbd);
			         /* set for use when creating a new layer */
			         type = PDP_LAYER_TYPE3;

			         yyval.s = to_layer;
			       ;
    break;}
case 42:
#line 1216 "aspirin_yacc.y"
{ /* set global for access by
				    connection_specs
				  */
	                         to_layer =
				   make_name(yyvsp[0].s, current_bbd);
				 /* set for use when creating
						   a new layer
						   */
				 type = LINEAR_LAYER_TYPE;

				 yyval.s = to_layer; 
			       ;
    break;}
case 43:
#line 1228 "aspirin_yacc.y"
{ /* set global for access by
				    connection_specs
				  */
	                         to_layer =
				   make_name(yyvsp[0].s, current_bbd);
				 /* set for use when creating
						   a new layer
						   */
				 type = QUAD_LAYER_TYPE;

				 yyval.s = to_layer; 
			       ;
    break;}
case 44:
#line 1240 "aspirin_yacc.y"
{ /* set global for access by
				            connection_specs
				          */
	                         to_layer =
				   make_name(yyvsp[0].s, current_bbd);
				 /* set for use when creating
						   a new layer
						   */
				 type = USER_LAYER_TYPE;
				 /* user must supply the name
				    of 2 C functions, a tansfer
				    function and the derivative
				    of the transfer function.
				  */
				 C_transfer = yyvsp[-2].s;
				 C_transfer_prime = yyvsp[-1].s;

				 yyval.s = to_layer; 
			       ;
    break;}
case 45:
#line 1259 "aspirin_yacc.y"
{ yyerror("Unknown component type."); ;
    break;}
case 46:
#line 1264 "aspirin_yacc.y"
{ yyval.c = yyvsp[0].c; ;
    break;}
case 47:
#line 1267 "aspirin_yacc.y"
{ yyval.c = yyvsp[0].c; ;
    break;}
case 48:
#line 1272 "aspirin_yacc.y"
{ yyval.c = yyvsp[0].c; ;
    break;}
case 49:
#line 1273 "aspirin_yacc.y"
{
		                                             (yyvsp[0].c)->next = yyvsp[-2].c;
		                                              yyval.c = yyvsp[0].c;
		                                           ;
    break;}
case 50:
#line 1282 "aspirin_yacc.y"
{
                 yyval.c = create_connection(make_name(yyvsp[-3].s, current_bbd),
					to_layer,
					NXM_CONNECTION_TYPE, /* default */
					0, /* default */
					0, /* default */
					0, /* default */
					0, /* default */
					0, /* default */
					0, /* default */
					0, /* default */
				        yyvsp[0].i,
					yyvsp[-1].d,/* delay */
					yyvsp[-2].i /* order */
					); 
	         ;
    break;}
case 51:
#line 1299 "aspirin_yacc.y"
{
                 yyval.c = create_connection(make_name(yyvsp[-11].s, current_bbd),
					to_layer,
					/* type of tessellation */
					((tess_ydim == 1) && (layer_ydim == 1)) 
					?TESS_1D_CONNECTION_TYPE
					:TESS_2D_CONNECTION_TYPE,
					yyvsp[-6].i,                /* equals 1 if shared */
					tess_xoffset,      /* where begin in x */
					tess_xdim,         /* xrange of tessellation */
					tess_xoverlap,     /* xoverlap */
					tess_yoffset,      /* where to begin in y*/
					tess_ydim,         /* yrange */
					tess_yoverlap,     /* yoverlap */
					yyvsp[-1].i,               /* type of initialize function for weights */
					yyvsp[-9].d,                /* delay */
					yyvsp[-10].i                 /* order */
					);
	         ;
    break;}
case 52:
#line 1321 "aspirin_yacc.y"
{ yyval.i = 1; /* default 1st order */ ;
    break;}
case 53:
#line 1322 "aspirin_yacc.y"
{ yyval.i = yyvsp[0].i; ;
    break;}
case 54:
#line 1326 "aspirin_yacc.y"
{ 
                                       delay_struct.n = 0;
                                       delay_struct.start = 0;
				       delay_struct.end = 0;
				       yyval.d = &delay_struct; /* default */;
    break;}
case 55:
#line 1331 "aspirin_yacc.y"
{ 
                                       delay_struct.n = 1;
                                       delay_struct.start = yyvsp[-1].i;
				       delay_struct.end = yyvsp[-1].i;
                                       yyval.d = &delay_struct;;
    break;}
case 56:
#line 1336 "aspirin_yacc.y"
{
                                       delay_struct.start = yyvsp[-4].i;
				       delay_struct.end = yyvsp[-2].i;
                                       delay_struct.n = delay_struct.end - delay_struct.start - 1;
                                       yyval.d = &delay_struct;;
    break;}
case 57:
#line 1344 "aspirin_yacc.y"
{ yyval.i = 0; /* default */;
    break;}
case 58:
#line 1346 "aspirin_yacc.y"
{ yyval.i = 1; ;
    break;}
case 59:
#line 1350 "aspirin_yacc.y"
{ yyval.i = RANDOM_INIT; ;
    break;}
case 60:
#line 1352 "aspirin_yacc.y"
{ C_init_function = yyvsp[0].s; yyval.i = C_INIT; ;
    break;}
case 61:
#line 1359 "aspirin_yacc.y"
{
                                        layer_xdim = yyvsp[0].i; /* set global to record */
			                layer_ydim = 1; /* set global to record */
                                        yyval.i = yyvsp[0].i;
			              ;
    break;}
case 62:
#line 1365 "aspirin_yacc.y"
{  layer_xdim = yyvsp[-1].i; /* set global to record */
			                 layer_ydim = 1; /* set global to record */
                                         yyval.i = yyvsp[-1].i;
			              ;
    break;}
case 63:
#line 1369 "aspirin_yacc.y"
{  /* set global to record */
                                                 layer_xdim = yyvsp[-3].i;
                                                 /* set global to record */
				                 layer_ydim = yyvsp[-1].i; 
				                 yyval.i = layer_xdim * layer_ydim;
				              ;
    break;}
case 64:
#line 1378 "aspirin_yacc.y"
{ tess_xdim = yyvsp[0].i; /* set global to record */
			                    tess_ydim = 1; /* set global to record */
			                  ;
    break;}
case 65:
#line 1382 "aspirin_yacc.y"
{ tess_xdim = yyvsp[-1].i; /* set global to record */
			                    tess_ydim = 1; /* set global to record */
			                  ;
    break;}
case 66:
#line 1385 "aspirin_yacc.y"
{  /* set global to record */
	                                         tess_xdim = yyvsp[-3].i;
					         /* set global to record */
				                 tess_ydim = yyvsp[-1].i;
				              ;
    break;}
case 67:
#line 1392 "aspirin_yacc.y"
{ tess_xoverlap = 0;
					          tess_yoverlap = 0;
					        ;
    break;}
case 68:
#line 1396 "aspirin_yacc.y"
{ tess_xoverlap = yyvsp[-4].i;
					                   tess_yoverlap = yyvsp[-1].i;
					                 ;
    break;}
case 69:
#line 1400 "aspirin_yacc.y"
{ tess_xoverlap = yyvsp[-1].i;
					          tess_yoverlap = 0;
			  		        ;
    break;}
case 70:
#line 1404 "aspirin_yacc.y"
{ tess_xoverlap = 0;
					          tess_yoverlap = yyvsp[-1].i;
					        ;
    break;}
case 71:
#line 1409 "aspirin_yacc.y"
{ tess_xoffset = 0;
					         tess_yoffset = 0;
					       ;
    break;}
case 72:
#line 1413 "aspirin_yacc.y"
{ tess_xoffset = yyvsp[-4].i;
					                 tess_yoffset = yyvsp[-1].i;
					               ;
    break;}
case 73:
#line 1417 "aspirin_yacc.y"
{ tess_xoffset = yyvsp[-1].i;
					         tess_yoffset = 0;
					       ;
    break;}
case 74:
#line 1421 "aspirin_yacc.y"
{ tess_xoffset = 0;
					         tess_yoffset = yyvsp[-1].i;
					       ;
    break;}
case 75:
#line 1427 "aspirin_yacc.y"
{ 
                           bias_init = RANDOM_INIT;  /* default to random            */
		          ;
    break;}
case 76:
#line 1431 "aspirin_yacc.y"
{
                           bias_init = CONSTANT_INIT;
                           layer_bias = yyvsp[0].f; 
                          ;
    break;}
case 77:
#line 1436 "aspirin_yacc.y"
{
                           bias_init = C_INIT;
                           layer_bias_init = yyvsp[0].s; 
                          ;
    break;}
case 78:
#line 1441 "aspirin_yacc.y"
{
                           layer_order = yyvsp[0].i;
			  ;
    break;}
case 79:
#line 1446 "aspirin_yacc.y"
{ yyval.i = 0; /* default 0th order */ ;
    break;}
case 80:
#line 1447 "aspirin_yacc.y"
{ yyval.i = yyvsp[0].i; ;
    break;}
case 81:
#line 1452 "aspirin_yacc.y"
{ yyval.f = yyvsp[0].f; ;
    break;}
case 82:
#line 1454 "aspirin_yacc.y"
{yyval.i = (int)yyvsp[0].f; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 362 "/usr/local/gnu/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) xmalloc(size + 15);
	  strcpy(msg, "parse error");

	  if (count < 5)
	    {
	      count = 0;
	      for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
		if (yycheck[x + yyn] == x)
		  {
		    strcat(msg, count == 0 ? ", expecting `" : " or `");
		    strcat(msg, yytname[x]);
		    strcat(msg, "'");
		    count++;
		  }
	    }
	  yyerror(msg);
	  free(msg);
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 1456 "aspirin_yacc.y"


/*****************************************************/
/*****************************************************/
/*****************************************************/
/*******************    lex    ***********************/



char *newstr (name, length)
  char *name;
  int length;
{
 char *temp;

 temp = am_alloc_mem(length + 1);
 *(temp + length) = 0;
 bcopy(name, temp, length+1);
 return(temp);
}

static void read_token()
{
  unsigned int c;


  yyleng=0;
  /* skip spaces, tabs , and newlines  */
  while((c=getchar()) != ' '
	&& !(iscntrl(c))
	&& c != '['
	&& c != ']'
	&& c != '{'
	&& c != '}'
	&& c != '('
	&& c != ')'
	&& c != '@'
	&& c != '='
	&& c != '#'
	&& c != ','
	&& c != EOF) {
    yytext[yyleng++] = c;
  }
  ungetc((unsigned char)c,stdin);
  yytext[yyleng] = '\0';
}

static int input_equals(str)
     register char *str;
{
  register int counter;
  register unsigned char *tptr = yytext;

  counter = yyleng;
  if (strlen(str) > counter) counter = strlen(str);
  while(counter--) if (*str++ != *tptr++) return FALSE;;
  return TRUE;

}


#define CONTEXT_STACK_DEPTH 16
#define NO_CONTEXT 0
#define DIMENSION_CONTEXT 1
#define CONNECTION_CONTEXT 2
#define TIME_CONTEXT 3
#define BLACK_BOX_CONTEXT 4
#define COMPONENTS_CONTEXT 5
static int context_stack[CONTEXT_STACK_DEPTH], *cstackptr = context_stack;

static void push_lex_context(new_context)
     int new_context;
{
  if (cstackptr == context_stack + CONTEXT_STACK_DEPTH)
    yyerror("\nLex context stack full! (push_lex_context)\n");
  cstackptr++; *cstackptr = new_context;
}

static void pop_lex_context()
{
  if (cstackptr == context_stack)
    yyerror("\nLex context stack would be empty! (pop_lex_context)\n");
  /* pop */
  cstackptr--;
}

static int this_context(context)
     int context;
{
  return( *cstackptr == context );
}

int yylex()
{
  unsigned int c;

  more :

  /* single character stuff */

  /* skip spaces and tabs */
  while((c=getchar()) == ' ' || c == '\t') ;

  /* jump on carrage return */
  if (c == '\n') {  ++lineno; goto more ; }

  /* jump on control chars */
  if (iscntrl(c)) goto more ;

  if (c == EOF) return 0;

  if (c == '#') return(NEWLINE);

  if (c == '{') {
    return(LCP);
  }/* end if */

  if (c == '}') {
    pop_lex_context();
    return(RCP);
  }/* end if */

  if (c == '(') {
    if (this_context(CONNECTION_CONTEXT))
      push_lex_context(CONNECTION_CONTEXT);
    return(LP);
  }/* end if */

  if (c == ')') {
    pop_lex_context();
    return(RP);
  }/* end if */

  if (c == '[') {
    push_lex_context(DIMENSION_CONTEXT);
    return(LB);
  }/* end if */

  if (c == ']') {
    pop_lex_context();
    return(RB);
  }/* end if */

  /* dimension context */
  if(this_context(DIMENSION_CONTEXT))
     if (c == 'x' || c == 'X') return(DIMENSION);

  if (this_context(DIMENSION_CONTEXT))
      if (c == ',') return(COMMA);

  if (c == '=') return(EQUALS);

  if (c == '@') {
    push_lex_context(TIME_CONTEXT);
    return(AT);
  }

  /* ok, done with the single character stuff, names  */
  ungetc((unsigned char)c, stdin);  read_token();

  if (isdigit((unsigned int)yytext[0]) ||
      (yyleng > 1 &&
       (yytext[0] == '-' || yytext[0] == '+' || yytext[0] == '.') &&
       isdigit((unsigned int)yytext[1])) ||
      (yyleng > 2 &&
       (yytext[0] == '-' || yytext[0] == '+') &&
       yytext[1] == '.' &&
       isdigit((unsigned int)yytext[2]))) { /* number */
    sscanf((char *)yytext, "%f", &yylval.f);
    return(NUMBER);
  }/* end if number */ 

  if (this_context(NO_CONTEXT)) { /* global context */
    if (input_equals("DefineBlackBox")) {
      push_lex_context(BLACK_BOX_CONTEXT);
      return(BBD);
    }
  }

  if (this_context(BLACK_BOX_CONTEXT)) {
    
    if (input_equals("InputSize->")) return(INPUT_SIZE);
    
    if (input_equals("OutputLayer->")) return(OUTPUT_LAYER);
    
    if (input_equals("Static->")) return(STATIC);
    
    if (input_equals("ClearDelays->")) return(CLRDELAYS);
    
    if (input_equals("InputFilter->")) return(INPUT_FILTER);

    if (input_equals("OutputFilter->")) return(OUTPUT_FILTER);
    
    if (input_equals("ErrorFunction->")) return(ERROR_FUNCTION);

    if (input_equals("UpdateInterval->")) return(UPDATE_INTERVAL);

    if (input_equals("DisableFeedbackLearning->")) return(DISABLE_FEEDBACK_LEARNING);

    if (input_equals("DisableFeedforwardLearning->")) return(DISABLE_FEEDFORWARD_LEARNING);

    if (input_equals("Components->")) {
      push_lex_context(COMPONENTS_CONTEXT);
      return(COMPONENTS);
    }
  }



  if (this_context(COMPONENTS_CONTEXT)) {
    
    if (input_equals("PdpNode")) {
      push_lex_context(CONNECTION_CONTEXT);
      return(PDPNODE1);
    }
    
    if (input_equals("PdpNode1")) {
      push_lex_context(CONNECTION_CONTEXT);
      return(PDPNODE1);
    }
    
    if (input_equals("PdpNode2")) {
      push_lex_context(CONNECTION_CONTEXT);
      return(PDPNODE2);
    }
    
    if (input_equals("PdpNode3")) {
      push_lex_context(CONNECTION_CONTEXT);
      return(PDPNODE3);
    }
    
    if (input_equals("LinearNode")) {
      push_lex_context(CONNECTION_CONTEXT);
      return(LINEAR_NODE);
    }
    
    if (input_equals("QuadraticNode")) {
      push_lex_context(CONNECTION_CONTEXT);
      return(QUAD_NODE);
    }
    
    if (input_equals("UserNode")) {
      push_lex_context(CONNECTION_CONTEXT);
      return(USER_NODE);
    }
    
  }

  if (this_context(TIME_CONTEXT))
    if (input_equals("Time")) return(TIME);


  /* connection description context */
  if (this_context(CONNECTION_CONTEXT)) {
    if (input_equals("InputsFrom->")) return(INPUTS_FROM);

    if (input_equals("and")) return(CONJ);

    if (input_equals("Tessellation")) return(TESSELLATION);
    
    if (input_equals("Xoffset")) return(XOFFSET);
    
    if (input_equals("Yoffset")) return(YOFFSET);
    
    if (input_equals("Xoverlap")) return(XOVERLAP);
    
    if (input_equals("Yoverlap")) return(YOVERLAP);
    
    if (input_equals("Shared")) return(SHARED);
    
    if (input_equals("with")) return(WITH);
    
    if (input_equals("using")) return(USING);
    
    if (input_equals("initialized")) return(INIT);

    if (input_equals("Order")) return(ORDER);

    if (input_equals("Bias")) return(BIAS);
    
    /* skip articles */
    if (input_equals("a")) goto more ;
  }


  if (this_context(NO_CONTEXT)) { /* global context */
    
    /* LoadData context */
    if (input_equals("LoadData")) return(LOAD_DATA);

    if (input_equals("into")) return(INTO);
    
    if (input_equals("in")) return(IN);
    
    if (input_equals("from")) return(FROM);

    /* LineSearch */
    if (input_equals("LineSearch")) return(LINE_SRCH);
    if (input_equals("LineSearchVerbose")) return(LINE_SRCH_VERBOSE);

    /* ConjugateGradient */
    if (input_equals("ConjugateGradient")) return(CONJ_GRAD);

  }
  
  /* names */
  {
    extern char *strchr();
    char *hyphen_ptr;
    yylval.s = newstr(yytext, yyleng);
    /* NO HYPHENS ALLOWED IN NAMES PASSED TO C! '-' => '_' */ 
    hyphen_ptr = strchr(yylval.s, (int)'-');
    while (hyphen_ptr != (char *)NULL) {
      *hyphen_ptr = '_';
      hyphen_ptr = strchr(yylval.s, (int)'-');
    }/* end while */
    return(NAME);
  }  

}/* end yylex */

/*****************************************************/
/*****************************************************/
/*****************************************************/





/*****************************************************/
/* parse       file = aspirin spefication from
               which a network of black box
	       descriptors is created.
 */
/*****************************************************/
ND_PTR parse(file)
     char *file;
{
  extern char *aspirin_file;
  extern ND_PTR network;
  char *cpp_file;
  FILE *in_stream;


  printf("\nAspirin Parser"); /* say hi! */
  printf("\n%s", BASIC_COPYRIGHT);

  
  /******************************************/
  /* run cpp on aspirin file */
  cpp_file = am_cpp(file,0);
  /******************************************/

  /******************************************/
  /* open  input from cpp */
  in_stream = freopen(cpp_file, "r", stdin);
  /* exit on error */
  if (in_stream == NULL)
    {
      fprintf(stderr, "\nUnable to open %s", cpp_file);
      am_perror("Aspirin file");
      exit(1);
    }
  aspirin_file = file;
  /******************************************/
  
  /******************************************/
  /* make the root */
  create_network();
  /******************************************/

  /******************************************/
  /* parse storing info in global variables */
  yyparse();
  /******************************************/

  /******************************************/
  /* update pointers, etc. */
  update(); 
  /******************************************/

  /******************************************/
  /* check dependencies for static bbs */
  check_dependencies(); 
  /******************************************/

  /******************************************/
  /* remove cpp file */
  am_remove_cpp_file(cpp_file);
  /******************************************/

  /******************************************/
  /* return */
  return(network);
  /******************************************/
}


    
