/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

/* Russell Leighton Oct. 87 */

/***************************************************************/
/* dictionary    This program creates a string dictionary using*/
/*               a TRI with buckets on the nodes.              */
/***************************************************************/

/***************************************************************/
/* FUNCTION LIST                                               */
/* DICTIONARYPTR create_dictionary();                          */
/* void insert_dictionary(string, char_ptr, dictionary_ptr)    */
/* GENERIC_PTR *fetch_dictionary(string, dictionary_ptr)       */
/* GENERIC_PTR *delete_dictionary(string, dictionary_ptr)      */
/* void destroy_dictionary(dictionary_ptr)                     */
/* void map_dictionary(dictionary_ptr);                        */
/***************************************************************/

/* headers     */
#include "AmOs.h"

/* CONSTANTS */
#define END_OF_STRING '\0'

/* STRUCTURE AND STUFF */
/* USER STRUCTURE */   
typedef char GENERIC;
typedef char *GENERIC_PTR;

/* STRUCTURES */
typedef struct dictionary
{
  char character;
  GENERIC_PTR bin;	/* pointer to user structure */
  struct dictionary *sibling;
  struct dictionary *child;
} DICTIONARY, *DICTIONARYPTR;


/* MACROS */
#define make_dictionary() (DICTIONARYPTR)am_alloc_mem(sizeof (DICTIONARY))


/* FUNCTIONS */

/***************************************************************/
/* create_dictionary                           
   
   Returns a pointer to a dictionary structure, which is a tree.
   */
/***************************************************************/
DICTIONARYPTR create_dictionary ()
{
  DICTIONARYPTR d; /* pointer to dictionary. */
  
  d = make_dictionary();
  d->character = (char)NULL;
  d->bin = (GENERIC_PTR)NULL;
  d->sibling = (DICTIONARYPTR)NULL;
  d->child =  (DICTIONARYPTR)NULL;
  return(d);
}

/***************************************************************/
/* insert_dictionary
   Insert a string into a dictionary with a pointer to
   an associated value. 
   */
/***************************************************************/
void insert_dictionary (string, value_ptr, current_cell)
     char *string;
     GENERIC_PTR value_ptr;
     DICTIONARYPTR current_cell;
     
{
  DICTIONARYPTR new_cell, cell;
  register char character, *place_ptr;
  
  /* set pointer to begining of string */
  place_ptr = string;
  
  if (*place_ptr == END_OF_STRING) {
    fprintf(stderr, "Error: Attempt to store null string.");
    exit(1);
  }/* end if */
  
  /* walk tree and update structures... */
  for (character = *place_ptr; ;)   {
    /* get child list*/
    cell = current_cell->child;
    
    /* if the character is not in child list... */
    if (cell == (DICTIONARYPTR)NULL) { /* ...make a new child and push into the child list */
      new_cell = make_dictionary();
      current_cell->child = new_cell;
      new_cell->child = (DICTIONARYPTR)NULL;
      /* set current ptr */
      current_cell = new_cell;
      /* set character */
      new_cell->character = character;
      /* set sibling null */
      new_cell->sibling = (DICTIONARYPTR)NULL;
      /* goto next character */
      character = *++place_ptr;
      /* if at the last character then put value_ptr in bucket */
      if (character == END_OF_STRING) {
	new_cell->bin = value_ptr;
	return; /* done */
      } else {
	new_cell->bin = (GENERIC_PTR)NULL;
      }/* end if else */
    } else {
      current_cell = cell;
      /* find sibling */
      while (cell != (DICTIONARYPTR)NULL
	     && character != cell->character) {
	cell = cell->sibling;	/* next sibling*/
      }/* end while */
      
      /* if the character is not in sibling list... */
      if (cell == (DICTIONARYPTR)NULL) { /* ...make a new sibling and push into the sibling list */
	/* remember old sibling and link new sibling*/
	cell = current_cell->sibling;
	new_cell = make_dictionary();
	current_cell->sibling = new_cell;
	new_cell->sibling = cell;
	/* set current ptr */
	current_cell = new_cell;
	/* set character */
	new_cell->character = character;
	/* set child null */
	new_cell->child = (DICTIONARYPTR)NULL;
	/* goto next character */
	character = *++place_ptr;
	/* if at the last character then put value_ptr in bucket */
	if (character == END_OF_STRING) {
	  new_cell->bin = value_ptr;
	  return; /* done */
	} else {
	  new_cell->bin = (GENERIC_PTR)NULL;
	}/* end if else */
	
      } else  {
	current_cell = cell;
	character = *++place_ptr;
	/* if at the last character then put value_ptr in bucket */
	if (character == END_OF_STRING) {
	  cell->bin = value_ptr;
	  return; /* done */
	}/* end if */
      } /* end else */
    } /* end else */
    
  } /* endfor */
  
} /* end insert_dictionary */

/***************************************************************/
/* delete_dictionary
   Remove a string from a dictionary. Return the pointer in the bin.
   */
/***************************************************************/
GENERIC_PTR delete_dictionary (string, cell)
     char *string;
     DICTIONARYPTR cell;
{ register char character, *place_ptr;
  GENERIC_PTR value_ptr;
  
  if (cell == (DICTIONARYPTR)NULL) {
    fprintf(stderr, "\nAttempt to fetch from null dictionary.\n");
    exit(1);
  }/* end if */
  
  /* set pointer to begining of string */
  place_ptr = string;
  
  
  /* walk tree and update structures... */
  for (character = *place_ptr; ;)  {
    
    cell = cell->child;
    
    /* find sibling */
    while (cell != (DICTIONARYPTR)NULL
	   && character != cell->character) {
      cell = cell->sibling;	/* next sibling*/
    } /* end while */
    
    /* if the character is not in siblings list... */
    if (cell == (DICTIONARYPTR)NULL)return((GENERIC_PTR)NULL); /* done */
    /* next  */
    character = *++place_ptr;
    if (character == END_OF_STRING) {
      /* Congradulations!! you found the bucket. */
      value_ptr = cell->bin;  /* simply null out */
      cell->bin = (GENERIC_PTR)NULL;
      return(value_ptr);
    }/* end if */
    
  } /* endfor */
  
} /* end delete_dictionary */

/***************************************************************/
/* fetch-dictionary
   Returns the value associated with the string.
   */
/***************************************************************/
GENERIC_PTR fetch_dictionary (string, cell)
     char *string;
     DICTIONARYPTR cell;
{
  register char character, *place_ptr;
  
  if (cell == (DICTIONARYPTR)NULL) {
    fprintf(stderr, "\nAttempt to fetch from null dictionary.\n");
    exit(1);
  }/* end if */
  
  /* set pointer to begining of string */
  place_ptr = string;
  
  /* walk tree and update structures... */
  for (character = *place_ptr; ;) { 
    cell = cell->child; 
    
    /* find sibling */
    while (cell !=(DICTIONARYPTR)NULL 
	   && character != cell->character) {
      cell = cell->sibling;	/* next sibling*/
    } /* end while */
    
    /* if the character is not in siblings list... */
    if (cell == (DICTIONARYPTR)NULL)	{
      return((GENERIC_PTR)NULL); /* done */
    }/* end if */
    /* next */
    character = *++place_ptr;
    /* Congradulations!! you found the bucket. */
    if (character == END_OF_STRING)  return(cell->bin);
    
  } /* endfor */
  
} /* end fetch_dictionary */


/***************************************************************/
/* destroy_dictionary
   Recursively free the dictionary structures.
   */
/***************************************************************/
void destroy_dictionary (dictionary)
     DICTIONARYPTR dictionary;
{
  if (dictionary == (DICTIONARYPTR)NULL) return;
  
  destroy_dictionary(dictionary->sibling);	/* next sibling*/
  destroy_dictionary(dictionary->child);	/* child */
  /* free dict */
  am_free_mem(dictionary);
  
}/* end destroy_dictionary */

/***************************************************************/
/* map_dictionary
   Recursively apply function to leaves of the tree.
   */
/***************************************************************/
void map_dictionary (function, dictionary)
     DICTIONARYPTR dictionary;
     int (*function)();
{
  if (dictionary == (DICTIONARYPTR)NULL) return;
  
  /* apply function if at leaf */
  if (dictionary->bin != (GENERIC_PTR)NULL)
    function(dictionary->bin); 
  
  map_dictionary(function, dictionary->child);	        /* child */  
  map_dictionary(function, dictionary->sibling);	/* next sibling*/
  
}/* end map_dictionary */


 
