/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
 
/*********   THIS INFO IS THE CURRENT HEADER INFO FOR BACKPROP SIMULATIONS **********/

#ifndef BACKPROP_HEADER
#define BACKPROP_HEADER 1

#include "AmOs.h"

/* size of error string */
#define E_STRING_SIZE 128

/* error codes */
#define FERROR -1               /* unable to open/close file */
#define DFERROR -2              /* error in dump file data */


/* function pointer types */
typedef char *(*PCFPTR)();      /* ptr to function returns a pointer to a character */
typedef int (*IFPTR)();         /* ptr to function returns an int */
typedef void (*VFPTR)();        /* ptr to function returns void */
typedef float (*FFPTR)();       /* ptr to function returns a float */
typedef float *(*PFFPTR)();     /* ptr to function returns a pointer to a float */
typedef float **(*PPFFPTR)();   /* ptr to funct returns a ptr to ptr to float */


/* table of contents structure (used when reading dump files) */
typedef struct table_of_contents {
  int size;               /* number of entries in address table */
  off_t *address_table;   /* array of byte counts between black
			     boxes in dump file.
		           */
} TOC_STRUCT, *TOC_PTR;

/* CONSTANTS */
/* these list the possible layer types */
#define PDP_LAYER_TYPE1 0            /* [0,1] */
#define PDP_LAYER_TYPE2 1            /* [-1/2,1/2] */
#define PDP_LAYER_TYPE3 2            /* [-1,1] */
#define LINEAR_LAYER_TYPE 3
#define QUAD_LAYER_TYPE 4
#define USER_LAYER_TYPE 5

/* these list the possible connection types */
#define NXM_CONNECTION_TYPE 0            /* fully connected */
#define TESS_1D_CONNECTION_TYPE 1        /* 1d window of connectivity */
#define TESS_2D_CONNECTION_TYPE 2        /* 2d window of connectivity */

/* used for read/write from BpIo.c */
#define BP_DATA_READ 0                   
#define BP_DATA_WRITE 1


/* Communication Buffer w/connection info */
typedef struct connection_buffer {
  int type;              /* type of connection structure */
  int order;             /* equals order of connection: 0 => undefined
				                        1 => dot product
				    	                2 => quadratic
                          */
  int shared;            /* equals 1 if weight matrix is a shared kernel between all nodes */
  int size;              /* size of connection matrix */
  int from_bb_index;     /* index of the from black box */
  int from_layer_index;  /* index of the from layer (-1 if this is $INPUTS)*/
  char *from_layer_name; /* name of layer */
  int from_size;         /* number of from nodes */
  int from_xdim;         /* n_nodes in x dimension */
  int from_ydim;         /* n_nodes in y dimension */
  int delay;             /* connected at what delay (default 0) */
  /*** The following info is used for NXM_CONNECTION_TYPE (full) ***/
  float *weights;        /* weight vector */
  float *delta_weights;  /* vector of the change in weights */
  /*** The following additional info is for tessellations ***/
  int tess_xdim;         /* tile width */
  int tess_ydim;         /* tile height */
  int tess_xoverlap;     /* tile xoverlap */
  int tess_yoverlap;     /* tile yoverlap */
  int tess_xoffset;      /* tile xoffset */
  int tess_yoffset;      /* tile yoffset */
}CB, *CB_PTR;

/* Buffer with global info about network */
typedef struct network_buffer
{
 char *aspirin_file;      /* the name of the aspirin file */
 char *file;              /* name of the simulation file and header */

 int temporal;            /* 1 if there is feedback */

 int n_black_boxes;       /* the number of black boxes */
 int n_input_channels;    /* the number of black boxes having input (from outside) */
 int n_output_channels;   /* the number of black boxes having output (from outside) */
 int n_nodes;             /* total number of nodes in whole network */
 int n_connections;       /* total number of connections in whole network */

 /* NETWORK FUNCTIONS SUPPLIED BY BACKPROP COMPILERS */
 VFPTR set_learning_rate;       /* set the learning rate constant */
 VFPTR set_inertia;             /* set the inertia constant */
 FFPTR get_learning_rate;       /* get the learning rate constant */
 FFPTR get_inertia;             /* get the inertia constant */
 VFPTR set_random_init_seed;    /* set the seed for random# generator */
 VFPTR set_random_init_range;   /* set the range of values about 0 for init */

 IFPTR init_network;            /* initialize */
 VFPTR network_forward;         /* all black boxes (in order) forward */
 VFPTR network_learn;           /* forward and back for 'n' iterations */
 IFPTR dump_network;            /* dump whole network to file */
 IFPTR load_network;            /* load whole network from file */
 PCFPTR error_string;           /* return string describing error */

}NB, *NB_PTR;

/* Buffer with info about parent black box. */
typedef struct black_box_buffer
{
 int bb_index;            /* index of the black box this layer is in */
 char *bb_name;           /* black box name */

 int dynamic;             /* non-zero if learning is possible  */

 int efferent;            /* 1 if output layer connects to no layer,
			     i.e., is an output of the network     */

 int n_layers;            /* number of layers */

 int n_inputs;            /* number of input lines (this is 0 when there
			     is no $INPUTS).
			   */

 int inputs_xdim;        /* if $INPUTS => xdim */
 int inputs_ydim;        /* if $INPUTS => ydim */
 int inputs_delay;       /* number of $INPUTS delay buffers */

 int output_layer_index;  /* the index of the output layer */

 int n_bb_inputs;        /* number of connection buses from other bb's */
 int n_bb_outputs;       /* number of connection buses to other bb's */

 /* BLACK BOX FUNCTIONS SUPPLIED BY BACKPROP COMPILERS */
 VFPTR forward_prop;           /* forward prop */
 FFPTR calc_grad;              /* backwards, return total error */
 VFPTR update_weights;         /* change weights */
 IFPTR get_backprop_counter;   /* returns number of times backproped  */
 VFPTR set_backprop_counter;   /* sets number of times backproped  */
 VFPTR set_target_output;      /* set target vector (may be NULL) */
 PFFPTR get_target_output;     /* get current target vector (may be NULL) */
 PFFPTR get_output;            /* get output vector */
 VFPTR set_input;              /* set input vector (may be NULL) */
 PFFPTR get_input;             /* get current input vector (may be NULL) */
 
}BBB, *BBB_PTR;



/* Communication Buffer w/layer info */
typedef struct layer_buffer {
 /*** Network Info ***/
 NB network_info;         /* structure holds info and functions
			     global to the declared network.
			   */
 /*** Black Box Info ***/
 BBB black_box_info;      /* structure holds info and functions
			     specific to this black box
			   */
 /*** Layer Info ***/
 int layer_index;         /* index of this layer in this black box */
 int layer_type;          /* type of layer */
 char *layer_name;        /* layer name */

 int n_nodes;             /* number of nodes */
 int xdim;                /* n_nodes in x direction */
 int ydim;                /* n_nodes in y direction */
 int delay;               /* how many delay buffers */
 int order;               /* ar? */
 float *ar1;              /* first order connections */
 float *ar2;              /* second order connections */
 float *ar3;              /* third order connections */
 float *values;           /* vector of the current node values */
 float *thresholds;       /* vector of the threshold values for the nodes */
 float *delta_thresholds; /* vector of the previous changes in thresholds */
 float *credit;           /* vector with error signal */
 int n_inputs;            /* number of connection buses into this layer */
 int n_outputs;           /* number of connection buses out of this layer */

 /*** the following is a pointer to an array  of connection buffers */
 CB_PTR connections;
}LB, *LB_PTR;


#endif
