/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

/**
 ** Header file for Aspirin, the neural network
 ** specification language parser for Migraines.
 **
 **/

#include "AmOs.h"

#include "dictionary.h"  /* dictionary lookup structures */

/* describes the delay */
typedef struct delay_descriptor {
  int n;
  int start;
  int end;
  struct delay_descriptor *next;
} DD, *DD_PTR;

/* describes connections between layers */
typedef struct connection_descriptor
{
  int type;                    /* int code for type of connection */
  int shared;                  /* equals 1 when connection matrix is a shared kernel */
  int order;                   /* equals order of connection: 0 => undefined
				                              1 => dot product
							      2 => quadratic
                                */
  char *from;                  /* name of from layer */
  struct layer_descriptor      /* ptr to from layer structure */
    *from_layer;
  char *to;                    /* name of to layer */
  struct layer_descriptor      /* ptr to to layer structure */
    *to_layer; 
  DD delay;                    /* connected at what delay */
  struct black_box_descriptor
    *bbd;                      /* what black box am i in? */

  int size;                    /* how big? */
  int first_order_size;        /* size of first order weight matrix */
  int second_order_size;       /* size of second order weight matrix */

  /*** TESSELLATION FUNCTION DATA ***/
  int xoffset;                 /* this is used for tessellation functions */
  int xrange;                  /* this is used for tessellation functions */
  int xoverlap;                /* this is used for tessellation functions */
  int xresidue;                /* this is used for tessellation functions */
  int yoffset;                 /* this is used for tessellation functions */
  int yrange;                  /* this is used for tessellation functions */
  int yoverlap;                /* this is used for tessellation functions */
  int yresidue;                /* this is used for tessellation functions */

  /*** INITIALIZATION DATA ***/
  int init_function;            /* type of function to initialize weights with */
  float constant;               /* real constant intialization */
  char *C_init;                 /* string specifing a C call to supplied by the user */

  /* stuff */
  char *array_name;            /* name of connection array */
  struct connection_descriptor 
    *next;                     /* list */
  DICTIONARYPTR lookup;        /* dictionary: unused */
} CD, *CD_PTR;


/* describes layers */
typedef struct layer_descriptor
{
  char *name;                /* name of layer */
  struct black_box_descriptor
    *bbd;                    /* what black box am i in? */
  int number;                /* unique integer name */
  int type;                  /* int code for type of nodes in layer */
  int n_nodes;               /* number of nodes */
  int xdim;                  /* n_nodes in x dimension */
  int ydim;                  /* n_nodes in y dimension */
  int layer_order;           /* number of feedback connections */
  int last_delay;            /* index of last delay (1 - # delays) */
  DD_PTR TDNN_connections;   /* delay connections from this to layers that have unique [start,stop] */
  CD_PTR inputs_from;        /* list of CD's */
  CD_PTR outputs_to;         /* list of CD's */

  /*** INITIALIZATION DATA ***/
  int init_function;         /* type of function to initialize thresholds with */
  char *C_transfer;          /* user supplied transfer function */
  char *C_transfer_prime;    /* user supplied derivative transfer function */
  float bias;                /* value of constant bias (LINEAR, USER, QUAD AND PDP) */
  char *C_bias_init;           /* user C function to init bias (LINEAR, USER, QUAD AND PDP) */

  /* double links */
  struct layer_descriptor
    *next;                   
  struct layer_descriptor
    *previous;                   
  DICTIONARYPTR lookup;      /* dictionary: unused */

} LD, *LD_PTR;

/* describes black box networks */
typedef struct black_box_descriptor
{
  char *name;                /* name of bb */
  int dynamic;               /* BBDYNAMIC if learning is possible,
				BBSTATIC if no learning and no dependencies,
				BBSTATIC_DEPEND if no learning *and* dependencies */
  int number;                /* unique integer name */
  int n_nodes;               /* number of nodes */
  int n_layers;              /* number of layers */
  int n_cds;                 /* number of connection descriptors */

  int ar_learning;           /* TRUE if ar learning is enabled */
  int ff_learning;           /* TRUE if feed forward learning is enabled */

  int update_interval;       /* how often to update the weights */
 
  int n_inputs;              /* number of inputs */
  int inputs_xdim;           /* n_inputs in x dimension */
  int inputs_ydim;           /* n_inputs in y dimension */

  char *input_filter;        /* Name of C function to filter inputs */
  char *output_filter;       /* Name of C function to filter outputs */

  char *error_function;      /* Name of C function calculate error */

  int clear_delay;           /* how often to clear the delays */
  int last_input_delay;      /* index of last delay (1 -  number of past input vectors stored) */
  DD_PTR TDNN_connections;   /* delay connections from  $input to layers that have unique [start,stop] */

  int n_outputs;             /* number of outputs */

  CD_PTR input_connections;  /* connections from  $input to layers */

  char *output_layer_name;   /* name of output layer */
  LD_PTR output_layer;       /* the layer that acts as the output vector */
  int efferent;              /* 1 if output layer connects to no layer,
			        i.e., is an output of the network     */

  /* component layers */
  LD_PTR layers;             /* list of LD's */
  DICTIONARYPTR lookup;      /* dictionary: layer_name=>LD_PTR mappings */

  DICTIONARYPTR input_bbds;  /* dictionary: bb_name => BD_PTR mappings,
			        this records the names of black boxes
				that this black box has inputs from 
                              */

  DICTIONARYPTR output_bbds;  /* dictionary: bb_name => BD_PTR mappings,
			        this records the names of black boxes
				that this black box has outputs to
                              */

  int n_bb_inputs;           /* number of connection buses from other bb's */
  int n_bb_outputs;          /* number of connection buses to other bb's */


  /* used for loading data from another dump file */
  char *load_key;            /* name used to look up in dump file and
				load data into this black box.
			      */
  char *datafile;            /* filename to load black box at initialization */

  /* root of the parse graph */
  struct network_descriptor *network;            
} BD, *BD_PTR;

typedef struct network_descriptor
{
  char *name;                /* name of the aspirin file */

  int temporal;              /* true if there is feedback */

  int line_search;           /* NO_LINE_SEARCH if no line search (default),
				LINE_SEARCH if line search,
				LINE_SEARCH_VERBOSE if line search w/printout */
  int line_search_timeout;   /* max line search iterations */
  int line_search_update;    /* how often to line search  */

  int conjugate_gradient;    /* NO_CONJ_GRAD if no conjugate gradient (default),
				CONJ_GRAD_SIMPLE if conjugate gradient search */

  int n_bbds;                /* number of black box descriptors */
  int n_nodes;               /* total number of nodes */
  int n_connections;         /* total number of connections */
  int size;                  /* number of words */
  int nodes_segment;         /* index for start of node data */
  int nodes_segment_size;    /* size of segment */
  int weights_segment;       /* index for start of weight data */
  int weights_segment_size;  /* size of segment */
  DICTIONARYPTR lookup;      /* dictionary: black_box_name=>BD_PTR mappings */
  DICTIONARYPTR symbol_table;/* dictionary: symbol=>SYM_PTR mappings */
} ND, *ND_PTR;


/* symbol structure for global network symbol table */
typedef struct symbol_structure
{
  BD_PTR black_box;    /* the black box that this symbol was defined in */
  DICTIONARYPTR dict;  /* the dictionary in the black box that
			  this symbol was defined in.
			*/
  char *pname;         /* the print name of symbol (string as it was)  */
} SYM_STRUCT, *SYM_PTR;


/* these list the possible layer types */
#define PDP_LAYER_TYPE1 0            /* [0,1] */
#define PDP_LAYER_TYPE2 1            /* [-1/2,1/2] */
#define PDP_LAYER_TYPE3 2            /* [-1,1] */
#define LINEAR_LAYER_TYPE 3
#define QUAD_LAYER_TYPE 4
#define USER_LAYER_TYPE 5

/* these list the possible connection types */
#define NXM_CONNECTION_TYPE 0            /* fully connected */
#define TESS_1D_CONNECTION_TYPE 1        /* 1d window of connectivity */
#define TESS_2D_CONNECTION_TYPE 2        /* 2d window of connectivity */

/* these list the possible initialize functions */
#define RANDOM_INIT 0                    /* initialize to small random values */
#define SPATIAL_FILTER_INIT 1            /* initialize to spatial filter */
#define CONSTANT_INIT 2                  /* initialize to constant value */
#define C_INIT 3                         /* initialize with user's C function */

/* status of black box */
#define BBSTATIC         0                /* no learning */
#define BBDYNAMIC        1                /* learning */
#define BBSTATIC_DEPEND  2                /* no learning, other bbs depend on this bb */

/* line search options */
#define NO_LINE_SEARCH 0
#define LINE_SEARCH 1
#define LINE_SEARCH_VERBOSE 2

/* conjugate gradient options */
#define NO_CONJ_GRAD 0
#define CONJ_GRAD_SIMPLE 1



