/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"

extern void _mistake();

/* Note: The goal of all this mess is to have the 
   node data contiguous and the weight data contiguous.
   (For better cache performance and easier port to
   vector machines)
   */

extern int _connection_size();

static int total_nodes=0, total_connections=0;  /* total number of nodes/connections */
static int nodes_size = 0, weights_size = 0;    /* used when declaring pointers */
static int calc_nodes_size, calc_weights_size;  /* temp vars for error check */
static int total_size = 0;                      /* nodes_size + weights_size */
static int max_cds = 0;                         /* max number of connection decriptors in any black box */


#define GLOBALS "/* GLOBAL VARIABLES */\n\
float  BPlearning_rate = 0.2; \n\
float  BPinertia = 0.95;      \n\
static float  init_range = 0.1;\n\
static long   init_seed = 123;\n\
\n\
"
  
  
  
/* find_max_cds: Maximum number of CDs from any layer */
static find_max_cds(bbd)
     BD_PTR bbd;
{
  extern max_cds;
  
  if (max_cds < bbd->n_cds) max_cds = bbd->n_cds;
  
}/* end find_max_cds */


/* _declare_vars:  Declare the global variables, etc. */
void _declare_vars(network, aspirin_file, file)
     ND_PTR network;
     char *aspirin_file, *file;
{
  extern FILE *stream;
  extern int max_cds;
  register int counter;
  
  GenCode("\n\n/**** Back-propagation simulation for %s ****/\n",
	  network->name);
  
  /* constants, macros, globals and structures */
  GenCode("\n\n#include \"aspirin_bp.h\"\n");
  
  /* support code */
  GenCode("\n\n#include \"BpSim.h\"\n");
  
  
  GenCode("\n\n%s\n", GLOBALS);
  
  if (bpthreshold != 0.0) {
    GenCode("\n/* Don't backprop if Error < BPthreshold */");
    GenCode("\nfloat         BPthreshold = %f;\n", bpthreshold);
  }/* end if */
  
  GenCode("\nchar error_string[E_STRING_SIZE]; /* describes current error */");
  
  /* generate a comms buffer for network */
  GenCode("\n\n/* Connection Buffer for interconnect data */");
  /* countup the total number of connection descriptors for size declaration */
  map_dictionary(find_max_cds, network->lookup);
  GenCode("\nstatic CB connection_buffer[%d];", max_cds);
  
  GenCode("\n\n/* Communication Buffer */");
  GenCode("\nstatic LB comms_buffer;");
  
  
}/* end _declare_vars */


/* calc_data_size: Size of data */
static calc_data_size(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  LD_PTR layer, from_layer;
  CD_PTR connection;
  char *name = bbd->name;
  int bbd_number = bbd->number;
  int size;
  
  /* add in any input_layer delay buffers */
  if (bbd->last_input_delay) {
    DD_PTR td = bbd->TDNN_connections;
    
    nodes_size += bbd->n_inputs * bbd->last_input_delay;
    /* add in addtional buffers for TDNN (moving averages) */
    while(td != (DD_PTR)NULL) {
      nodes_size += bbd->n_inputs;
      td = td->next;
    }/* end while */
  }/* end if */
  
  layer = bbd->layers;
  while (layer != (LD_PTR)NULL)
    {
      /* nodes, thresholds */
      total_nodes += layer->n_nodes;
      total_connections += layer->n_nodes; /* thresholds */
      nodes_size += layer->n_nodes;
      weights_size += layer->n_nodes; /* thresholds */
      
      /* if using feedback then need place for reflection coeficients */
      if (layer->layer_order) {
	weights_size += layer->n_nodes * layer->layer_order;       /* for reflection weights */
	total_connections += layer->n_nodes * layer->layer_order;  /* for reflection weights */
	if ( BBCALC_CREDIT(bbd->dynamic) ) { /* if learning ... */
	  nodes_size += layer->n_nodes;                            /* for derivs */
	}/* end if */
      }/* end if layer->layer_order */
      
      /* if quad or user then need to hold the sums */
      switch(layer->type) {
      case USER_LAYER_TYPE :
      case QUAD_LAYER_TYPE :
	nodes_size += layer->n_nodes;
	break;
      }
      
      if ( BBCALC_CREDIT(bbd->dynamic) ) { /* if learning ... */
	
	/* credit , accumulated changes, delta thresholds, reflection coef */
	nodes_size += layer->n_nodes;   /* for credit */
	weights_size += layer->n_nodes; /* for accumulated changes of thresholds */
	
	/* if using feedback then need place for reflection coeficient stuff */
	if (layer->layer_order) {
	  
	  weights_size += layer->n_nodes * (layer->layer_order + 1); /* threshhold partials */
	  weights_size += layer->n_nodes * layer->layer_order;       /* accumulated changes on coef */
	  weights_size += layer->n_nodes * layer->layer_order;       /* delta coef */
	  { int o; /* partials for coef */
	    o = layer->layer_order;
	    weights_size += ( ((o*o) + o)/2   + o) * layer->n_nodes;
	  }/* end block */
	} /* end if layer->layer_order */
	
	weights_size += layer->n_nodes; /* for delta thresholds */
	
      }/* end if */
      
      /* delay buffers */
      if (layer->last_delay) {
	DD_PTR td = layer->TDNN_connections;
	
	nodes_size += layer->n_nodes * layer->last_delay;
	/* if quad or user nodes then need to hold the sums */
	switch(layer->type) {
	case USER_LAYER_TYPE :
	case QUAD_LAYER_TYPE :
	  nodes_size += layer->n_nodes * layer->last_delay;
	  break;
	}
	/* add in addtional buffers for TDNN (moving averages) */
	while(td != (DD_PTR)NULL) {
	  nodes_size += layer->n_nodes;
	  if ( BBCALC_CREDIT(bbd->dynamic) ) nodes_size += layer->n_nodes; /* for credit */
	  td = td->next;
	}/* end while */
      }/* end if */
      
      /* next */
      layer = layer->next;
    }/* end while */
  
  layer = bbd->layers;
  while (layer != (LD_PTR)NULL)
    {
      connection = layer->inputs_from;
      
      while (connection != (CD_PTR)NULL)
	{
	  /* weights */
	  total_connections += _connection_size(connection, bbd);
	  weights_size += _connection_size(connection, bbd);
	  
	  /* learning? */
	  if ( BBCALC_CREDIT(bbd->dynamic) ) {
	    
	    /* accumulated changes */
	    weights_size += _connection_size(connection, bbd);
	    
	    if (layer->layer_order) 
	      /* if using feedback in nodes then need place for running sums for 2 sets of partials if
	         not connected to an input layer, else 1 set */
	      if (connection->from_layer == (LD_PTR)NULL) /* from $INPUTS */
		weights_size += (layer->layer_order + 1)  * _connection_size(connection, bbd);
	      else
		weights_size += (layer->layer_order + 1)  * _connection_size(connection, bbd) * 2;
	    
	    /* delta weights */
	    weights_size += _connection_size(connection, bbd);
	    
	  }/* end if */
	  
	  connection = connection->next;
	}/* end while */
      
      layer = layer->next;
    }/* end while */
  
}/* end calc_data_size */

/* declare_bbs_data:  Declare the vectors for black box data. */
static declare_bbs_data(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  extern int nodes_size,weights_size;
  LD_PTR layer, from_layer;
  CD_PTR connection;
  char *name = bbd->name;
  int bbd_number = bbd->number;
  int size;
  int counter;
  
  GenCode("\n\n/* data for %s */", name);
  GenCode("\nstatic unsigned int b%dfcounter = 0; /* # times fwd */", bbd_number);
  GenCode("\nstatic unsigned int b%dbcounter = 0; /* # times bkwd */", bbd_number);
  
  if (bbd->input_filter != (char *)NULL)
    GenCode("\nextern float *%s(); /* User's Input Filter */", bbd->input_filter);
  if (bbd->output_filter != (char *)NULL)
    GenCode("\nextern void %s(); /* User's Output Filter */", bbd->output_filter);
  if (bbd->error_function != (char *)NULL)
    GenCode("\nextern float %s(); /* User's Error Function */", bbd->error_function);
  
  /* generate the storage for the layers */
  layer = bbd->layers;
  while (layer != (LD_PTR)NULL) {
    int delay_offset;
    
    GenCode("\n\n/* %s */", layer->name);
    
    if (layer->type == USER_LAYER_TYPE) {
      GenCode("\nextern float %s(); /* user's transfer function */",
	      layer->C_transfer);
      GenCode("\nextern float %s(); /* user's derivative of transfer */",
	      layer->C_transfer_prime);
    }/* end if */
    
    if (layer->init_function == C_INIT)
      GenCode("\nextern float %s(); /* user's bias init function */",
	      layer->C_bias_init);
    
    /* declare the data segment, record */
    
    /* if quadratic or user */
    switch(layer->type) {
    case USER_LAYER_TYPE :
    case QUAD_LAYER_TYPE :
      GenCode("\n#define b%d_l%d_n (network_data + %d) /* net inputs */",
	      bbd_number,
	      layer->number,
	      nodes_size  + network->nodes_segment);
      nodes_size += layer->n_nodes;
      break;
    }
    
    if (layer->last_delay) {
      DD_PTR td = layer->TDNN_connections;
      
      delay_offset = nodes_size  + network->nodes_segment; /* where this layer's chunk begins */
      GenCode("\nstatic  int b%d_l%d_dindx = 0;",
	      bbd_number,
	      layer->number);
      GenCode("\n#define b%d_l%d_v (network_data + %d + ((b%d_l%d_dindx %% %d) * %d)) /* values */",
	      bbd_number, layer->number,
	      delay_offset,
	      bbd_number, layer->number,
	      layer->last_delay + 1,
	      layer->n_nodes);
      GenCode("\n#define b%d_l%d_v0 b%d_l%d_v",
	      bbd_number,layer->number,
	      bbd_number,layer->number);
      nodes_size += layer->n_nodes;
      
      /* delays, index modulo size from base */
      for(counter=layer->last_delay; counter>0; counter--) {
	GenCode("\n#define b%d_l%d_v%d (network_data + %d + (((b%d_l%d_dindx + %d) %% %d) * %d)) /* values */",
		bbd_number, layer->number,
		counter,
		delay_offset,
		bbd_number, layer->number,
		layer->last_delay - counter + 1,
		layer->last_delay + 1,
		layer->n_nodes);
	nodes_size += layer->n_nodes;
	switch(layer->type) {
	case USER_LAYER_TYPE :
	case QUAD_LAYER_TYPE :
	  GenCode("\n#define b%d_l%d_n%d (network_data + %d + (((b%d_l%d_dindx + %d) %% %d) * %d)) /* values */",
		  bbd_number,layer->number,
		  counter,
		  delay_offset,
		  bbd_number, layer->number,
		  layer->last_delay - counter,
		  layer->last_delay + 1,
		  layer->n_nodes);
	  nodes_size += layer->n_nodes;
	  break;
	}
      }/* end for delay */
      
      /* add in addtional buffers for TDNN (moving averages) */
      while(td != (DD_PTR)NULL) {
	GenCode("\n#define b%d_l%d_av%d%d (network_data + %d) /* moving average values */",
		bbd_number,
		layer->number,
		td->start,
		td->end,
		nodes_size  + network->nodes_segment);
	nodes_size += layer->n_nodes;
	if ( BBCALC_CREDIT(bbd->dynamic) ) {
	  GenCode("\n#define b%d_l%d_c%d%d (network_data + %d) /* moving average value's credit */",
		  bbd_number,
		  layer->number,
		  td->start,
		  td->end,
		  nodes_size  + network->nodes_segment);
	  nodes_size += layer->n_nodes;
	}/* end if */
	td = td->next;
      }/* end while */
    } else { /* no delays */
      GenCode("\n#define b%d_l%d_v (network_data + %d) /* values */",
	      bbd_number,
	      layer->number,
	      nodes_size  + network->nodes_segment);
      nodes_size += layer->n_nodes;
    }/* end if else */
    
    /* thresholds (biases) */
    GenCode("\n#define b%d_l%d_t (network_data + %d) /* thresholds */",
	    bbd_number,
	    layer->number,
	    weights_size + network->weights_segment);
    weights_size += layer->n_nodes;
    
    /* if using feedback and learning then need place for running sums for partials */
    if (layer->layer_order && BBCALC_CREDIT(bbd->dynamic) ) {
      register int counter;
      
      /* first o */
      GenCode("\n#define b%d_l%d_top ((network_data + %d) + ( (b%d_l%d_dindx %% %d) * %d))     /* partials */",
	      bbd_number, layer->number,
	      weights_size + network->weights_segment,
	      bbd_number, layer->number,
	      layer->layer_order + 1,
	      layer->n_nodes);
      /* rest */
      counter = layer->layer_order;
      do {
	GenCode("\n#define b%d_l%d_top%d ((network_data + %d) + ( ((b%d_l%d_dindx + %d) %% %d) * %d))     /* delayed o partials */",
		bbd_number, layer->number, counter,
		weights_size + network->weights_segment,
		bbd_number, layer->number,
		counter,
		layer->layer_order + 1,
		layer->n_nodes);
      } while(--counter);
      weights_size += (layer->layer_order + 1) * layer->n_nodes;
    }/* end if layer_order */
    
    /* holds the reflection coeficients */
    { int counter = layer->layer_order;
      if (counter) {
	GenCode("\n/* self feed back connection weights  */");
	do {
	  GenCode("\n#define b%d_l%d_r%d (network_data + %d) /* %d reflection coef */",
		  bbd_number,
		  layer->number,
		  counter,
		  weights_size + network->weights_segment,
		  counter);
	  weights_size += layer->n_nodes;
	  if ( BBCALC_CREDIT(bbd->dynamic) ) { /* if learning */
	    GenCode("\n#define b%d_l%d_r%dac (network_data + %d) /* %d accumulated changes for reflection coef */",
		    bbd_number,
		    layer->number,
		    counter,
		    weights_size + network->weights_segment,
		    counter);
	    weights_size += layer->n_nodes;
	    GenCode("\n#define b%d_l%d_r%dd (network_data + %d) /* %d deltas for reflection coef */",
		    bbd_number,
		    layer->number,
		    counter,
		    weights_size + network->weights_segment,
		    counter);
	    weights_size += layer->n_nodes;
	    /* now declare memory for the partial derivs */
	    {   int n = counter;
		/* first */
		GenCode("\n#define b%d_l%d_r%dp ((network_data + %d) + ( (b%d_l%d_dindx %% %d) * %d)) /* %d partial derivatives of reflection coef */",
			bbd_number, layer->number, counter, 
			weights_size + network->weights_segment,
			bbd_number, layer->number,
			counter + 1,
			layer->n_nodes,
			counter);
		/* circular indexing */
		do {
		  GenCode("\n#define b%d_l%d_r%dp%d ((network_data + %d) + ( ((b%d_l%d_dindx + %d) %% %d) * %d)) /* delayed partials */",
			  bbd_number, layer->number, counter, n,
			  weights_size + network->weights_segment,
			  bbd_number, layer->number,
			  n,
			  counter + 1,
			  layer->n_nodes);
		} while(--n);
		weights_size += (counter + 1) * layer->n_nodes;
	      }/* end partial block */
	  }/* end if dynamic */
	} while(--counter);
      }/* end if counter */
    }/* end block */
    
    if ( BBCALC_CREDIT(bbd->dynamic) ) {
      GenCode("\n#define b%d_l%d_ac (network_data + %d) /* accumulated changes */",
	      bbd_number, layer->number,
	      weights_size + network->weights_segment);
      weights_size += layer->n_nodes;
      
      GenCode("\n#define b%d_l%d_dt (network_data + %d) /* delta thresholds */",
	      bbd_number, layer->number,
	      weights_size + network->weights_segment);
      weights_size += layer->n_nodes;
      
      GenCode("\n#define b%d_l%d_c (network_data + %d) /* credit */",
	      bbd_number, layer->number,
	      nodes_size + network->nodes_segment);
      nodes_size += layer->n_nodes;
      
      if (layer->layer_order) { /* need to keep track of derivs */
	GenCode("\n#define b%d_l%d_dv (network_data + %d) /* derivs */",
		bbd_number, layer->number,
		nodes_size + network->nodes_segment);
	nodes_size += layer->n_nodes;
      }/* end if layer->order */
      
    } else { /* static */
      GenCode("\n#define b%d_l%d_ac ((float *)NULL) /* accumulated changes */",
	      bbd_number,
	      layer->number);
      GenCode("\n#define b%d_l%d_dt ((float *)NULL) /* delta thresholds */",
	      bbd_number,
	      layer->number);
      GenCode("\n#define b%d_l%d_c ((float *)NULL) /* credit */",
	      bbd_number,
	      layer->number);
      if (layer->layer_order) { /* need to keep track of derivs */
	GenCode("\n#define b%d_l%d_dv ((float *)NULL) /* derivs */",
		bbd_number, layer->number);
      }/* end if layer->order */
    }/* end else */
    /* next */
    layer = layer->next;
  }/* end while */
  
  /* if black box uses $INPUTS then declare a pointer for input vector */
  if (bbd->input_connections != (CD_PTR)NULL) {
    
    if (bbd->last_input_delay) {
      DD_PTR td = bbd->TDNN_connections;
      int delay_offset;
      
      delay_offset = nodes_size  + network->nodes_segment; /* where this input delay's chunk begins */
      
      GenCode("\n\nstatic float *b%d_input_vector = network_data + %d; %s",
	      bbd_number,
	      delay_offset,
	      "/* input vector */");
      
      GenCode("\nstatic  int b%d_input_dindx = 0;",
	      bbd_number);
      
      /* delays of inputs */
      GenCode("\n\n#define b%d_input_vector0 b%d_input_vector %s",
	      bbd_number,  bbd_number,"/* input vector */");
      for(counter=bbd->last_input_delay; counter>0; counter--) {
	GenCode("\n#define b%d_input_vector%d (network_data + %d + (((b%d_input_dindx + %d) %% %d) * %d)) /* delay values */",
		bbd_number,
		counter,
		delay_offset,
		bbd_number,
		bbd->last_input_delay - counter,
		bbd->last_input_delay,
		bbd->n_inputs);
	nodes_size += bbd->n_inputs;
      }/* end for delays */
      
      /* add in addtional buffers for TDNN (moving averages) */
      while(td != (DD_PTR)NULL) {
	GenCode("\n#define b%d_input_vector_av%d%d (network_data + %d) /* moving average values */",
		bbd_number,
		td->start,
		td->end,
		nodes_size  + network->nodes_segment);
	nodes_size += bbd->n_inputs;
	td = td->next;
      }/* end while */
    }/* end if delay */
    else {
      
      GenCode("\n\nstatic float *b%d_input_vector = (float *)NULL; %s",
	      bbd_number,
	      "/* input vector */");

      GenCode("\n\n#define b%d_input_vector0 b%d_input_vector %s",
	      bbd_number,  bbd_number,"/* input vector */");
      
    }/* end if else */
  }/* end if connected to $INPUTS */
  
  /* declare the target output if this is an efferent black box */
  if (bbd->efferent)
    GenCode(
	    "\n\nstatic float *b%d_target_output = (float *)NULL; %s",
	    bbd_number,
	    "/* desired output */");
  
  /* declare the connection matrices */
  layer = bbd->layers;
  while (layer != (LD_PTR)NULL)  {
    GenCode("\n\n/* %s input connections */",
	    layer->name);
    connection = layer->inputs_from;
    while (connection != (CD_PTR)NULL)
      {
	size = _connection_size(connection, bbd);
	GenCode("\n#define b%d_%s (network_data + %d) /* weights from %s */",
		bbd_number,connection->array_name,
		weights_size  + network->weights_segment,
		connection->from);

	weights_size += size;
	
	if ( BBCALC_CREDIT(bbd->dynamic) ) { /* if learning ... */
	  
	  GenCode("\n#define b%d_%sac (network_data + %d)      /* accumulated changes */",
		  bbd_number,
		  connection->array_name,
		  weights_size + network->weights_segment);

	  weights_size += size;
	  
	  /* deltas */
	  GenCode("\n#define b%d_%sd (network_data + %d)       /* delta weights */",
		  bbd_number, connection->array_name,
		  weights_size + network->weights_segment);

	  weights_size += size;
	  
	  /* if using feedback then need place for running sums for partials */
	  if (layer->layer_order) {
	    register int counter;
	    
	    /* first o */
	    GenCode("\n#define b%d_%sop ((network_data + %d) + ( (b%d_l%d_dindx %% %d) * %d))     /* o partials */",
		    bbd_number, connection->array_name, 
		    weights_size + network->weights_segment,
		    bbd_number, layer->number,
		    layer->layer_order + 1,
		    size);
	    /* first w */
	    if (connection->from_layer != (LD_PTR)NULL) /* not from $INPUTS */
	      GenCode("\n#define b%d_%swp ((network_data + %d) + ( (b%d_l%d_dindx %% %d) * %d))     /* w partials */",
		      bbd_number, connection->array_name, 
		      weights_size + network->weights_segment,
		      bbd_number, layer->number,
		      layer->layer_order + 1,
		      size);
	    
	    /* rest */
	    counter = layer->layer_order;
	    do {
	      GenCode("\n#define b%d_%sop%d ((network_data + %d) + ( ((b%d_l%d_dindx + %d) %% %d) * %d))     /* delayed o partials */",
		      bbd_number, connection->array_name, counter,
		      weights_size + network->weights_segment,
		      bbd_number, layer->number,
		      counter,
		      layer->layer_order + 1,
		      size);
	      if (connection->from_layer != (LD_PTR)NULL) /* not from $INPUTS */
		GenCode("\n#define b%d_%swp%d ((network_data + %d) + ( ((b%d_l%d_dindx + %d) %% %d) * %d))     /* delayed w partials */",
			bbd_number, connection->array_name, counter,
			weights_size + network->weights_segment,
			bbd_number, layer->number,
			counter,
			layer->layer_order + 1,
			size);
	    } while(--counter);

	    if (connection->from_layer != (LD_PTR)NULL) /* not from $INPUTS */
	      weights_size += 2 * (layer->layer_order + 1) * size;
	    else
	      weights_size += (layer->layer_order + 1) * size;
	    
	  }/* end if layer_order */
	  
	} else { /* static ( not learning ) */
	  
	  GenCode("\n#define b%d_%sac ((float *)NULL) /* accumulated changes */",
		  bbd_number,connection->array_name);

	  
	  GenCode("\n#define b%d_%sd ((float *)NULL) /* delta weights */",
		  bbd_number,connection->array_name);
	  
	}/* end else static */
	
	/* declare user supplied init functions as external */
	if (connection->init_function == C_INIT) {
	  GenCode("\n\n/* User supplied init function for weights */");
	  GenCode("\nextern float %s();", connection->C_init);
	}/* end if */
	
	connection = connection->next;
      }/* end while */
    layer = layer->next;
  }/* end while */
  
}/* end declare_bbs_data */

/* _declare_data: Declare the data structures required. */
void _declare_data(network)
     ND_PTR network;
{
  /* declare a single segment of memory to use
     for network data structures. Divide the
     segment into node data and weight data
     (this is desirable for a vector processor).
     */
  
  map_dictionary(calc_data_size, network->lookup);  
  
  total_size = weights_size + nodes_size;
  
  GenCode("\n\n/* NETWORK DATA */");
  network->n_nodes = total_nodes;
  network->n_connections = total_connections;
  network->size = total_size;
  network->nodes_segment = 0;                /* node segment is first */
  network->nodes_segment_size = calc_nodes_size = nodes_size;
  network->weights_segment = nodes_size;     /* next is weight segment */
  network->weights_segment_size = calc_weights_size = weights_size;
  GenCode("\n#ifndef PADDING");
  GenCode("\n# define PADDING 0");
  GenCode("\n#endif");
  GenCode("\nstatic float network_data[%d+PADDING];\n", network->size);
  
  /* for every black box declare the data structures */
  nodes_size = weights_size = 0;             /* reset */
  map_dictionary(declare_bbs_data, network->lookup);
  
  
  /* just in case... */
  if (total_size != (weights_size + nodes_size)) {
    fprintf(stderr, "\nThe declared size is not the same as the calculated size...arg.");
    fprintf(stderr, "\nThe calculated total size = %d", total_size);
    fprintf(stderr, "\nThe declared total size = %d", (weights_size + nodes_size));
    fprintf(stderr, "\nThe calculated node size = %d", calc_nodes_size);
    fprintf(stderr, "\nThe declared node size = %d", nodes_size);
    fprintf(stderr, "\nThe calculated weight size = %d", calc_weights_size);
    fprintf(stderr, "\nThe declared weight size = %d", weights_size);
    _mistake(" This is a really bad thing...I hope there are no other bugs...\n");
  }/* fi */
  
  
}/* end _declare_data */

    
