/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"

extern void _mistake();

/* used to construct paths */
typedef struct path
{
  int length;         /* length of path from input to output */
  int ply;            /* length of path from here to output */
  LD_PTR layer;       /* ptr to layer */
  struct path *next;  /* path list */
  struct path *next_in_table;      /* layer table list */
}PATH, *PATH_PTR;

/* used to make lists of paths */
typedef struct paths
{
  PATH_PTR path;       /* ptr to a path */
  struct paths *next;  /* next paths */
}PATHS, *PATHS_PTR;

/* this table holds all path structures indexed by layer number,
   and is used to merge layers that are not part of the longest path.
 */
static PATH_PTR *layer_table;  /* pointer to array of path pointers */


/* validate_layers:  Check each layer... */
static void validate_layers(bbd)
     BD_PTR bbd;
{
  char error_string[100];
  LD_PTR layer = bbd->layers;
  
  /* if a black box has no layers this is an error */
  if (layer == (LD_PTR)NULL)
    {
      sprintf(error_string, "Hey fool, %s has no layers! Why not?", bbd->name);
      _mistake(error_string);
    }/* end if */

  while (layer != (LD_PTR)NULL)
    {
      /* check the type */
      switch(layer->type)
	{
	case PDP_LAYER_TYPE1 : break;
	case PDP_LAYER_TYPE2 : break;
	case PDP_LAYER_TYPE3 : break;
	case USER_LAYER_TYPE : break;
	case LINEAR_LAYER_TYPE : break;
	case QUAD_LAYER_TYPE : break;
	  default :
	    {
	      sprintf(error_string,
		      "Bad news, %s in layer: %s of black box: %s",
		      "this simulator does not support the type of nodes",
		      layer->name,
		      bbd->name);
	      _mistake(error_string);
	    }/* end default */
	}/* end switch */
      /* check to see if connected */
      if ((layer->inputs_from == (CD_PTR)NULL) ||
	  ((layer->outputs_to == (CD_PTR)NULL) && layer != bbd->output_layer))
	{
	  sprintf(error_string,
		  "Excuse me, %s has an unconnected layer: %s.",
		  bbd->name,
		  layer->name);
	  _mistake(error_string);
	}/* end if */
      layer = layer->next;
    }/* end while */
  
}/* end validate layers */



static PATH_PTR search(connections, length, d, n_layers, cycle_table)
     CD_PTR connections;  /* inputs from */
     int length;          /* length of path so far */
     DICTIONARYPTR d;     /* dictionary for black box */
     int n_layers;        /* number of layers in black box */
     char *cycle_table;   /* if cycle_table[layer->number] == 1 
			     the we've hit a cycle. */
{
  char error_string[50];
  int longest_length;
  PATH_PTR path, longest_path;
  PATHS_PTR newpaths, paths = (PATHS_PTR)NULL;
  LD_PTR layer;
  char *new_cycle_table;


  /* one more connection in... */
  length++;
  /* next ply */
  while(connections != (CD_PTR)NULL)
    {
      layer = (LD_PTR)fetch_dictionary(connections->from, d);

      /* if layer == NULL then this connection is to another
	 black box or $INPUTS...therefore end this branch.
       */
      if  (layer != (LD_PTR)NULL)
	{

	  /* first check if cycle */
	  if (*(cycle_table + layer->number))
	    {
	      fprintf(stderr, "\n\tCycle exists using %s. Forget it.\n", layer->name);
	      exit(1);
	    }/* end if */
	  if (paths == (PATHS_PTR)NULL)
	    {
	      paths = (PATHS_PTR)am_alloc_mem(sizeof(PATH));
	      paths->next = (PATHS_PTR)NULL;
	    }/* end if */
	  else
	    {
	      newpaths = (PATHS_PTR)am_alloc_mem(sizeof(PATH));
	      newpaths->next = paths;
	      paths = newpaths;
	    }/* end else */

	  if (layer->inputs_from == (CD_PTR)NULL)
	    {
	      sprintf(error_string,
		      "Woops, %s has no inputs!",
		      layer->name);
	      _mistake(error_string);
	    }/* end if  */

	  
	  /* push into list */
	  paths->path = path = (PATH_PTR)am_alloc_mem(sizeof(PATH));
	  path->layer = layer;
	  path->length = path->ply = length;
	  /* push into layer_table */
	  path->next_in_table = *(layer_table + layer->number);
	  *(layer_table + layer->number)= path;
	  /* mark this layer as passed */
	  new_cycle_table = (char *)am_alloc_mem(n_layers);
	  bcopy(cycle_table, new_cycle_table, n_layers);
	  *(new_cycle_table + layer->number) = 1;
	  /* continue depth first */
	  path->next = search(layer->inputs_from, length, d, n_layers, new_cycle_table);
	  /* bubble up the length of the path */
	  if (path->next != (PATH_PTR)NULL)
	    path->length = path->next->length;
	}/* end if */
       
      /* onward */
      connections = connections->next;
    }/* end while */
    
  /* return the longest path so far */
  if (paths == (PATHS_PTR)NULL)
    {
      return((PATH_PTR)NULL);
    }/* end if */
  else
    {
      longest_path = paths->path;
      longest_length = longest_path->length;
      paths = paths->next;
      while (paths != (PATHS_PTR)NULL)
	{
	  if(paths->path->length > longest_length)
	    {
	      longest_path = paths->path;
	      longest_length = longest_path->length;
	    }/* end if */
	  paths = paths->next;
	}/* end while */

      /* done */
      return(longest_path);
    }/* end else */  

}/* end search */


/* reorder_layers: Reorder the layers so the path from
                   first layer to last layer is longest.
 */
static reorder_layers(bbd)
     BD_PTR bbd;
{
  char error_string[80];
  LD_PTR layer;
  int path_length = 0;
  DICTIONARYPTR d = bbd->lookup;
  char *cycle_table;
  register int counter, deepest_ply;
  register PATH_PTR longest_path, path_ptr, path_ptr2, path_ptr3;
  
  /* brute force search */

  /** begin search with connections from output layer to $input... **/

  /* Make and init a table to hold all path nodes created in search */
  layer_table = (PATH_PTR *)am_alloc_mem(sizeof(PATH_PTR) * bbd->n_layers);

  /* initialize layer_table */
  for(counter = 0; counter<bbd->n_layers; counter++){
    *(layer_table + counter) = (PATH_PTR)NULL;
  }/* end for */

  /* begin search */
  cycle_table = (char *)am_alloc_mem(bbd->n_layers); /* make */
  bzero(cycle_table, bbd->n_layers); /* clear */
  *(cycle_table + bbd->output_layer->number) = 1; /* mark first bin */
  longest_path = search(bbd->output_layer->inputs_from, 0, d, bbd->n_layers, cycle_table);

  /* Path does not include output layer */

  /* if there is only one layer not connected to $inputs then path == NULL */
  if (longest_path != (PATH_PTR)NULL)
    {
      /* merge layers not metioned in the path into the path */
      layer = bbd->layers;
      if (layer == bbd->output_layer) /* output layer not in path */
	layer = layer->next; 

      /* loop through layers to see which are NOT in the longest path
	 and insert by ply.
	 */
      while(layer != (LD_PTR)NULL)
	{
	  /* search through the longest path. */
	  path_ptr = longest_path;
	  while (path_ptr != (PATH_PTR)NULL)
	    {
	      if (path_ptr->layer == layer)
		break;
	      else
		{
		  /*  next layer */
		  path_ptr = path_ptr->next;
		}/* end else */
	    }/* end while */
	  /* if I did not find the layer in the longest path then
	     insert it into the path at the proper ply.
	     */
	  if (path_ptr == (PATH_PTR)NULL)
	    {
	      /* find the path node with the deepest ply and merge */
	      path_ptr = *(layer_table + layer->number);
	      /* if not in table then this is an unconnected layer */
	      if (path_ptr == (PATH_PTR)NULL)
		{
		  sprintf(error_string, "\nError: Unconnected layer: %s.\n\n",
			  layer->name);
		  _mistake(error_string);
		}/* end if */
	      deepest_ply = 0;
	      while (path_ptr != (PATH_PTR)NULL)
		{
		  /* search for max */
		  if (deepest_ply < path_ptr->ply)
		    {
		      deepest_ply = path_ptr->ply;
		      path_ptr2 = path_ptr;
		    }/* end if */
		  
		  /* next */
		  path_ptr = path_ptr->next_in_table;
		}/* end while */
	      
	      /* merge into longest_path at deepest_ply...start from shallow to deep ply */
	      path_ptr = longest_path;
	      while (path_ptr != (PATH_PTR)NULL)
		{
		  /* insert */
		  if (path_ptr->ply == deepest_ply || path_ptr->next == (PATH_PTR)NULL)
		    {
		      path_ptr3 = path_ptr->next;
		      path_ptr->next = path_ptr2;
		      path_ptr2->next = path_ptr3;
		      break;
		    }/* end if */
		  
		  /*  next layer */
		  path_ptr = path_ptr->next;
		}/* end while */
	    }/* end if */
	  
	  /* next layer */
	  layer = layer->next;
	  if (layer == bbd->output_layer) /* output layer not in path */
	    layer = layer->next; 
	}/* end while */
      
      
      /* now reorder the layers */
      {int layer_number = 0; /* reorder the indices */
       
       layer = bbd->output_layer;
       layer->next = (LD_PTR)NULL;
       layer->number = layer_number++;
       for( ; ; )
	 {
	   layer->previous = longest_path->layer;
	   longest_path->layer->next = layer;
	   layer = longest_path->layer;
	   layer->number = layer_number++;
	   /* if at the end tie to black box */
	   if (longest_path->next == (PATH_PTR)NULL)
	     {
	       layer->previous = (LD_PTR)NULL;
	       bbd->layers = layer;
	       break;
	     }/* end if */
	   else
	     longest_path = longest_path->next; 
	 }/* end for */
     }/* end block */

      
    }/* end if */
  
}/* end reorder_layers */ 

/* _validate_black_box:   Check balck box and reorder layers. */
void _validate_black_box(bbd)
     BD_PTR bbd;
{

  /* check to see if all layers are all right */
  validate_layers(bbd);
  
  /* reorder layers such that the last layer is last and the
     length of the path from first to last is the longest...
     also check for cycles.
   */
  reorder_layers(bbd);

}/* end _validate_black_box */
