/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"


/* _connection_size:  Return size of the connection matrix */
int _connection_size(connection, bbd)
     CD_PTR connection;
     BD_PTR bbd;
{
  char error_string[100];
  DICTIONARYPTR d = bbd->lookup;
  LD_PTR to_layer, from_layer;
  int from_size, to_size, size;
  


  /* if size has been computed => return */
  if (connection->size) return(connection->size);


  /* to */
  to_layer = (LD_PTR)fetch_dictionary(connection->to, d);
  /* if this isn't there then the connection is to another bb */
  if(to_layer == (LD_PTR)NULL)
    {
      /* connected to output of black box */
      from_layer =
	((BD_PTR)
	 fetch_dictionary(connection->from,
			  bbd->network->lookup))->output_layer;
      to_size = to_layer->n_nodes;
    }/* end if */
  else
    to_size = to_layer->n_nodes;
  
  /* from */
  from_layer = (LD_PTR)fetch_dictionary(connection->from, d);
  /* if this isn't there then the connection is either
     to $INPUTS or another black box.
     */
  if(from_layer == (LD_PTR)NULL)
    {
      /* connected to $INPUTS? */
      if (strcmp("$INPUTS", connection->from) == 0)
	{
	  from_size = bbd->n_inputs;
	}/* end if */
      else
	{
	  /* connected to output of black box */
	  from_layer =
	    ((BD_PTR)
	     fetch_dictionary(connection->from,
			      bbd->network->lookup))->output_layer;
	  from_size = from_layer->n_nodes;
	}/* end else */
    }/* end if */
  else
    from_size = from_layer->n_nodes;

  /* Calc size */
  switch (connection->type)
    {
    case NXM_CONNECTION_TYPE :
      {
	size = from_size * to_size;
	break;
      }/* end case */
    case TESS_1D_CONNECTION_TYPE :
      {
	if (connection->shared)
	  size = connection->xrange;
	else
	  size = to_size * connection->xrange;
	break;
      }/* end case */
    case TESS_2D_CONNECTION_TYPE :
      {
	if (connection->shared)
	  size = (connection->xrange * connection->yrange);
	else
	  size = (to_layer->n_nodes * connection->xrange * connection->yrange);
	break;
      }/* end case */
      default :
	{
	  sprintf(error_string,
		  "Unknown connection type from %s to %s",
		  connection->from,
		  connection->to);
	  _mistake(error_string);
	}/* end default */
    }/* end switch */

  /* update connection structure */
  connection->first_order_size = size; /* linear connections */

  if (connection->order == 2) { /* if 2nd order then account for extra weights */
    int per_node_size;

    /* number of linear weights per node */
    per_node_size = size / to_layer->n_nodes ;

    /* triangular matrix */
    connection->second_order_size = to_layer->n_nodes * (((per_node_size * per_node_size) + per_node_size) / 2);
  }/* end if order == 2 */

  connection->size = connection->first_order_size + connection->second_order_size; /* total size */
  
  /* done */
  return(connection->size);
  
}/* end _connection_size */
