/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"

extern void _declare_vars();
extern void _declare_data();
extern void _declare_support_fncts();
extern void _declare_bbs();
extern void _declare_network();

/* _create_simulator:   Write the simulation */
void _create_simulator(network, aspirin_file, cfile, file)
     ND_PTR network;
     char *aspirin_file, *cfile, *file;
{

  stream = am_freopen(cfile, "w", stdout); /* stream is declared in bp_generator.h */
  if (stream == NULL)
    {
      fprintf(stderr, "Unable to open: %s", cfile);
      exit(1);
    }/* end if */
  
  GenCode("\n\n/* You may want to run this thru 'cb' or 'indent' */");
  
  /* first write the header and the global variables */
  _declare_vars(network, aspirin_file, file);

  /* declare the data strutures */
  _declare_data(network); 

  /* declare the functions for controlling each black box */
  _declare_bbs(network); 

  /* declare the global network functions */
  _declare_network(network, aspirin_file, file);

  /* generic interface functions ? */
  if (interface)
    _create_interface_fncts(network, file);

  /* done */
  GenCode("\n\n/* end of %s */\n\n", cfile );
  am_fclose(stream);

  /* make pretty */
#ifdef HAS_INDENT
  {
    char pretty_printer[128]; 

    sprintf(pretty_printer, "indent %s", cfile);
    am_system(pretty_printer);
  }
#endif

}/* end _create_simulator */


