/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"

extern void _declare_var_control();
extern void _declare_write_header();
extern void _declare_dump();
extern void _declare_read_header();
extern void _declare_load_black_box();
extern void _declare_load_data();
extern void _declare_load();
extern void _declare_init();
extern void _declare_learning_fncts();
extern void _declare_comms();
extern void _declare_ascii_dump();
extern void _declare_load_ascii();

/* _declare_network:   Declare the global network control functions */
void _declare_network(network,aspirin_file, file)
     ND_PTR network;
     char *aspirin_file, *file;
{
  extern FILE *stream;

  GenCode( "\n\n/* NETWORK FUNCTIONS */");

  /* declare functions for controlling globals */
  _declare_var_control(network, file);

  /* declare function that writes header for dump file */
  _declare_write_header(network);

  /* declare function that dumps weights to disk */
  _declare_dump(network, file);

  /* declare function to read header */
  _declare_read_header(network);

  /* declare function for random access
     of black box data (used INTERNALLY to generated file)  */
  _declare_load_black_box(network);

  /* loads weights for a black box from disk (INTERNAL FUNCTION) */
  _declare_load_data(network);

  _declare_load(network, file); /* declare function that loads weights from disk
			          for whole network */
  
    
  /* generic learning functions */
  _declare_learning_fncts(network, file);
  
  /* declare the initialization routine */
  _declare_init(network, aspirin_file, file);

  /* declare communication routine...allows the user to query
     the net for layers...returns a layer buffer that can be
     copied.
   */
  _declare_comms(network, file); 

  /* declare function to print out entire state of network */
  _declare_ascii_dump(network, aspirin_file, file);

  /* declare function to read the print out of the entire state of network */
  _declare_load_ascii(network, aspirin_file, file);

}/* end _declare_network */
