/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"


/* _declare_io_fncts:   Declare code for setting/getting input/output. */
void  _declare_io_fncts(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char *name = bbd->name;
  int bbd_number = bbd->number;

  /* allow user to control the iteration counter */
  GenCode( "\n\n/* COUNTER CONTROL */");
  GenCode( "\nvoid %s_set_backprop_counter(x)\n\tint x;\n{", name);
  GenCode( "\n\tb%dbcounter = x;\n}/* end %s_set_backprop_counter */",
	  bbd_number, name);
  GenCode( "\nint %s_get_backprop_counter()\n{", name);
  GenCode( "\n\treturn(b%dbcounter);\n}/* end %s_get_backprop_counter */",
	  bbd_number, name);

  /* if the input is used then create access functions */
  if (bbd->input_connections != (CD_PTR)NULL)
    {
      GenCode( "\n\n/* INPUT CONTROL */");
      /* set_input */
      GenCode( "\nvoid %s_set_input(vector)\n\tfloat *vector;\n{",
	      name);
      
      /* if this bb has delay buffers associated with its input then
	 copy data.
	 */
      if (bbd->last_input_delay) {
	int counter;

	if (bbd->clear_delay) {
	  DD_PTR td = bbd->TDNN_connections;
	  
	  GenCode("\n\t/* zero delays every %d cycles */", bbd->clear_delay);
	  GenCode("\n\tif (! b%dfcounter %% %d) {", bbd->number, bbd->clear_delay);
	  GenCode("\n   b%d_input_dindx = 0;", bbd->number);
	  GenCode("\n\t  bzero((char *)b%d_input_vector%d, %d * sizeof(float));",
		  bbd->number, bbd->last_input_delay,
		  bbd->n_inputs * bbd->last_input_delay);
	  
	  /* clear buffers for TDNN (moving averages) */
	  while(td != (DD_PTR)NULL) {
	    GenCode( "\n\n   bzero((char *)b%d_input_vector_av%d%d, %d * sizeof(float));",
		    bbd->number,
		    td->start,
		    td->end,
		    bbd->n_inputs);
	    td = td->next;
	  }/* end while */  
	  GenCode("\n\t}\n\telse");
	  
	} /* end clear_delay */
	
	GenCode("\n\t{ /* copy data back in time...inc circular index...pretty wierd huh? */");
	GenCode("\n\t  b%d_input_dindx = (b%d_input_dindx + 1) %% %d;",
		bbd->number,
		bbd->number,
		bbd->last_input_delay);
	GenCode("\n\t  bcopy((char *)b%d_input_vector, (char *)b%d_input_vector1, %d * sizeof(float));",
		bbd->number,
		bbd->number,
		bbd->n_inputs);
	GenCode( "\n\t/* done delay */\n\t}");

      }/* end if delay */

      if (bbd->input_filter != (char *)NULL)
	GenCode( "\n\tb%d_input_vector = %s(vector, %d, %d);",
		bbd_number, bbd->input_filter, bbd->inputs_xdim, bbd->inputs_ydim);
      else
	GenCode( "\n\tb%d_input_vector = vector;", bbd_number);

      GenCode( "\n}/* end %s_set_input */", name);


      /* get_input */
      GenCode( "\n\nfloat *%s_get_input()\n{",
	      name);
      GenCode( "\n\treturn(b%d_input_vector);", bbd_number);
      GenCode( "\n}/* end %s_get_input */", name);
    }/* end if */

  GenCode( "\n\n/* TARGET OUTPUT CONTROL */");
  /* get actual output */
  GenCode( "\n\nfloat *%s_get_output()\n{",
	  name);
  GenCode( "\n\treturn(b%d_l%d_v);",
	  bbd_number,
	  (bbd->output_layer->number));
  GenCode( "\n}/* end %s_get_output */", name);

  /* if this is an efferent black box (nobody connects to the output)...*/
  if(bbd->efferent)
    {
      /* set_target */
      GenCode(
	      "\n\nvoid %s_set_target_output(vector)\n\tfloat *vector;\n{",
	      name);
      GenCode( "\n\tb%d_target_output = vector;", bbd_number);
      GenCode( "\n}/* end %s_set_target_output */", name);
      /* get_target */
      GenCode( "\n\nfloat *%s_get_target_output()\n{",
	      name);
      GenCode( "\n\treturn(b%d_target_output);", bbd_number);
      GenCode( "\n}/* end %s_get_target_output */", name);

    }/* end if */
  
}/* end _declare_io_fncts */
