/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"

#define HEADER "/* backpropagation simulator header file */"

/* export_functions:   Export these functions for all black boxes. */
static export_functions(bbd)
     BD_PTR bbd;
{
  char *name = bbd->name; /* set the name of the black box */

  GenCode( "\n\nextern void %s_propagate_forward();", name);
  GenCode( "\nextern float %s_calc_error();", name);
  GenCode( "\nextern void %s_calc_grad();", name);
  GenCode( "\nextern void %s_update_weights();", name);
  GenCode( "\nextern void %s_set_backprop_counter();", name);
  GenCode( "\nextern int %s_get_backprop_counter();", name);
  GenCode( "\nextern float *%s_get_output();", name);

  /* if it connects to the outside world then target outputs
     can be set...
   */
  if (bbd->efferent)
    {
      GenCode( "\nextern void %s_set_target_output();", name);
      GenCode( "\nextern float *%s_get_target_output();", name);
    }/* end if */
  if (bbd->input_connections != (CD_PTR)NULL)
    {
      GenCode( "\nextern void %s_set_input();", name);
      GenCode( "\nextern float *%s_get_input();", name);
    }/* end if */

}/* end export_functions */

/* create_header: Create a header file for the simulation to be generated */
void _create_header(network, file)
     ND_PTR network;
     char *file;
{
  char header_name[50];
  extern FILE *stream;

  /* create a file.h */
  sprintf(header_name, "%s.h", file);
  stream = am_freopen(header_name, "w", stdout);
  if (stream == NULL)
    {
      fprintf(stderr, "Unable to open: %s", header_name);
      exit(1);
    }/* end if */

  /* write header */
  GenCode("\n%s\n/* From: %s */", HEADER, network->name);
  GenCode("\n\n#include \"aspirin_bp.h\"\n");

  GenCode("\n\n/* NETWORK FUNCTIONS */\n");
  GenCode("extern void %s_set_learning_rate();\n", file);
  GenCode("extern void %s_set_inertia();\n", file);
  GenCode("extern float %s_get_learning_rate();\n", file);
  GenCode("extern float %s_get_inertia();\n", file);
  GenCode("extern int %s_init_network();\n", file);
  GenCode("extern void %s_set_random_init_seed();\n", file);
  GenCode("extern void %s_set_random_init_range();\n", file);
  GenCode("extern int %s_load_network();\n", file);
  GenCode("extern int %s_dump_network();\n", file);
  GenCode("extern int %s_ascii_dump_network();\n", file);
  GenCode("extern int %s_error_string();\n", file);
  GenCode("extern LB_PTR %s_query_network();\n", file);

  /* for every black box...export these functions...*/
  GenCode( "\n/* BLACK BOX FUNCTIONS */");
  map_dictionary(export_functions, network->lookup);
  
  /* close file.h */
  GenCode( "\n");
  am_fclose(stream);
}/* end _create_header */

