/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"


/* _declare_var_control:   Used to set globals */
void _declare_var_control(network, file)
     ND_PTR network;
     char *file;
{
  extern FILE *stream;

  GenCode( "\n\n/* %s_error_string: Return string describing error */",
	  file);
  GenCode( "\nchar *%s_error_string()",
	  file);
  GenCode( "\n{ extern char error_string[];");
  GenCode( "\n   return(error_string);\n}/* end %s_error_string */",
	  file);


  GenCode( "\n\n/* %s_set_learning_rate: Set learning rate */",
	  file);
  GenCode( "\nvoid %s_set_learning_rate(x)\n\tfloat x;",
	  file);
  GenCode( "\n{ extern float BPlearning_rate;");
  GenCode("\n   BPlearning_rate = x;\n}/* end %s_set_learning_rate */",
	  file);

  GenCode( "\n\n/* %s_set_inertia: Set inertia*/",
	  file);
  GenCode( "\nvoid %s_set_inertia(x)\n\tfloat x;",
	  file);
  GenCode( "\n{ extern float BPinertia;");
  GenCode( "\n   BPinertia = x;\n}/* end %s_set_inertia */",
	  file);


  GenCode( "\n\n/* %s_get_learning_rate: Return the  learning rate */",
	  file);
  GenCode( "\nfloat %s_get_learning_rate()\n",
	  file);
  GenCode( "\n{ extern float BPlearning_rate;");
  GenCode( "\n   return(BPlearning_rate);\n}/* end %s_get_learning_rate */",
	  file);

  GenCode( "\n\n/* %s_get_inertia: Return the  inertia*/",
	  file);
  GenCode( "\nfloat %s_get_inertia()\n",
	  file);
  GenCode( "\n{ extern float BPinertia;");
  GenCode( "\n   return(BPinertia);\n}/* end %s_get_inertia */",
	  file);

}/* end _declare_var_control */
