/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

/* the aspirin backprop ...woopee! */

/* last changed:
   May `89 -rrl
   Preparing for release to MITRE related groups.
   Added error_string
   Aug 5, '89 -apw
   removed/changed migraines stuff
   Oct `89 -rrl
   Added Star Array Processor Support 
   Jan `90 -rrl
   Took out Star Array Processor Support
   Jan `91
   Finishing touches on V4.
   July `91
   Beta testing version V5.
   Oct `91 
   Added conjugate gradient
   */

#include <stdio.h>
#include "bp_constants.h"
#include "aspirin.h"

/***  GLOBALS ***/

int interface = FALSE;          /* TRUE for generic networking functions */

int biasdfdt = FALSE;           /* TRUE to bias derivative */
float dfdtbias = 0.0;           /* the bias itself */

float bpthreshold = 0.0;        /* used with max_error on backprop */

/* internal globals */

FILE *stream; /* pointer to file stream */

extern void _mistake();

/* this checks the parse graph */
extern void _validate_black_box();

/* these generate the code into the opened files */
extern void _create_header();
extern void _create_simulator();


/* backprop_generator:  Creates code to simulate the backpropagation
   network described in the network structure.
   Flags:
   -biasdfdt <float> Add constant to derivative of sigmoid.
   -bpthreshold <float> Do not backprop if error < <float>
   -interface  Create high level interface functions
   */	      
backprop_generator(network, aspirin_file, file, flagc, flagv)
     ND_PTR network;
     char *aspirin_file, *file;
     int flagc;
     char *(*flagv);
{
  char cfile[128];
  char *(*user_flagv), *(*user_objv);
  int user_flagc, user_objc;
  register int counter1;
  
  printf("\n\nBackpropagation Simulation Generator (V%d.%d)",
	 BP_MAJOR_VERSION, BP_MINOR_VERSION);
  printf("\n%s", BASIC_COPYRIGHT);

  /* name of generated file */
  sprintf(cfile, "%s.c", file);

  /* read flags */
  if (flagc) {
    printf("\n\nBackpropagation options:");
    user_flagv = (char *(*))am_alloc_mem(flagc);   /* for extra flags */
    user_flagc = 0;
    user_objv = (char *(*))am_alloc_mem(flagc);    /* for extra names passed */
    user_objc = 0;
    for(counter1=0; counter1<flagc; counter1++)
      {
	if (strcmp(flagv[counter1], "-biasdfdt") == 0)
	  {
	    biasdfdt = TRUE;
	    /* if the next arg is not a flag, then use it as a number */
	    if (counter1 + 1 != flagc && *(flagv[counter1 + 1]) != '-')
	      sscanf(flagv[++counter1], "%f", &dfdtbias);
	  }/* end if else */
	else if (strcmp(flagv[counter1], "-bpthreshold") == 0)
	  {
	    /* if the next arg is not a flag, then use it as a number */
	    if (counter1 + 1 != flagc && *(flagv[counter1 + 1]) != '-')
	      sscanf(flagv[++counter1], "%f", &bpthreshold);
	    else
	      _mistake("-bpthreshold needs and argument!");
	  }/* end if else */
	else if (strcmp(flagv[counter1], "-interface") == 0)
	  {
	    interface = TRUE;
	  }/* end if else */
	else
	  {
	    /* collect all other flags and names...these
	       are are ignored.
	       */
	    if (*flagv[counter1] == '-') {
	      user_flagv[user_flagc++] = flagv[counter1];
	    } else {
	      user_objv[user_objc++] = flagv[counter1];
	    }/* end else */
	  }/* end else */
      }/* end for counter1 */
  }/* end if flagc */

  /* notify the user as to his selctions... */
  if (biasdfdt)
    printf("\n\tBiasing sigmoid derivative with uniform noise [0,%f)", dfdtbias);

  /* line search stuff */
  if (network->line_search != NO_LINE_SEARCH) {
    if (network->temporal) {
      fprintf(stderr, "\n\nYou cannot use a line search with a temporal network!\n");
      exit(1);
    } else 
      printf("\n\tUsing a line search to rescale learning rate (%d max iterations)",
	     network->line_search_timeout);
  }/* end if */

  /* conjugate gradient stuff */
  if (network->conjugate_gradient != NO_CONJ_GRAD) {
    if (network->line_search == NO_LINE_SEARCH) {
	fprintf(stderr, "\n\nYou must specify LineSearch to use conjugate gradient!\n");
	exit(1);
      } else
	printf("\n\tUsing a conjugate gradient optimization");
  }/* end if */

  if (bpthreshold != 0.0) {
    if (network->temporal)
      bpthreshold = 0.0;
    else
      printf("\n\tNot updating weights if mean error < %f", bpthreshold);
  }

  if (interface)
    printf("\n\tGenerating interface functions");

  printf("\n\n");

  /* check network description to see if it is a feedforward
     network with a description supported by this generator...
     if so, reorder the layers within each black box such that
     the first layer descriptor is the first layer and the
     last layer is the output layer and the path from first
     to last is longest and there are no cycles.
     */
  map_dictionary(_validate_black_box, network->lookup);
    

  /* create a header file with the exported functions
     and globals.
     */
  _create_header(network, file);

  /* now, create a file that simulates the specified network */
  _create_simulator(network, aspirin_file, cfile, file);

  /* let user know these arguments are not known */
  if (user_flagc || user_objc) {
    printf("\nUnknown flags: ");
    for(counter1=0; counter1<user_flagc; counter1++)
      printf("%s ", user_flagv[counter1]);
    for(counter1=0; counter1<user_objc; counter1++)
      printf("%s ", user_objv[counter1]);
    printf(" (ignoring).");
  }/* end if */

}/* end backprop_generator */
  
