/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "bp_generator.h"
  
extern void _mistake();

/* declare_connection_forward: Write code for the right kind of connection */
static declare_connection_forward(connection_index, connection, to_layer, bbd)
     int connection_index;
     CD_PTR connection;
     LD_PTR to_layer;
     BD_PTR bbd;
{
  extern FILE *stream;
  char error_string[50];
  int type = connection->type;
  LD_PTR from_layer;
  int n_from_nodes;
  int from_xdim, from_ydim;
  char node_array_name[100];
  char *from_nodes_array_name;
  int delay = connection->delay.n;
  register int counter1;
  
  /* get the from layer */
  if (connection->from_layer == (LD_PTR)NULL) /* is it the inputs? */
    {
      n_from_nodes = bbd->n_inputs;
      from_xdim = bbd->inputs_xdim;
      from_ydim = bbd->inputs_ydim;
      
      if (delay) {
	if (connection->delay.start != connection->delay.end)
	  sprintf(node_array_name, "b%d_input_vector_av%d%d",
		  bbd->number,connection->delay.start,connection->delay.end);
	else
	  sprintf(node_array_name, "b%d_input_vector%d", bbd->number,connection->delay.start);
      } else
	sprintf(node_array_name, "b%d_input_vector", bbd->number);
      
      from_nodes_array_name = node_array_name;
    }/* end if */
  else
    {
      from_layer = connection->from_layer;
      
      if (delay) {
	if (connection->delay.start != connection->delay.end)
	  sprintf(node_array_name,
		  "b%d_l%d_av%d%d", from_layer->bbd->number, from_layer->number,
		  connection->delay.start, connection->delay.end);
	else
	  sprintf(node_array_name,
		  "b%d_l%d_v%d", from_layer->bbd->number, from_layer->number,connection->delay.start);
      } else
	sprintf(node_array_name,
		"b%d_l%d_v", from_layer->bbd->number, from_layer->number);
      
      from_nodes_array_name = node_array_name;
      n_from_nodes = from_layer->n_nodes;
      from_xdim = from_layer->xdim;
      from_ydim = from_layer->ydim;
    }/* end else */
  
  /* choose the proper type of connection */
  GenCode( "\n /* Connection to %s from %s */",
	  to_layer->name,
	  connection->from);
  
  switch(type)
    {
    case NXM_CONNECTION_TYPE :      /* fully connected between layers */ 
    case TESS_1D_CONNECTION_TYPE : {
      if (connection->shared)
	{
	  
	  if (connection_index == 0)
	    GenCode( "\n BPlvdot_share(b%d_%s, %s + %d, %d, b%d_l%d_v, %d, %d);",
		    bbd->number,connection->array_name,
		    node_array_name, connection->xoffset,
		    connection->xoverlap,
		    bbd->number, to_layer->number,
		    connection->xrange,
		    to_layer->n_nodes);
	  else
	    GenCode( "\n BPlvdot_share_sum(b%d_%s, %s + %d, %d, b%d_l%d_v, %d, %d);",
		    bbd->number,connection->array_name,
		    node_array_name,connection->xoffset,
		    connection->xoverlap,
		    bbd->number, to_layer->number,
		    connection->xrange,
		    to_layer->n_nodes);
	  

	  
	} else { /* not shared */
	  
	  if (connection_index == 0)
	    GenCode( "\n BPlvdot(b%d_%s, %s + %d, %d, b%d_l%d_v, %d, %d);",
		    bbd->number,connection->array_name,
		    node_array_name,connection->xoffset,
		    connection->xoverlap,
		    bbd->number, to_layer->number,
		    connection->xrange,
		    to_layer->n_nodes);
	  else
	    GenCode( "\n BPlvdot_sum(b%d_%s, %s + %d, %d, b%d_l%d_v, %d, %d);",
		    bbd->number,connection->array_name,
		    node_array_name,connection->xoffset,
		    connection->xoverlap,
		    bbd->number, to_layer->number,
		    connection->xrange,
		    to_layer->n_nodes);
	  
	}/* end if else */
      
      break;
    }/* end TESS_1D_CONNECTION_TYPE */
    case TESS_2D_CONNECTION_TYPE :   {
      if (connection_index == 0)
	GenCode( "\n bzero((char *)b%d_l%d_v, %d * sizeof(float));/* reset */",
		bbd->number, to_layer->number, to_layer->n_nodes);
      
      if (connection->shared) { /* shared weights */
	GenCode( "\n BPlvdot2d_share(%d,%d,%d,%d,b%d_%s,%s + %d,b%d_l%d_v,%d,%d,%d);",
		to_layer->xdim,
		to_layer->ydim,
		connection->xrange,
		connection->yrange,
		bbd->number, connection->array_name,
		node_array_name, (connection->xoffset + (connection->yoffset * from_xdim)),
		bbd->number, to_layer->number,
		connection->xoverlap,
		from_xdim,
		(from_xdim * connection->yoverlap));
	
      } else { /* not shared */
	GenCode( "\n BPlvdot2d(%d,%d,%d,%d,b%d_%s,%s + %d,b%d_l%d_v,%d,%d,%d,%d);",
		to_layer->xdim,
		to_layer->ydim,
		connection->xrange,
		connection->yrange,
		bbd->number, connection->array_name,
		node_array_name,  (connection->xoffset + (connection->yoffset * from_xdim)),
		bbd->number, to_layer->number,
		connection->xoverlap,
		to_layer->xdim * connection->xrange,
		from_xdim,
		(from_xdim * connection->yoverlap));
	
      }/* end else not shared */
      
      break;
    }/* end TESS_2D_CONNECTION_TYPE */
      default :
	{
	  sprintf(error_string, "Unknown connection type from: %s to: %s",
		  connection->from,
		  connection->to);
	  _mistake(error_string);
	}/* end default */
    }/* end switch */
}/* end declare_connection_forward */


/* declare_layer_forward: Write code to pipe values forward. */
static declare_layer_forward(layer, bbd)
     LD_PTR layer;
     BD_PTR bbd;
{
  extern FILE *stream;
  char error_string[100];
  CD_PTR connection = layer->inputs_from;
  LD_PTR from_layer;
  char node_array_name[50];
  char *from_nodes_array_name;
  int connection_counter = 0; /* used so I know which one is first */
  int sigmoid_index = 1; /* used to get proper sigmoid macro */
  
  GenCode( "\n\n /* ---------------- %s ---------------- */", layer->name);
  
  
  /* if this layer has delay buffers associated with it, then
     increment index into circular buffer
     */
  if (layer->last_delay) { 
    GenCode("\n { /* copy data back in time...inc circular index...pretty wierd huh? */");
    GenCode("\n   b%d_l%d_dindx = (b%d_l%d_dindx + 1) %% %d;",
	    bbd->number, layer->number,
	    bbd->number, layer->number,
	    layer->last_delay);
    GenCode("\n }");
  }/* end if delay */
  
  /* go through all of the connections into this layer */
  while (connection != (CD_PTR)NULL)    {
    declare_connection_forward(connection_counter++,
			       connection, layer, bbd); 
    connection = connection->next;
  }/* end while */

  switch(layer->type) {
    case PDP_LAYER_TYPE3 : { sigmoid_index = 3; goto generate_code; }
    case PDP_LAYER_TYPE2 : { sigmoid_index = 2; goto generate_code; }
    case PDP_LAYER_TYPE1 :
      {
	generate_code :
	  
	  /* transfer function */
	  GenCode( "\n /* calculate the transfer function for %s */", layer->name);
	GenCode( "\n BPsig%d(b%d_l%d_v, b%d_l%d_t, %d);",
		sigmoid_index, bbd->number, layer->number,  bbd->number, layer->number, layer->n_nodes);
	break;
      }
    case LINEAR_LAYER_TYPE :
      {
	/* transfer function */
	GenCode( "\n /* calculate the transfer function for %s */", layer->name);
	GenCode( "\n BPlinear(b%d_l%d_v, b%d_l%d_t, %d);",
		bbd->number, layer->number,  bbd->number, layer->number, layer->n_nodes);
	break;
      }
    case QUAD_LAYER_TYPE :
      {
	/* transfer function */
	GenCode( "\n /* calculate the transfer function for %s */", layer->name);
	GenCode( "\n BPquadratic(b%d_l%d_v, b%d_l%d_n, b%d_l%d_t, %d);",
		bbd->number, layer->number,
		bbd->number, layer->number,
		bbd->number, layer->number,
		layer->n_nodes);
	break;
      }
    case USER_LAYER_TYPE :
      {
	/* transfer function */
	GenCode( "\n /* calculate the transfer function for %s */", layer->name);
	GenCode( "\n BPuser(b%d_l%d_v, b%d_l%d_n, b%d_l%d_t, %d, %s);",
		bbd->number, layer->number,
		bbd->number, layer->number,
		bbd->number, layer->number,
		layer->n_nodes, layer->C_transfer);	
	break;
      }
      default :
	{
	  sprintf(error_string, "Illegal layer type for %s", layer->name);
	  _mistake(error_string);
	}/* end default */
    }/* end switch */

  /* calc derivs if high order node and learning */
  if (layer->layer_order && BBCALC_CREDIT(bbd->dynamic) ) {

    GenCode("\n\n /* Calc Derivative of nodes (for backward pass) */");
    GenCode("\n BPset_deriv_sig%d(b%d_l%d_dv, b%d_l%d_v, %d, %f);",
	    sigmoid_index,
	    bbd->number, layer->number, 
	    bbd->number, layer->number,
	    layer->n_nodes,
	    dfdtbias);

  }/* end if */

  /* do the reflection coeficients */
  { int counter = layer->layer_order;
    if (counter) {
      GenCode("\n /* self feed back connections */");
      do {
	GenCode("\n BPvmul_sum(b%d_l%d_v, b%d_l%d_r%d, b%d_l%d_v%d, %d);",
		bbd->number, layer->number,
		bbd->number, layer->number, counter,
		bbd->number, layer->number, counter,
		layer->n_nodes);
      } while(--counter);
    }/* end if counter */
  }/* end layer order */
  
  /* update moving averages */
  if (layer->last_delay) {
    DD_PTR td = layer->TDNN_connections;
    
    /* update for TDNN (moving averages) */
    while(td != (DD_PTR)NULL) {
      GenCode( "\n\n BPvsubsmulsum(b%d_l%d_av%d%d, b%d_l%d_v%d, b%d_l%d_v%d, %f, %d);",
	      bbd->number, layer->number, td->start, td->end,
	      bbd->number, layer->number, td->start,
	      bbd->number, layer->number, td->end,
	      1.0 / td->n,
	      layer->n_nodes);
      td = td->next;
    }/* end while */
  }/* end if */


  
}/* end declare_layer_forward */

/* _declare_propagate_forward:   Declare code. */
void _declare_propagate_forward(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char *name = bbd->name;
  int bbd_number = bbd->number;
  LD_PTR layer = bbd->layers;
  
  GenCode( "\n\n/* %s Forward Propagation */", name);
  GenCode("\nvoid %s_propagate_forward()\n{", name);
  
  /* update moving averages */
  if (bbd->last_input_delay) {
    DD_PTR td = bbd->TDNN_connections;
    
    /* update for TDNN (moving averages) */
    while(td != (DD_PTR)NULL) {
      GenCode( "\n BPvsubsmulsum(b%d_input_vector_av%d%d, b%d_input_vector%d, b%d_input_vector%d, %f, %d);",
	      bbd->number, td->start, td->end,
	      bbd->number, td->start,
	      bbd->number, td->end,
	      1.0 / td->n,
	      bbd->n_inputs);
      td = td->next;
    }/* end while */
  }/* end if */
  
  /* begining with the first layer in the list, propagate forward */
  layer = bbd->layers;
  while (layer != (LD_PTR)NULL)
    {
      declare_layer_forward(layer, bbd);
      /* next */
      layer = layer->next;
    }/* end while */
  
  
  if (bbd->output_filter != (char *)NULL)
    GenCode( "\n\n %s(b%d_l%d_v, %d, %d);",
	    bbd->output_filter,
	    bbd->number, bbd->output_layer->number,
	    bbd->output_layer->xdim, bbd->output_layer->ydim);

  GenCode("\n\n b%dfcounter++; /* increment fwd counter */", bbd->number);
  
  GenCode( "\n}/* end %s_ propagate_forward */", name);
  
}/* end _declare_propagate_forward */
  
