/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"

/* declare_layer_comms:  Create if statements for each layer
                         and fill the layer buffer w/data
 */
static int declare_layer_comms(layer)
     LD_PTR layer;
{
  extern FILE *stream;
  CD_PTR connection;
  LD_PTR from_layer;
  BD_PTR bbd = layer->bbd, from_bbd;
  register int n_cds = 0; /*  number of input connection descriptors */

  GenCode("\n   /* Layer %s */", layer->name);
  GenCode("\n   if (layer_index == %d)\n   {", layer->number);
  /* now fill the layer with the correct data */
  GenCode("\n     comms_buffer.layer_index = %d;", layer->number);
  GenCode("\n     comms_buffer.layer_type = %d;", layer->type);
  GenCode("\n     comms_buffer.layer_name = \"%s\";", layer->name);
  GenCode("\n     comms_buffer.n_nodes = %d;", layer->n_nodes);
  GenCode("\n     comms_buffer.delay = %d;", layer->last_delay);
  GenCode("\n     comms_buffer.xdim = %d;", layer->xdim);
  GenCode("\n     comms_buffer.ydim = %d;", layer->ydim);
  GenCode("\n     comms_buffer.values = b%d_l%d_v;",
	  layer->bbd->number, layer->number);

  GenCode("\n     comms_buffer.thresholds = b%d_l%d_t;",
	    layer->bbd->number,
	    layer->number);

  GenCode("\n     comms_buffer.delta_thresholds = b%d_l%d_dt;",
	  layer->bbd->number,
	  layer->number);
  GenCode("\n     comms_buffer.credit = b%d_l%d_c;",
	  layer->bbd->number,
	  layer->number);

  /* ar stuff? */
  GenCode("\n     comms_buffer.order = %d;", layer->layer_order);
  {
    int order = layer->layer_order;

    while(order--) {
      GenCode("\n     comms_buffer.ar%d = b%d_l%d_r%d;",
	      order + 1,
	      layer->bbd->number, layer->number, order + 1);
    }/* end while */
  }

  /* fill the connection buffers */
  connection = layer->inputs_from;
  do {
    GenCode(
    "\n     (comms_buffer.connections)[%d].type = %d;", n_cds, connection->type);
    GenCode(
    "\n     (comms_buffer.connections)[%d].order = %d;",n_cds, connection->order);
    GenCode(
    "\n     (comms_buffer.connections)[%d].shared = %d;", n_cds, connection->shared);
    GenCode(  "\n     (comms_buffer.connections)[%d].size = %d;",
	    n_cds,
	   connection->first_order_size);
    GenCode(  "\n     (comms_buffer.connections)[%d].delay = %d;",
	    n_cds,
	    connection->delay.start);
    GenCode(  "\n     (comms_buffer.connections)[%d].from_layer_name = \"%s\";",
	    n_cds,
	    connection->from);
    GenCode(  "\n     (comms_buffer.connections)[%d].tess_xdim = %d;",
	    n_cds,
	    connection->xrange);
    GenCode(  "\n     (comms_buffer.connections)[%d].tess_ydim = %d;",
	    n_cds,
	    connection->yrange);
    GenCode(  "\n     (comms_buffer.connections)[%d].tess_xoverlap = %d;",
	    n_cds,
	    connection->xoverlap);
    GenCode(  "\n     (comms_buffer.connections)[%d].tess_yoverlap = %d;",
	    n_cds,
	    connection->yoverlap);
    GenCode(  "\n     (comms_buffer.connections)[%d].tess_xoffset = %d;",
	    n_cds,
	    connection->xoffset);
    GenCode(  "\n     (comms_buffer.connections)[%d].tess_yoffset = %d;",
	    n_cds,
	    connection->yoffset);
    if (strcmp(connection->from, "$INPUTS") == 0)
      {
	GenCode(
		"\n     (comms_buffer.connections)[%d].from_bb_index = %d;",
		n_cds,
		bbd->number);
	GenCode(
"\n     (comms_buffer.connections)[%d].from_layer_index = %d; /* $INPUTS */",
		n_cds,
		-1);
	/* now do the from_size and data pointers */
	GenCode(
		"\n     (comms_buffer.connections)[%d].from_size = %d;",
		n_cds,
		bbd->n_inputs);
	GenCode(
		"\n     (comms_buffer.connections)[%d].from_xdim = %d;",
		n_cds,
		bbd->inputs_xdim);
	GenCode(
		"\n     (comms_buffer.connections)[%d].from_ydim = %d;",
		n_cds,
		bbd->inputs_ydim);
	GenCode(
		"\n     (comms_buffer.connections)[%d].weights = b%d_%s;",
		n_cds,
		bbd->number,
		connection->array_name);
	GenCode(
		"\n     (comms_buffer.connections)[%d].delta_weights = b%d_%sd;",
		n_cds,
		bbd->number,
		connection->array_name);

      }/* end if */
    else
      {
	from_layer =
	  (LD_PTR)fetch_dictionary(connection->from, bbd->lookup);
	/* if it is not in this black box then it is in another */
	if (from_layer == (LD_PTR)NULL)  {
	    from_bbd =
	      ((BD_PTR)
	       fetch_dictionary(connection->from, bbd->network->lookup));
	    from_layer = from_bbd->output_layer;
	    GenCode(
		    "\n     (comms_buffer.connections)[%d].from_bb_index = %d;",
		    n_cds,
		    from_bbd->number);
	    GenCode(  "\n     (comms_buffer.connections)[%d].from_layer_index = %d;",
		    n_cds,
		    from_layer->number);
	  }/* end if */
	else
	  {
	    from_bbd = bbd;
	    GenCode(
		    "\n     (comms_buffer.connections)[%d].from_bb_index = %d;",
		    n_cds,
		    bbd->number);
	    GenCode(  "\n     (comms_buffer.connections)[%d].from_layer_index = %d;",
		    n_cds,
		    from_layer->number);
	  }/* end else */
	/* now do the from_size and data pointers */
	GenCode(
		"\n     (comms_buffer.connections)[%d].from_size = %d;",
		n_cds,
		from_layer->n_nodes);
	GenCode(
		"\n     (comms_buffer.connections)[%d].from_xdim = %d;",
		n_cds,
		from_layer->xdim);
	GenCode(
		"\n     (comms_buffer.connections)[%d].from_ydim = %d;",
		n_cds,
		from_layer->ydim);
	GenCode(
		"\n     (comms_buffer.connections)[%d].weights = b%d_%s;",
		n_cds,
		bbd->number,
		connection->array_name);
	GenCode(
		"\n     (comms_buffer.connections)[%d].delta_weights = b%d_%sd;",
		n_cds,
		bbd->number,
		connection->array_name);

      }/* end else */
    n_cds++; /* one more connection */
    connection = connection->next;
  }while(connection != (CD_PTR)NULL);

  /* input connections */
  GenCode("\n     comms_buffer.n_inputs = %d;", n_cds);

  /* output connections */
  n_cds=0;
  connection = layer->outputs_to;
  while (connection != (CD_PTR)NULL) {
    n_cds++; /* one more connection */
    connection = connection->next;
  }/* end while */
  GenCode("\n     comms_buffer.n_outputs = %d;", n_cds);

  /* success */
  GenCode("\n     return(&comms_buffer);/* success!! */");

  GenCode("\n    }/* end if for Layer %s (number %d) */",
	  layer->name,
	  layer->number);
  
}/* end declare_layer_comms */

/* declare_bb_comms:  Create an if statement for each black box. */
static int declare_bb_comms(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;

  GenCode("\n /* Black Box %s */", bbd->name);
  GenCode("\n if(bb_index ==  %d)\n  {", bbd->number);

  /* black box info */
  GenCode("\n    comms_buffer.black_box_info.bb_index = %d;",
	  bbd->number);
  GenCode("\n    comms_buffer.black_box_info.bb_name = \"%s\";",
	  bbd->name);
  GenCode("\n    comms_buffer.black_box_info.dynamic = %d;",
	  bbd->dynamic);
  GenCode("\n    comms_buffer.black_box_info.efferent = %d;",
	  bbd->efferent);
  GenCode("\n    comms_buffer.black_box_info.n_layers = %d;",
	  bbd->n_layers);
  GenCode("\n    comms_buffer.black_box_info.n_inputs = %d;",
	  bbd->n_inputs);
  GenCode("\n    comms_buffer.black_box_info.n_bb_inputs = %d;",
	  bbd->n_bb_inputs);
  GenCode("\n    comms_buffer.black_box_info.n_bb_outputs = %d;",
	  bbd->n_bb_outputs);
  GenCode("\n    comms_buffer.black_box_info.inputs_xdim = %d;",
	  bbd->inputs_xdim);
  GenCode("\n    comms_buffer.black_box_info.inputs_ydim = %d;",
	  bbd->inputs_ydim);
  GenCode("\n    comms_buffer.black_box_info.inputs_delay = %d;",
	  bbd->last_input_delay);
  GenCode("\n    comms_buffer.black_box_info.output_layer_index = %d;",
	  bbd->output_layer->number);

  /* set the control functions */
  GenCode("\n    comms_buffer.black_box_info.forward_prop = (VFPTR)%s_propagate_forward;", bbd->name);
  GenCode("\n    comms_buffer.black_box_info.set_backprop_counter = (VFPTR)%s_set_backprop_counter;", bbd->name);
  GenCode("\n    comms_buffer.black_box_info.get_backprop_counter = (IFPTR)%s_get_backprop_counter;", bbd->name);
  GenCode("\n    comms_buffer.black_box_info.calc_grad = (FFPTR)%s_calc_grad;", bbd->name);
  GenCode("\n    comms_buffer.black_box_info.update_weights = (VFPTR)%s_update_weights;", bbd->name);
  if (bbd->efferent)
    {
      GenCode(    "\n    comms_buffer.black_box_info.set_target_output = (VFPTR)%s_set_target_output;", bbd->name);
      GenCode(    "\n    comms_buffer.black_box_info.get_target_output = (PFFPTR)%s_get_target_output;", bbd->name);
      GenCode(    "\n    comms_buffer.black_box_info.get_output = (PFFPTR)%s_get_output;", bbd->name);
    }/* end if */
  else
    {
      GenCode(    "\n    comms_buffer.black_box_info.set_target_output = (VFPTR)NULL;");
      GenCode(    "\n    comms_buffer.black_box_info.get_target_output = (PFFPTR)NULL;");
      GenCode(    "\n    comms_buffer.black_box_info.get_output = (PFFPTR)NULL;");
    }/* end if */

  if (bbd->input_connections != (CD_PTR)NULL)
    {
      GenCode(    "\n    comms_buffer.black_box_info.set_input = (VFPTR)%s_set_input;", bbd->name);
      GenCode(    "\n    comms_buffer.black_box_info.get_input = (PFFPTR)%s_get_input;", bbd->name);
    }/* end if */
  else
    {
      GenCode(    "\n    comms_buffer.black_box_info.set_input = (VFPTR)NULL;");
      GenCode(    "\n    comms_buffer.black_box_info.get_input = (PFFPTR)NULL;");
    }/* end if */
  
  /* now create ifs for each layer */
  map_dictionary(declare_layer_comms, bbd->lookup); 

  /* if no layer index matches then return (LB_PTR)NULL */
  GenCode("\n  return((LB_PTR)NULL);");

  GenCode("\n  }/* end if for black box %s (number: %d) */",
	  bbd->name,
	  bbd->number);

}/* end declare_bb_comms */

/* _declare_comms: Declare a function that allows user to query the network
                   by layer...two indices are arguments...first the black
		   box index and second, the layer index...return null if the
		   index pair does not match a layer...the user program should
		   call this at init time and build its own network
		   representation based on info in layer buffer...there is
		   only ONE layer buffer...the application should COPY! the
		   data that it needs.
 */
void _declare_comms(network, file)
     ND_PTR network;
     char *file;
{
  extern FILE *stream;
  
  GenCode(
  "\n\n/* %s_query_network   This function returns a pointer to a    */",
	  file);
  GenCode("\n/*                 layer buffer specified by the integer    */");
  GenCode("\n/*                 pair of arguments. The first integer     */");
  GenCode("\n/*                 is the black box index and the second    */");
  GenCode("\n/*                 is the layer index. If no layer has      */");
  GenCode("\n/*                 these indices then (LB_PTR)NULL is       */");
  GenCode("\n/*                 returned. There is only ONE LAYER BUFFER,*/");
  GenCode("\n/*                 so COPY!! the data you need for display. */");
  GenCode("\n/*                 To change the network state alter the    */");
  GenCode("\n/*                 data in the layer buffer.                */");
  GenCode("\nLB_PTR %s_query_network(bb_index, layer_index)",
	  file);
  GenCode("\n\tregister int bb_index, layer_index;\n{");

  GenCode("\n /* look up the black box first, then the layer in the black");
  GenCode(
        "\n    box, if either index does not exist return (LB_PTR)NULL.\n */");

  /* for each black box create an if statement on the bb_index */
  map_dictionary(declare_bb_comms, network->lookup); 

  /* if no black box matches bb_index return NULL */
  GenCode("\n return((LB_PTR)NULL);");

  GenCode("\n}/* end %s_query_network */\n", file);

}/* end declare_comms */
