/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"

extern int _connection_size();

/*   _declare_bb_clear_delays: gen function to clear the delay buffers */
void  _declare_bb_clear_delays(bbd)
     BD_PTR bbd;
{
  LD_PTR layer = bbd->layers;

  GenCode("\n\nvoid %s_bb_clear_delays()\n{", bbd->name);

  while(layer != (LD_PTR)NULL) {

 

    
    if (layer->last_delay) { /* zero taps */
      DD_PTR td = layer->TDNN_connections;
      
      GenCode("\n   b%d_l%d_dindx = 0;", bbd->number, layer->number);
      GenCode("\n   bzero((char *)b%d_l%d_v0, %d * sizeof(float));",
	      bbd->number, layer->number, 
	      layer->n_nodes * (layer->last_delay + 1));
      
      /* clear buffers for TDNN (moving averages) */
      while(td != (DD_PTR)NULL) {
	GenCode( "\n   bzero((char *)b%d_l%d_av%d%d, %d * sizeof(float));",
		bbd->number,
		layer->number,
		td->start,
		td->end,
		layer->n_nodes);
	td = td->next;
      }/* end while */
    }/* end if */
    layer = layer->next;
  }/* end while */

  if (bbd->input_connections != (CD_PTR)NULL &&
      bbd->last_input_delay) { /* zero taps */
    DD_PTR td = bbd->TDNN_connections;
    
    GenCode("\n   b%d_input_dindx = 0;", bbd->number);
    GenCode("\n   bzero((char *)b%d_input_vector%d, %d * sizeof(float));",
	    bbd->number, bbd->last_input_delay,
	    bbd->n_inputs * bbd->last_input_delay);
    
    /* clear buffers for TDNN (moving averages) */
    while(td != (DD_PTR)NULL) {
      GenCode( "\n   bzero((char *)b%d_input_vector_av%d%d, %d * sizeof(float));",
	      bbd->number,
	      td->start,
	      td->end,
	      bbd->n_inputs);
      td = td->next;
    }/* end while */
    
  }/* end if */

  GenCode("\n}/* end %s_bb_clear_delays */", bbd->name);

}/*   end _declare_bb_clear_delays */
