/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

#include "bp_generator.h"

extern void _declare_propagate_forward();
extern void _declare_calc_error();
extern void _declare_calc_grad();
extern void _declare_update_weights();
extern void _declare_io_functions();
extern void _declare_bb_clear_delays();

/* declare_bb_fncts: Declare the control functions for a black box. */
static void declare_bb_fncts(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char *name = bbd->name;
  
  GenCode( "\n\n/**** %s ****/", name);
  _declare_bb_clear_delays(bbd);
  _declare_propagate_forward(bbd); 
  _declare_calc_error(bbd);
  _declare_calc_grad(bbd);
  _declare_update_weights(bbd);
  _declare_io_fncts(bbd); 
  
}/* end declare_bb_fncts */

/* declare_bbs:  Declare the black box control functions */
void _declare_bbs(network)
     ND_PTR network;
{
  extern FILE *stream;

  GenCode( "\n\n/* Black Box Control Functions */\n");
  map_dictionary(declare_bb_fncts, network->lookup);
  
}/* end declare_bbs */
