/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "bp_generator.h"

extern void _mistake();

/* declare_calc_weight_credit: Calc the credit for all weights */
static void  declare_calc_weight_credit(connection, to_layer, bbd)
     CD_PTR connection;
     LD_PTR to_layer;
     BD_PTR bbd;
{
  extern FILE *stream;
  char error_string[50];
  int n_from_nodes;
  int from_xdim, from_ydim;
  char node_array_name[50];
  char node_credit_name[50];
  char *from_nodes_array_name;
  char *from_nodes_credit_name;
  LD_PTR from_layer;
  int dynamic = 1;            /* set to zero if connected black box
				 has been declared :static
			       */
  int delay = connection->delay.n; /* */
  
  /* get the from layer */
  if (connection->from_layer == (LD_PTR)NULL) { /* is it the inputs? */
    if (delay) {
      if (connection->delay.start != connection->delay.end)
	sprintf(node_array_name, "b%d_input_vector_av%d%d",
		bbd->number,connection->delay.start,connection->delay.end);
      else
	sprintf(node_array_name, "b%d_input_vector%d", bbd->number,connection->delay.start);
    } else {
      sprintf(node_array_name, "b%d_input_vector", bbd->number);
    }/* end if else */
    
    from_nodes_array_name = node_array_name;
    from_nodes_credit_name = (char *)NULL;
    n_from_nodes = bbd->n_inputs;
    from_xdim = bbd->inputs_xdim;
    from_ydim = bbd->inputs_ydim;
  }  else {
    from_layer = connection->from_layer;
    
    if (delay) {
      if (connection->delay.start != connection->delay.end) {
	sprintf(node_array_name,
		"b%d_l%d_av%d%d", from_layer->bbd->number, from_layer->number,
		connection->delay.start, connection->delay.end);
	if ( BBCALC_CREDIT(from_layer->bbd->dynamic) ) /* if bb is static no credit */
	  sprintf(node_credit_name,
		  "b%d_l%d_c%d%d", from_layer->bbd->number, from_layer->number,
		  connection->delay.start, connection->delay.end);
	else {
	  dynamic = 0;
	}/* end else */
      } else {
	sprintf(node_array_name,
		"b%d_l%d_v%d", from_layer->bbd->number, from_layer->number,connection->delay.start);
	
	if ( BBCALC_CREDIT(from_layer->bbd->dynamic) ) /* if bb is static no credit */
	  sprintf(node_credit_name,
		  "b%d_l%d_c", from_layer->bbd->number, from_layer->number);
	else {
	  dynamic = 0;
	}/* end else */
      }/* end else */
      
    } else { /* no delays */
      sprintf(node_array_name,"b%d_l%d_v", 
	      from_layer->bbd->number, from_layer->number);
      
      if ( BBCALC_CREDIT(from_layer->bbd->dynamic) ) /* if bb is static no credit */
	sprintf(node_credit_name,
		"b%d_l%d_c", from_layer->bbd->number, from_layer->number);
      else {
	dynamic = 0;
      }/* end else */
      
    }/* end else */
    
    from_nodes_array_name = node_array_name;
    from_nodes_credit_name = node_credit_name;
    n_from_nodes = from_layer->n_nodes;
    from_xdim = from_layer->xdim;
    from_ydim = from_layer->ydim;
  }/* end else */
  
  /* choose the proper type of connection */
  GenCode("\n /* Connection to %s from %s */", to_layer->name, connection->from);

  switch(connection->type)     {

  case NXM_CONNECTION_TYPE :
  case TESS_1D_CONNECTION_TYPE :      {
    char opartials[64]; /* for name of opartials */
    char wpartials[64]; /* for name of wpartials */
    char deriv[64];    /* for name of deriv */

    *opartials = 0; /* null string */
    *wpartials = 0; /* null string */
    *deriv = 0;    /* null string */

    if (to_layer->layer_order) { /* if feedback connections */
      register int counter;

      if (connection->from_layer != (LD_PTR)NULL) /* bwtn hidden layers */
	sprintf(wpartials, "b%d_%swp,",bbd->number, connection->array_name);      /* wpartials */
      sprintf(opartials, "b%d_%sop,",bbd->number, connection->array_name);      /* opartials */
      sprintf(deriv, "b%d_l%d_dv,",bbd->number, to_layer->number);              /* derivs */

      GenCode("\n\n /* Calc Partial Derivatives for Weights */");
      counter = to_layer->layer_order;
      /* first o */
      GenCode("\n BPlvsmul(b%d_%sop, b%d_%sop%d, b%d_l%d_r%d, %d, %d);",
	      bbd->number, connection->array_name,          /* partials */
	      bbd->number, connection->array_name, counter, /* delayed partials */
	      bbd->number, to_layer->number, counter,       /* reflection coef */
	      connection->first_order_size / to_layer->n_nodes,
	      to_layer->n_nodes);
      if (from_nodes_credit_name != (char *)NULL) { /* not from $INPUTS */
	/* first w */
	GenCode("\n BPlvsmul(b%d_%swp, b%d_%swp%d, b%d_l%d_r%d, %d, %d);",
		bbd->number, connection->array_name,          /* partials */
		bbd->number, connection->array_name, counter, /* delayed partials */
		bbd->number, to_layer->number, counter,       /* reflection coef */
		connection->first_order_size / to_layer->n_nodes,
		to_layer->n_nodes);
      }/* end if not from $INPUTS */
      while(--counter) {
	GenCode("\n BPlvsmul_sum(b%d_%sop, b%d_%sop%d, b%d_l%d_r%d, %d, %d);",
		bbd->number, connection->array_name,          /* partials */
		bbd->number, connection->array_name, counter, /* delayed partials */
		bbd->number, to_layer->number, counter,       /* reflection coef */
		connection->first_order_size / to_layer->n_nodes,
		to_layer->n_nodes);
	if (from_nodes_credit_name != (char *)NULL) { /* not from $INPUTS */
	  GenCode("\n BPlvsmul_sum(b%d_%swp, b%d_%swp%d, b%d_l%d_r%d, %d, %d);",
		  bbd->number, connection->array_name,          /* partials */
		  bbd->number, connection->array_name, counter, /* delayed partials */
		  bbd->number, to_layer->number, counter,       /* reflection coef */
		  connection->first_order_size / to_layer->n_nodes,
		  to_layer->n_nodes);
	}/* end if not from $INPUTS */
      }/* end while */


    }/* end if layer order */
    
    GenCode("\n\n /* Accumulate weight changes */");

    if (from_nodes_credit_name != (char *)NULL && dynamic) {

      if (connection->shared) { /* shared weights */

	GenCode("\n BP%saccum_weights_from_hidden_share(b%d_l%d_c,%s %s+%d,%s+%d,b%d_%s,b%d_%sac, %s %s %d,%d,%d);",
		(to_layer->layer_order)?"T":"",
		bbd->number,to_layer->number,
		deriv,
		from_nodes_array_name, connection->xoffset,
		from_nodes_credit_name, connection->xoffset,
		bbd->number,connection->array_name,
		bbd->number,connection->array_name,
		opartials, wpartials,
		to_layer->n_nodes,
		connection->xrange,
		connection->xoverlap);

      } else { /* not shared */

	GenCode("\n BP%saccum_weights_from_hidden(b%d_l%d_c,%s %s+%d,%s+%d,b%d_%s,b%d_%sac,%s %s %d,%d,%d);",
		(to_layer->layer_order)?"T":"",
		bbd->number,to_layer->number,
		deriv,
		from_nodes_array_name, connection->xoffset,
		from_nodes_credit_name, connection->xoffset,
		bbd->number,connection->array_name,
		bbd->number,connection->array_name,
		opartials, wpartials,
		to_layer->n_nodes,
		connection->xrange,
		connection->xoverlap);
	
      }/* end else */
      
    } else { /* else connected to the $INPUTS */
      if (connection->shared) { /* shared */
	
	GenCode("\n BP%saccum_weights_from_input_share(b%d_l%d_c,%s %s+%d,b%d_%sac,%s %s %d,%d,%d);",
		(to_layer->layer_order)?"T":"",
		bbd->number,to_layer->number,
		deriv,
		from_nodes_array_name, connection->xoffset,
		bbd->number,connection->array_name,
		opartials, wpartials,
		to_layer->n_nodes,
		connection->xrange,
		connection->xoverlap);
	
      } else { /* not shared */
	
	GenCode("\n BP%saccum_weights_from_input(b%d_l%d_c,%s %s+%d,b%d_%sac,%s %s %d,%d,%d);",
		(to_layer->layer_order)?"T":"",
		bbd->number,to_layer->number,
		deriv,
		from_nodes_array_name, connection->xoffset,
		bbd->number,connection->array_name,
		opartials, wpartials,
		to_layer->n_nodes,
		connection->xrange,
		connection->xoverlap);
		
      }/* end else */
      
    }/* end else connected to $INPUTS */
    
    break;
  }/* end case */
  case TESS_2D_CONNECTION_TYPE :    {
    char opartials[64]; /* for name of opartials */
    char wpartials[64]; /* for name of wpartials */
    char deriv[64];    /* for name of deriv */

    *deriv = 0;    /* null string */
    *opartials = 0; /* null string */
    *wpartials = 0; /* null string */

    if (to_layer->layer_order) { /* if feedback connections */
      register int counter;

      if (connection->from_layer != (LD_PTR)NULL) /* bwtn hidden layers */
	sprintf(wpartials, "b%d_%swp,",bbd->number, connection->array_name);   /* wpartials */
      sprintf(opartials, "b%d_%sop,",bbd->number, connection->array_name);   /* opartials */
      sprintf(deriv, "b%d_l%d_dv,",bbd->number, to_layer->number);           /* deriv */
      
      GenCode("\n\n /* Calc Partial Derivatives for Weights */");
      counter = to_layer->layer_order;
      /* first o */
      GenCode("\n BPlvsmul(b%d_%sop, b%d_%sop%d, b%d_l%d_r%d, %d, %d);",
	      bbd->number, connection->array_name,          /* partials */
	      bbd->number, connection->array_name, counter, /* delayed partials */
	      bbd->number, to_layer->number, counter,       /* reflection coef */
	      connection->xrange,
	      to_layer->n_nodes);
      if (from_nodes_credit_name != (char *)NULL) { /* not from $INPUTS */
	/* first w */
	GenCode("\n BPlvsmul(b%d_%swp, b%d_%swp%d, b%d_l%d_r%d, %d, %d);",
		bbd->number, connection->array_name,          /* partials */
		bbd->number, connection->array_name, counter, /* delayed partials */
		bbd->number, to_layer->number, counter,       /* reflection coef */
		connection->xrange,
		to_layer->n_nodes);
      }/* end if not from $INPUTS */
      while(--counter) {
	GenCode("\n BPlvsmul_sum(b%d_%sop, b%d_%sop%d, b%d_l%d_r%d, %d, %d);",
		bbd->number, connection->array_name,          /* partials */
		bbd->number, connection->array_name, counter, /* delayed partials */
		bbd->number, to_layer->number, counter,       /* reflection coef */
		connection->xrange,
		to_layer->n_nodes);
	if (from_nodes_credit_name != (char *)NULL) { /* not from $INPUTS */
	  GenCode("\n BPlvsmul_sum(b%d_%swp, b%d_%swp%d, b%d_l%d_r%d, %d, %d);",
		  bbd->number, connection->array_name,          /* partials */
		  bbd->number, connection->array_name, counter, /* delayed partials */
		  bbd->number, to_layer->number, counter,       /* reflection coef */
		  connection->xrange,
		  to_layer->n_nodes);
	}/* end if not from $INPUTS */
      } /* end while */
      
    }/* end if layer_order */

    GenCode("\n\n  /* Accumulate the weight changes */");
    if (from_nodes_credit_name != (char *)NULL && dynamic) {
	if (connection->shared) { /* shared weights */
	  
	  GenCode("\n BP%saccum2d_weights_from_hidden_share(%d,%d,%d,%d,b%d_%s,b%d_%sac,%s %s %s + %d,%s + %d,b%d_l%d_c,%s %d,%d,%d);",
		  (to_layer->layer_order)?"T":"",
		  to_layer->xdim,
		  to_layer->ydim,
		  connection->xrange,
		  connection->yrange,
		  bbd->number, connection->array_name,
		  bbd->number, connection->array_name,
		  opartials, wpartials,
		  from_nodes_array_name,  (connection->xoffset + (connection->yoffset * from_xdim)),
		  from_nodes_credit_name,  (connection->xoffset + (connection->yoffset * from_xdim)),
		  bbd->number, to_layer->number,
		  deriv,
		  connection->xoverlap,
		  from_xdim,
		  from_xdim * connection->yoverlap);
	  
	} else { /* not shared */
	  
	  GenCode("\n BP%saccum2d_weights_from_hidden(%d,%d,%d,%d,b%d_%s,b%d_%sac,%s %s %s + %d,%s + %d,b%d_l%d_c,%s %d,%d,%d,%d);",
		  (to_layer->layer_order)?"T":"",
		  to_layer->xdim,
		  to_layer->ydim,
		  connection->xrange,
		  connection->yrange,
		  bbd->number, connection->array_name,
		  bbd->number, connection->array_name,
		  opartials, wpartials,
		  from_nodes_array_name,  (connection->xoffset + (connection->yoffset * from_xdim)),
		  from_nodes_credit_name,  (connection->xoffset + (connection->yoffset * from_xdim)),
		  bbd->number, to_layer->number,
		  deriv,
		  connection->xoverlap,
		  to_layer->xdim * connection->xrange,
		  from_xdim,
		  from_xdim * connection->yoverlap);
	  
	}/* end else */
      } else { /* from input */
	
	if (connection->shared) { /* shared weights */
	  
	  GenCode("\n BP%saccum2d_weights_from_input_share(%d,%d,%d,%d,b%d_%sac,%s %s %s + %d,b%d_l%d_c,%s %d,%d,%d);",
		  (to_layer->layer_order)?"T":"",
		  to_layer->xdim,
		  to_layer->ydim,
		  connection->xrange,
		  connection->yrange,
		  bbd->number, connection->array_name,
		  opartials, wpartials,
		  from_nodes_array_name, (connection->xoffset + (connection->yoffset * from_xdim)),
		  bbd->number, to_layer->number,
		  deriv,
		  connection->xoverlap,
		  from_xdim,
		  from_xdim * connection->yoverlap);
	  
	} else { /* not shared */
	  
	  GenCode("\n BP%saccum2d_weights_from_input(%d,%d,%d,%d,b%d_%sac,%s %s %s + %d,b%d_l%d_c,%s %d,%d,%d,%d);",
		  (to_layer->layer_order)?"T":"",
		  to_layer->xdim,
		  to_layer->ydim,
		  connection->xrange,
		  connection->yrange,
		  bbd->number, connection->array_name,
		  opartials, wpartials,
		  from_nodes_array_name,  (connection->xoffset + (connection->yoffset * from_xdim)),
		  bbd->number, to_layer->number,
		  deriv,
		  connection->xoverlap,
		  to_layer->xdim * connection->xrange,
		  from_xdim,
		  from_xdim * connection->yoverlap);
	  
	}/* end else */
      }/* end else */
      
      break;
    }/* end TESS_2D_CONNECTION_TYPE */
    default :
      {
	sprintf(error_string,
		"Unknown connection type from %s to %s",
		from_layer->name,
		to_layer->name);
	_mistake(error_string);
      }/* end default */
  }/* end switch */
  
}/* end declare_calc_weight_credit */

/* declare_clear_errors:   Declare the code to zero error arrays. */
static void declare_clear_errors(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char *name = bbd->name;
  int number = bbd->number;
  LD_PTR layer = bbd->output_layer->previous;
  CD_PTR connection;
  
  while (layer != (LD_PTR)NULL) {
    GenCode("\n bzero((char *)b%d_l%d_c, %d * sizeof(float));",
	    number, layer->number, layer->n_nodes);
    
    if (layer->last_delay) {  /* clear addtional buffers for TDNN (moving averages) */
      DD_PTR td = layer->TDNN_connections;
      
      while(td != (DD_PTR)NULL) {
	GenCode( "\n bzero((char *)b%d_l%d_c%d%d, %d * sizeof(float));",
		bbd->number,
		layer->number,
		td->start,
		td->end,
		layer->n_nodes);
	td = td->next;
      }/* end while */
    }/* end if */
    
    layer = layer->previous;
  }/* end while */
}/* end declare_clear_errors */

static void declare_calc_deriv(bbd, layer)
     BD_PTR bbd;
     LD_PTR layer;
{
  char error_string[50];
  int sigmoid_index = 1;
  int number = bbd->number;
  
  switch(layer->type)  {
    
  case PDP_LAYER_TYPE3 : { sigmoid_index = 3; goto GenCode_output_code; }
  case PDP_LAYER_TYPE2 : { sigmoid_index = 2; goto GenCode_output_code; }
  case PDP_LAYER_TYPE1 :
    {
      GenCode_output_code :
	
	
	GenCode("\n BPderiv_sig%d(b%d_l%d_v,b%d_l%d_c,%d,BPfrandom(%f));",
		sigmoid_index,
		number, layer->number,
		number, layer->number,
		layer->n_nodes,
		dfdtbias);
      break;
    }/* case */
  case QUAD_LAYER_TYPE :
    {
      GenCode("\n BPderiv_quadratic(b%d_l%d_n,b%d_l%d_c,%d);",
	      number, layer->number,
	      number, layer->number,
	      layer->n_nodes);
      break;
    }/* case */
  case USER_LAYER_TYPE :
    {
      GenCode("\n BPderiv_user(b%d_l%d_n,b%d_l%d_c,%d,%s);",
	      number, layer->number,
	      number, layer->number,
	      layer->n_nodes,
	      layer->C_transfer_prime);
      break;
    }/* case */
  case LINEAR_LAYER_TYPE : break;
    default :
      {
	sprintf(error_string, "Unknown layer type for %s", layer->name);
	_mistake(error_string);
      }/* end default */
  }/* end switch */
  
}/* end declare_calc_deriv */

/* declare_backprop_weights:   Declare the code to accumulate the weight changes . */
static void declare_backprop_weights(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char *name = bbd->name;
  int number = bbd->number;
  LD_PTR layer = bbd->output_layer;
  CD_PTR connection;
  
  while (layer != (LD_PTR)NULL)  {
    /* calc derivatives for errors in this layer */
    

    if (layer->layer_order) {
      register int counter;


      
      GenCode("\n\n /* Calc Partial Derivatives for Node FeedBack Weights */");
      counter = layer->layer_order;
      do {

	GenCode("\n /* Add in the delayed values to the partials */");
	GenCode("\n bcopy((char *)b%d_l%d_v%d, (char *)b%d_l%d_r%dp, %d * sizeof(float));",
		bbd->number, layer->number, counter,
		bbd->number, layer->number, counter,
		layer->n_nodes);

	GenCode("\n /* Do recursion */");
	{ int n = counter;
	  
	  do {
	    GenCode("\n BPvmul_sum(b%d_l%d_r%dp, b%d_l%d_r%d, b%d_l%d_r%dp%d, %d);",
		    bbd->number, layer->number, counter,
		    bbd->number, layer->number, counter,
		    bbd->number, layer->number, counter, n,
		    layer->n_nodes);
	  }while (--n);
	}/* end block */

      } while(--counter);
      
      GenCode("\n\n /* Accumulate Changes for Node FeedBack Weights */");
      counter = layer->layer_order;
      do {
	GenCode("\n BPTaccum_reflection_weights(b%d_l%d_r%dac,b%d_l%d_r%dp,b%d_l%d_c,%d);",
		number, layer->number, counter,
		number, layer->number, counter,
		number, layer->number, 
		layer->n_nodes);
      } while(--counter);

    
      GenCode("\n\n /* Calc Partial Derivatives for Node Bias Weights */");
      counter = layer->layer_order;
      GenCode("\n BPvmul(b%d_l%d_top, b%d_l%d_r%d, b%d_l%d_top%d, %d);",
	      bbd->number, layer->number,
	      bbd->number, layer->number, counter,
	      bbd->number, layer->number, counter,
	      layer->n_nodes);
      while(--counter) {
	GenCode("\n BPvmul_sum(b%d_l%d_top, b%d_l%d_r%d, b%d_l%d_top%d, %d);",
		bbd->number, layer->number,
		bbd->number, layer->number, counter,
		bbd->number, layer->number, counter,
		layer->n_nodes);
      }
      
      GenCode("\n\n /* Accumulate Biases */");
      GenCode("\n BPTaccum_biases(b%d_l%d_ac,b%d_l%d_c,b%d_l%d_dv,b%d_l%d_top,%d);",
	      number, layer->number,
	      number, layer->number,
	      number, layer->number,
	      number, layer->number,
	      layer->n_nodes);
      
    } else { /* no feedback */

      GenCode("\n\n /* calc deriv of function and multiply by credit */");
      declare_calc_deriv(bbd, layer);
      
      GenCode("\n\n /* Accumulate Biases */");
      GenCode("\n BPaccum_biases(b%d_l%d_ac,b%d_l%d_c,%d);",
	      number, layer->number,
	      number, layer->number,
	      layer->n_nodes);
      
    }/* end else */
    
    /* do all the connections into this layer */
    GenCode("\n\n /* Do all connections into %s */\n", layer->name);
    connection = layer->inputs_from;
    while (connection != (CD_PTR)NULL) {
      declare_calc_weight_credit(connection, layer, bbd); 
      /* next */
      connection = connection->next;
    }/* end while */
    
    /* previous */
    layer = layer->previous;
  }/*  end while */
  
}/* end declare_backprop_weights */

/* declare_clear_weight_changes:   Declare the code to clear weight changes */
static void declare_clear_weight_changes(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char error_string[50];
  char *name = bbd->name;
  int number = bbd->number;
  LD_PTR layer = bbd->output_layer;
  CD_PTR connection;
  int sigmoid_index = 1;

  if (bbd->update_interval != 1)
    GenCode("\n if ( ! (b%dbcounter %% %d) ) {",
	    number,
	    bbd->update_interval);
  
  while (layer != (LD_PTR)NULL) {

    if (layer->layer_order) { /* if higher order node */
      int order;
      
      order = layer->layer_order;
      switch (order) {
      case 1 :
	GenCode("\n bzero((char *)b%d_l%d_r1ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	break;
      case 2 :
	GenCode("\n bzero((char *)b%d_l%d_r1ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	GenCode("\n bzero((char *)b%d_l%d_r2ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	break;
      case 3 :
	GenCode("\n bzero((char *)b%d_l%d_r1ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	GenCode("\n bzero((char *)b%d_l%d_r2ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	GenCode("\n bzero((char *)b%d_l%d_r3ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	break;
	default :
	  _mistake("Order must be < 4, for now...sorry");
      }/* end switch */
      
      GenCode("\n bzero((char *)b%d_l%d_ac, %d * sizeof(float));",
	      number, layer->number,
	      layer->n_nodes);
      
      /* do all the connections into this layer */
      connection = layer->inputs_from;
      while (connection != (CD_PTR)NULL) {

	GenCode("\n /* Clear Connection from %s to %s*/",
		connection->from,
		connection->to);
 	
	GenCode("\n bzero((char *)b%d_%sac, %d * sizeof(float));",
		number, connection->array_name,
		connection->size);
	
	/* next */
	connection = connection->next;
      }/* end while */
      
      {
	GenCode("\n\n /* zero partials */");
	
	/* threshold partials */
	GenCode("\n bzero((char *)b%d_l%d_top, %d * sizeof(float));",
		bbd->number, layer->number, 
		layer->n_nodes);
	{ /* delayed threshold partials */
	  int dcounter = layer->layer_order;
	  
	  do {
	    GenCode("\n bzero((char *)b%d_l%d_top%d, %d * sizeof(float));",
		    bbd->number, layer->number, dcounter,
		    layer->n_nodes);
	  }while(--dcounter);
	}/* end block */
	
	
	{ /* reflection coef. partials */
	  int order = layer->layer_order;
	  
	  do {

	    GenCode("\n bzero((char *)b%d_l%d_r%dp, %d * sizeof(float));",
		    bbd->number, layer->number, order,
		    layer->n_nodes);

	    { /* delayed reflection coef. partials */
	      int dorder = order;
	      
	      do {
		GenCode("\n bzero((char *)b%d_l%d_r%dp%d, %d * sizeof(float));",
			bbd->number, layer->number, order, dorder,
			layer->n_nodes);
	      }while(--dorder);
	    }/* end block */

	  }while(--order);
	}/* end block */
	
	
	{ /* connections into this layer */
	  CD_PTR connection = layer->inputs_from;
	  
	  while(connection != (CD_PTR)NULL) {
	    
	    GenCode("\n bzero((char *)b%d_%sop, %d * sizeof(float));",
		    bbd->number, connection->array_name,
		    _connection_size(connection,bbd));
	    if (connection->from_layer != (LD_PTR)NULL) { /* not from $INPUTS */
	      GenCode("\n bzero((char *)b%d_%swp, %d * sizeof(float));",
		      bbd->number, connection->array_name,
		      _connection_size(connection,bbd));
	    }/* end if not connected to $INPUTS */
	    
	    { /* delayed threshold partials */
	      int dcounter = layer->layer_order;
	      
	      do {
		GenCode("\n bzero((char *)b%d_%sop%d, %d * sizeof(float));",
			bbd->number, connection->array_name, dcounter,
			_connection_size(connection,bbd));
		if (connection->from_layer != (LD_PTR)NULL) { /* not from $INPUTS */
		  GenCode("\n bzero((char *)b%d_%swp%d, %d * sizeof(float));",
			  bbd->number, connection->array_name, dcounter,
			  _connection_size(connection,bbd));
		}/* end if not connected to $INPUTS */
	      }while(--dcounter);
	    }/* end block */
	    
	    connection = connection->next;
	  }/* end while */
	}/* end block */
	
      }
      
      
    } else { /* not high order node */
      
      GenCode("\n bzero((char *)b%d_l%d_ac, %d * sizeof(float));",
	      number, layer->number,
	      layer->n_nodes);
      
      /* do all the connections into this layer */
      connection = layer->inputs_from;
      while (connection != (CD_PTR)NULL) {
	GenCode("\n /* Clear Connection from %s to %s*/",
		connection->from,
		connection->to);
	/* first order connections */
	GenCode("\n bzero((char *)b%d_%sac, %d * sizeof(float));",
		number, connection->array_name,
		connection->size);
	
	/* next */
	connection = connection->next;
      }/* end while */
      
    }/* end if layer_order */
    
    /* previous */
    layer = layer->previous;
  }/*  end while */
  
  if (bbd->update_interval != 1)
    GenCode("\n }");
  
}/* end declare_clear_weight_changes */

/* declare_update_weights:   Declare the code to change the weights. */
static void declare_update_weights(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char error_string[50];
  char *name = bbd->name;
  int number = bbd->number;
  LD_PTR layer = bbd->output_layer;
  CD_PTR connection;
  int sigmoid_index = 1;

  if (bbd->update_interval != 1  && (network->line_search == NO_LINE_SEARCH) )
    GenCode("\n if ( ! (b%dbcounter %% %d) ) {",
	    number,
	    bbd->update_interval);
  
  while (layer != (LD_PTR)NULL) {

    if (layer->layer_order) { /* if AR node */
      int order;
      
      GenCode("\n\n /* Update and Stablize FeedBack Weights */");

      order = layer->layer_order;
      switch (order) {
      case 1 :
	if (bbd->ar_learning) {
	  GenCode("\n BPTupdate_1st(scalar,b%d_l%d_r1ac,b%d_l%d_r1,b%d_l%d_r1d,%d);",
		  number, layer->number, 
		  number, layer->number,
		  number, layer->number,
		  layer->n_nodes);
	}
	GenCode("\n bzero((char *)b%d_l%d_r1ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	break;
      case 2 :
	if (bbd->ar_learning) {
	  GenCode("\n BPTupdate_2nd(scalar,b%d_l%d_r1ac,b%d_l%d_r2ac,b%d_l%d_r1,b%d_l%d_r2,b%d_l%d_r1d,b%d_l%d_r2d,%d);",
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  layer->n_nodes);
	}
	GenCode("\n bzero((char *)b%d_l%d_r1ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	GenCode("\n bzero((char *)b%d_l%d_r2ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	break;
      case 3 :
	if (bbd->ar_learning) {
	  GenCode("\n BPTupdate_3rd(scalar,b%d_l%d_r1ac,b%d_l%d_r2ac,b%d_l%d_r3ac,b%d_l%d_r1,b%d_l%d_r2,b%d_l%d_r3,b%d_l%d_r1d,b%d_l%d_r2d,b%d_l%d_r3d,%d);",
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  number, layer->number,
		  layer->n_nodes);
	}
	GenCode("\n bzero((char *)b%d_l%d_r1ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	GenCode("\n bzero((char *)b%d_l%d_r2ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	GenCode("\n bzero((char *)b%d_l%d_r3ac, %d * sizeof(float));",
		number, layer->number, 
		layer->n_nodes);
	break;
	default :
	  _mistake("Order must be < 4, for now...sorry");
      }/* end switch */
      

      if (bbd->ff_learning) {
	GenCode("\n\n /* Upate Biases */");
	GenCode("\n BPupdate_weights(scalar,b%d_l%d_ac,b%d_l%d_t,b%d_l%d_dt,%d);",
		number, layer->number,
		number, layer->number,
		number, layer->number,
		layer->n_nodes);
      } /* end if feed forward learning */
      GenCode("\n bzero((char *)b%d_l%d_ac, %d * sizeof(float));",
	      number, layer->number,
	      layer->n_nodes);
      
      /* do all the connections into this layer */
      connection = layer->inputs_from;
      while (connection != (CD_PTR)NULL) {
	
	if (bbd->ff_learning) {
	  GenCode("\n /* Upate Connection from %s to %s*/",
		  connection->from,
		  connection->to);
	  GenCode("\n BPupdate_weights(scalar,b%d_%sac,b%d_%s,b%d_%sd,%d);",
		  number, connection->array_name,
		  number, connection->array_name,
		  number, connection->array_name,
		  connection->size);
	} /* end if feed forward learning */

	GenCode("\n /* Clear Connection from %s to %s*/",
		connection->from,
		connection->to);
 	
	GenCode("\n bzero((char *)b%d_%sac, %d * sizeof(float));",
		number, connection->array_name,
		connection->size);
	
	/* next */
	connection = connection->next;
      }/* end while */
      
      {
	GenCode("\n\n /* zero partials */");
	
	/* threshold partials */
	GenCode("\n bzero((char *)b%d_l%d_top, %d * sizeof(float));",
		bbd->number, layer->number, 
		layer->n_nodes);
	{ /* delayed threshold partials */
	  int dcounter = layer->layer_order;
	  
	  do {
	    GenCode("\n bzero((char *)b%d_l%d_top%d, %d * sizeof(float));",
		    bbd->number, layer->number, dcounter,
		    layer->n_nodes);
	  }while(--dcounter);
	}/* end block */
	
	
	{ /* reflection coef. partials */
	  int order = layer->layer_order;
	  
	  do {

	    GenCode("\n bzero((char *)b%d_l%d_r%dp, %d * sizeof(float));",
		    bbd->number, layer->number, order,
		    layer->n_nodes);

	    { /* delayed reflection coef. partials */
	      int dorder = order;
	      
	      do {
		GenCode("\n bzero((char *)b%d_l%d_r%dp%d, %d * sizeof(float));",
			bbd->number, layer->number, order, dorder,
			layer->n_nodes);
	      }while(--dorder);
	    }/* end block */

	  }while(--order);
	}/* end block */
	
	
	{ /* connections into this layer */
	  CD_PTR connection = layer->inputs_from;
	  
	  while(connection != (CD_PTR)NULL) {
	    
	    GenCode("\n bzero((char *)b%d_%sop, %d * sizeof(float));",
		    bbd->number, connection->array_name,
		    _connection_size(connection,bbd));
	    if (connection->from_layer != (LD_PTR)NULL) { /* not from $INPUTS */
	      GenCode("\n bzero((char *)b%d_%swp, %d * sizeof(float));",
		      bbd->number, connection->array_name,
		      _connection_size(connection,bbd));
	    }/* end if not connected to $INPUTS */
	    
	    { /* delayed threshold partials */
	      int dcounter = layer->layer_order;
	      
	      do {
		GenCode("\n bzero((char *)b%d_%sop%d, %d * sizeof(float));",
			bbd->number, connection->array_name, dcounter,
			_connection_size(connection,bbd));
		if (connection->from_layer != (LD_PTR)NULL) { /* not from $INPUTS */
		  GenCode("\n bzero((char *)b%d_%swp%d, %d * sizeof(float));",
			  bbd->number, connection->array_name, dcounter,
			  _connection_size(connection,bbd));
		}/* end if not connected to $INPUTS */
	      }while(--dcounter);
	    }/* end block */
	    
	    connection = connection->next;
	  }/* end while */
	}/* end block */
	
      }
      
      
    } else { /* not AR node */
      
      if (bbd->ff_learning) {
	GenCode("\n\n /* Upate Biases */");
	GenCode("\n BPupdate_weights(scalar,b%d_l%d_ac,b%d_l%d_t,b%d_l%d_dt,%d);",
		number, layer->number,
		number, layer->number,
		number, layer->number,
		layer->n_nodes);
      }/* end if */
      GenCode("\n bzero((char *)b%d_l%d_ac, %d * sizeof(float));",
	      number, layer->number,
	      layer->n_nodes);
      
      /* do all the connections into this layer */
      connection = layer->inputs_from;
      while (connection != (CD_PTR)NULL) {
	
	if (bbd->ff_learning) {
	  GenCode("\n /* Upate Connection from %s to %s*/",
		  connection->from,
		  connection->to);
	  /* first order connections */
	  GenCode("\n BPupdate_weights(scalar,b%d_%sac,b%d_%s,b%d_%sd,%d);",
		  number, connection->array_name,
		  number, connection->array_name,
		  number, connection->array_name,
		  connection->size);
	}/* end if */

	GenCode("\n /* Clear Connection from %s to %s*/",
		connection->from,
		connection->to);
	/* first order connections */
	GenCode("\n bzero((char *)b%d_%sac, %d * sizeof(float));",
		number, connection->array_name,
		connection->size);
	
	/* next */
	connection = connection->next;
      }/* end while */
      
    }/* end if layer_order */
    
    /* previous */
    layer = layer->previous;
  }/*  end while */
  
  if (bbd->update_interval != 1 && (network->line_search == NO_LINE_SEARCH) )
    GenCode("\n }");
  
}/* end declare_update_weights */

/* _declare_calc_error:  Declare code. */
void _declare_calc_error(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char *name = bbd->name;
  int number = bbd->number;
  
  GenCode("\n\n/****************** %s Error  ******************/", name);
    /* error at output layer (if bb is efferent,
       meaning that it outputs to the outside world and it
       connects to no other layer)
       */
  if ( BBCALC_CREDIT(bbd->dynamic) && bbd->efferent ) {
    LD_PTR layer = bbd->output_layer;
    
    GenCode("\nfloat %s_calc_error()\n{", name);
    GenCode("\n float error; ");
    
    GenCode("\n /*** %s ***/", layer->name);
    if (bbd->error_function != (char *)NULL) {
      GenCode("\n /* Calc Error from User's C function */");
      GenCode("\n error = %s(b%d_target_output,b%d_l%d_v,b%d_l%d_c,%d)/%d;",
	      bbd->error_function,
	      number,
	      number, layer->number,
	      number, layer->number,
	      layer->n_nodes,
	      layer->n_nodes);
      if ( network->line_search == NO_LINE_SEARCH ) { /* the line search does this */
	GenCode("\n /* Modulate by learning rate times 1/(update_interval) */");
	GenCode("\n BPvsmul(b%d_l%d_c, b%d_l%d_c,BPlearning_rate*%f, %d);",
		number, layer->number,
		number, layer->number,
		(float)(1.0/bbd->update_interval),
		layer->n_nodes);
      } else { 
	GenCode("\n /* Modulate by 1/(update_interval) */");
	GenCode("\n BPvsmul(b%d_l%d_c, b%d_l%d_c, %f, %d);",
		number, layer->number,
		number, layer->number,
		(float)(1.0/network->line_search_update),
		layer->n_nodes);
      }/* end else */
    } else { /* default MSE */
      GenCode("\n /* Calc diff between output and target output */");
      if ( network->line_search == NO_LINE_SEARCH ) { /* the line search does this */
	GenCode("\n /* Modulate by learning rate times 1/(update_interval) */");
	GenCode("\n error = BPoutput_error(b%d_target_output,b%d_l%d_v,b%d_l%d_c,BPlearning_rate*%f,%d)/%d;",
		number,
		number, layer->number,
		number, layer->number,
		(float)(1.0/bbd->update_interval),
		layer->n_nodes,
		layer->n_nodes);
      } else { 
	GenCode("\n /* Modulate by 1/(update_interval) */");
	GenCode("\n error = BPoutput_error(b%d_target_output,b%d_l%d_v,b%d_l%d_c,%f,%d)/%d;",
		number,
		number, layer->number,
		number, layer->number,
		(float)(1.0/network->line_search_update),
		layer->n_nodes,
		layer->n_nodes);
      }/* end else */
    }/* end else */
    
    GenCode("\n return(error);");
    GenCode("\n} /* end %s_calc_error */", name);
    
  } else { /* static */
    
    GenCode("\nfloat %s_calc_error()\n{", name);
    GenCode("\n  return(0.0);");
    GenCode("\n} /* end %s_calc_error */", name);
    
  }/* end else */
  
}/* end _declare_calc_error */



/* _declare_calc_grad:  Declare code. */
void _declare_calc_grad(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char *name = bbd->name;
  
  GenCode("\n\n/****************** %s Backward Propagation (Gradient Calc) ******************/", name);
  if ( BBCALC_CREDIT(bbd->dynamic) ) {
    GenCode("\nvoid %s_calc_grad()\n{", name);

    GenCode("\n\n b%dbcounter++; /* increment bwd counter */", bbd->number);

    GenCode("\n\n /* clear errors */");
    declare_clear_errors(bbd);
    
    GenCode("\n\n /* backprop */");
    declare_backprop_weights(bbd);

    GenCode("\n} /* end %s_calc_grad */", name);

  } else { /* static */

    GenCode("\nvoid %s_calc_grad()\n{", name);
    GenCode("\n  return;");
    GenCode("\n} /* end %s_calc_grad */", name);

  }/* end else */
  
}/* end _declare_calc_grad */


/* _declare_update_weights:  Declare code. */
void _declare_update_weights(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  char *name = bbd->name;
  
  GenCode("\n\n/****************** %s Update Weights ******************/", name);
  if ( BBCALC_CREDIT(bbd->dynamic) ) {
    GenCode("\nvoid %s_update_weights(scalar)", name);
    GenCode("\n  float scalar;\n{");
    
    if ( BBUPDATE_WEIGHTS(bbd->dynamic) ) {
      GenCode("\n\n /* update the weights */");
      declare_update_weights(bbd);
    } else { /* static */
      GenCode("\n\n /* clear weight changes */");
      declare_clear_weight_changes(bbd);
    }/* end if */
    
    /* if the output layer has connections to other black boxes then
       you need to clear its credit vector.
       */
    if (bbd->output_layer->outputs_to != (CD_PTR)NULL)
      GenCode("\n\n bzero((char *)b%d_l%d_c, %d * sizeof(float)); /* clear output credit */\n",
	      bbd->number, bbd->output_layer->number, bbd->output_layer->n_nodes);
    

    if (bbd->clear_delay) {
      GenCode("\n\n /* clear delays */");
      GenCode("\n if (! (b%dbcounter %% %d) ) %s_bb_clear_delays();",
	      bbd->number, bbd->clear_delay, bbd->name);
    }

    GenCode("\n} /* end %s_update_weights */", name);

  } else { /* static */

    GenCode("\nvoid %s_update_weights()\n{", name);
    GenCode("\n  return;");
    GenCode("\n} /* end %s_update_weights */", name);

  }/* end else */
  
}/* end _declare_update_weights */
