/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "bp_generator.h"

extern void _mistake();
extern int _connection_size();


/* declare_print_state: Print the weights and stuff. */
static declare_print_state(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  DICTIONARYPTR d = bbd->lookup;
  int number = bbd->number;
  int size;
  CD_PTR connection;
  LD_PTR from_layer, to_layer = bbd->output_layer;
  
  
  GenCode("\n\n if (formatted) printf(\"\\n\\nBlackBox: %s\");", bbd->name);

  GenCode("\n\n if (formatted) printf(\"\\nIterations: %%d\", b%dbcounter);", number);
  GenCode("\n\n else printf(\"\\n%%d\", b%dbcounter);", number);
  
  while (to_layer != (LD_PTR)NULL) {
    
      GenCode("\n\n if (formatted) printf(\"\\nLayer: %s\");", to_layer->name);
    
    GenCode( "\n /* print for %s */", to_layer->name);
    GenCode("\n for(counter4 = 0; counter4<%d; counter4++) {",
	    to_layer->ydim);
    GenCode("\n  for(counter3 = 0; counter3<%d; counter3++) {",
	    to_layer->xdim);
    
      
	GenCode("\n\n    if (formatted) printf(\"\\nNode[%%d,%%d]:\",counter3,counter4);");
    
    /* print reflection coeficients */
    {
      int order = to_layer->layer_order;
      
      if ( order ) {
	int ocounter;
	GenCode("\n  /* self feed back connections */");
	
	/* poles */
	GenCode("\n\n    {");
	GenCode("\n       AM_COMPLEX poles[%d];", order);
	
	switch ( order ) {
	case 1 :
	  GenCode("\n       BPar1_poles((double)b%d_l%d_r1[counter3+(%d*counter4)], poles);",
		  number, to_layer->number, 
		  to_layer->xdim);
	  break;
	case 2 :
	  GenCode("\n       BPar2_poles((double)b%d_l%d_r1[counter3+(%d*counter4)],",
		  number, to_layer->number, 
		  to_layer->xdim);
	  GenCode("\n                    (double)b%d_l%d_r2[counter3+(%d*counter4)], poles);",
		  number, to_layer->number, 
		  to_layer->xdim);
	  break;
	case 3 :
	  GenCode("\n       BPar3_poles((double)b%d_l%d_r1[counter3+(%d*counter4)],",
		  number, to_layer->number, 
		  to_layer->xdim);
	  GenCode("\n                    (double)b%d_l%d_r2[counter3+(%d*counter4)],",
		  number, to_layer->number, 
		  to_layer->xdim);
	  GenCode("\n                    (double)b%d_l%d_r3[counter3+(%d*counter4)], poles);",
		  number, to_layer->number, 
		  to_layer->xdim);
	  break;
	}/* end switch */
	
	/* poles */
	GenCode("\n\n         if (formatted) printf(\"\\n\");");
	ocounter = order;
	do {
	  GenCode("\n\n         if (formatted) printf(\"   Pole%d=%%f + i%%f\", (poles + %d)->real, (poles + %d)->imag);",
		  ocounter, ocounter-1,ocounter-1);
	} while(--ocounter );
	
	GenCode("\n\n    }");
	
	/* weights */
	GenCode("\n\n    if (formatted) printf(\"\\n\");");
	ocounter = order;
	do {
	  GenCode("\n\n    if (formatted)");
	  GenCode("\n      printf(\"   Z^-%d=%%f\", b%d_l%d_r%d[counter3+(%d*counter4)]);",
		  ocounter,
		  number, to_layer->number, ocounter,
		  to_layer->xdim);
	  GenCode("\n      else");
	  GenCode("\n      printf(\"\\n%%f\", b%d_l%d_r%d[counter3+(%d*counter4)]);",
		  number, to_layer->number, ocounter,
		  to_layer->xdim);
	} while(--ocounter);
	
      }/* end if ocounter */
      
    }/* end block */
    
      GenCode("\n\n    if (formatted)");
      GenCode("\n      printf(\"\\n   Bias=%%f\", b%d_l%d_t[counter3+(%d*counter4)]);",
	      number, to_layer->number, to_layer->xdim);
      GenCode("\n      else");
      GenCode("\n      printf(\"\\n%%f\", b%d_l%d_t[counter3+(%d*counter4)]);",
	      number, to_layer->number, to_layer->xdim);
    
    GenCode( "\n  }/* end for counter3 */");
    GenCode( "\n }/* end for counter4 */");
    
    connection = to_layer->inputs_from;
    while (connection != (CD_PTR)NULL)  {
      size = _connection_size(connection, bbd);
      
      
      GenCode("\n\n if (formatted) printf(\"\\nConnection from %s:\");", connection->from);
      
      GenCode("\n for(counter4 = 0; counter4<%d; counter4++) {",
	      (connection->shared)?1:to_layer->ydim);
      GenCode("\n  for(counter3 = 0; counter3<%d; counter3++) {",
	      (connection->shared)?1:to_layer->xdim);
      GenCode("\n\n if (formatted) printf(\"\\nNode[%%d,%%d]:\",counter3,counter4);");
      GenCode("\n   weights = b%d_%s + (counter3 * %d) + (counter4 * %d);",
	      number,
	      connection->array_name,
	      connection->xrange,
	      to_layer->xdim * connection->xrange * connection->yrange);
      GenCode("\n   for(counter1 = 0; counter1<%d; counter1++) {",
	      connection->yrange);
      GenCode("\n    if (formatted) printf(\"\\n\");");
      GenCode("\n    for(counter2 = 0; counter2<%d; counter2++) {",
	      connection->xrange);
      GenCode("\n       if (formatted)");
      GenCode("\n         printf(\"%%f \", *weights++);");
      GenCode("\n       else");
      GenCode("\n         printf(\"\\n%%f \", *weights++);");
      GenCode("\n    }/* end for */");
      /* don't need to jump when there is a shared tessellation
	 or only one tile in the x dimension
	 */
      if ((connection->shared == 0) && (to_layer->xdim > 1))
	GenCode("\n    weights += %d;",
		((to_layer->xdim - 1) *  connection->xrange));
      GenCode("\n   }/* end for */");
      GenCode("\n  }/* end for */");
      GenCode("\n }/* end for */");
      
      /* next */
      connection = connection->next;
    }/* end while */
    
    /* previous */
    to_layer = to_layer->previous;
  }/* end while */
  
} /* end declare_print_state */


/* declare_load_state: Read the weights and stuff. */
static declare_read_state(bbd)
     BD_PTR bbd;
{
  extern FILE *stream;
  DICTIONARYPTR d = bbd->lookup;
  int number = bbd->number;
  int size;
  CD_PTR connection;
  LD_PTR from_layer, to_layer = bbd->output_layer;
  
  GenCode("\n\n scanf(\"\\n%%d\", &b%dbcounter);", number);

  while (to_layer != (LD_PTR)NULL) {
    
    
    GenCode( "\n /* read for %s */", to_layer->name);
    GenCode("\n for(counter4 = 0; counter4<%d; counter4++) {",
	    to_layer->ydim);
    GenCode("\n  for(counter3 = 0; counter3<%d; counter3++) {",
	    to_layer->xdim);
    
    /* print reflection coeficients */
    {
      int order = to_layer->layer_order;
      
      if ( order ) {
	int ocounter;
	GenCode("\n  /* self feed back connections */");

	/* weights */
	ocounter = order;
	do {
	  GenCode("\n\n    scanf(\"%%f\", &b%d_l%d_r%d[counter3+(%d*counter4)]);",
		  number, to_layer->number, ocounter,
		  to_layer->xdim);
	} while(--ocounter);
	
      }/* end if ocounter */
      
    }/* end block */
    
    GenCode("\n\n    scanf(\"%%f\", &b%d_l%d_t[counter3+(%d*counter4)]);",
	    number, to_layer->number, to_layer->xdim);
    
    GenCode( "\n  }/* end for counter3 */");
    GenCode( "\n }/* end for counter4 */");
    
    connection = to_layer->inputs_from;
    while (connection != (CD_PTR)NULL)  {
      size = _connection_size(connection, bbd);
      
      
      GenCode("\n for(counter4 = 0; counter4<%d; counter4++) {",
	      (connection->shared)?1:to_layer->ydim);
      GenCode("\n  for(counter3 = 0; counter3<%d; counter3++) {",
	      (connection->shared)?1:to_layer->xdim);

      GenCode("\n   weights = b%d_%s + (counter3 * %d) + (counter4 * %d);",
	      number,
	      connection->array_name,
	      connection->xrange,
	      to_layer->xdim * connection->xrange * connection->yrange);
      GenCode("\n   for(counter1 = 0; counter1<%d; counter1++) {",
	      connection->yrange);

      GenCode("\n    for(counter2 = 0; counter2<%d; counter2++) {",
	      connection->xrange);
      GenCode("\n       scanf(\"%%f\", weights++);");
      GenCode("\n    }/* end for */");
      /* don't need to jump when there is a shared tessellation
	 or only one tile in the x dimension
	 */
      if ((connection->shared == 0) && (to_layer->xdim > 1))
	GenCode("\n    weights += %d;",
		((to_layer->xdim - 1) *  connection->xrange));
      GenCode("\n   }/* end for */");
      GenCode("\n  }/* end for */");
      GenCode("\n }/* end for */");
      
      /* next */
      connection = connection->next;
    }/* end while */
    
    /* previous */
    to_layer = to_layer->previous;
  }/* end while */
  
} /* end declare_read_state */

/* _declare_ascii_dump:   Print the state of the network. */
void _declare_ascii_dump(network, aspirin_file, file)
     ND_PTR network;
     char *aspirin_file, *file;
{
  extern FILE *stream;

  GenCode("\n\nvoid %s_ascii_dump_network(formatted)\n\tint formatted;\n{", file);
  GenCode("\n int counter1, counter2, counter3, counter4;");
  GenCode("\n float *weights;\n");


  GenCode("\n  if (! formatted) printf(\"\\n\\n#\");");

  map_dictionary(declare_print_state, network->lookup);

  GenCode("\n  if (! formatted) printf(\"\\n\\n#\");");

  GenCode("\n  printf(\"\\n\");");

  GenCode("\n}/* end %s_ascii_dump_network */", file);
  
}/* end _declare_ascii_dump */

/* _declare_load_ascii:   Read the state of the network. */
void _declare_load_ascii(network, aspirin_file, file)
     ND_PTR network;
     char *aspirin_file, *file;
{
  extern FILE *stream;

  GenCode("\n\nvoid %s_load_ascii_network()\n{", file);
  GenCode("\n int counter1, counter2, counter3, counter4;");
  GenCode("\n float *weights;\n");

  GenCode("\n\n {");
  GenCode("\n    char c;");
  GenCode("\n    do {");
  GenCode("\n      am_fread(&c,sizeof(char),1,stdin);");
  GenCode("\n    } while( c != '#' );");
  GenCode("\n\n }");

  map_dictionary(declare_read_state, network->lookup);

  GenCode("\n\n {");
  GenCode("\n    int  code;");
  GenCode("\n    char c;");
  GenCode("\n    do {");
  GenCode("\n      code = am_fread(&c,sizeof(char),1,stdin);");
  GenCode("\n    } while( code );");

  GenCode("\n\n }");

  GenCode("\n}/* end %s_load_ascii_network */", file);
  
}/* end _declare_load_ascii */
