/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/

/** aspirin  This is the user level code that accesses the correct
             neural network compiler.
 **/

#include <stdio.h>
#include "aspirin.h"

extern char *am_alloc_mem();

/*** the parser ***/
extern ND_PTR parse();

/*** the compilers ***/
extern int backprop_generator();   /* backpropagation algorithm */

typedef int (*FUNC_PTR)();

main(argc, argv)
     int argc;
     char *argv[];
{
  int counter1 = 3; /* flag counter */
  FUNC_PTR function = (FUNC_PTR)NULL; /* function ptr */
  int flagc = 0; /* number of flags */
  char *(*flagv); /* pointer to flag strings */
  
  if (argc < 5)  {
    fprintf(stderr,
	    "\nUsage: aspirin <aspirin file> <C file> %s %s\n",
	    "-c <network compiler>",
	    "[<compiler flags>]");
    exit(1);
  }/* end if */
  
  
  /* am_alloc_mem vector for flags */
  flagv = (char *(*))am_alloc_mem((argc - 3) * sizeof(flagv));
  /* find aspirin flags and send other flags to the compiler */
  while (counter1 < argc)   { 
    if (strcmp(argv[counter1], "-c") == 0){
      if (strcmp(argv[counter1 + 1], "backprop") == 0)  {
	/* use backprop_compiler */
	function = backprop_generator;
      }/* end if */
      /* say what? */
      else  {
	fprintf(stderr, "\naspirin currently does not support %s\n", argv[4]);
	exit(1);
      }/* end else */
      /* jump passed argument */
      counter1++;
    }/* end if */
    /* load flags into flagv */
    else {
      flagv[flagc++] = argv[counter1];
    }/* end else */
    /* next */
    counter1++;
  }/* end while */
  
  
  if (function == (FUNC_PTR)NULL) {
    fprintf(stderr,
	    "You must supply a compiler name with -c.\n%s%s",
	    "Options:",
	    "\n\tbackprop");
    
    exit(1);
  } else {
    /* call the compiler */
    (*function)(parse(argv[1]), /* parse aspirin file => structure */
		argv[1],        /* name of aspirin file */
		argv[2],        /* name of files to create */
		flagc,          /* number of flags passed to compiler */
		flagv);         /* vector of flag strings */
  }/* end else */
  
  exit(0);
  
}
	
