
# This command file illustrates some features
# of the MIGRAINES user interface.

# This program extracts the weights of the xor network 
# for plotting them as a function of time.

# keep sure we're in the right place
poproot

echo         <<<<<<<< Use a ? to see available commands  >>>>>>>>
?

echo         <<<<<<<< Set all output pipes to NOT use a header  >>>>>>>>
pnoheader

echo         <<<<<<<< Set all output pipes to use ascii format >>>>>>>>
pascii

echo         <<<<<<<< Go into the xor black box context >>>>>>>>
push xor

echo         <<<<<<<< Go into the Output layer context >>>>>>>>
push xor:Output

echo         <<<<<<<< Open a pipe for the biases >>>>>>>>
popenBiases output.biases cat > output.biases.pdat

echo         <<<<<<<< Go into the input connections and open pipes >>>>>>>>
push xor:Hidden->xor:Output
popenWeights 0 0 output.weights1 cat > output.weights1.pdat
pop

push $INPUTS->xor:Output
popenWeights 0 0 output.weights2 cat > output.weights2.pdat
pop

pop

echo        <<<<<<<< Go into the Hidden layer context >>>>>>>>
push xor:Hidden

echo        <<<<<<<< Open a pipe for the biases >>>>>>>>
popenBiases hidden.biases cat > hidden.biases.pdat

echo        <<<<<<<< Go into the input connections for this layer and open pipes  >>>>>>>>

push $INPUTS->xor:Hidden
popenWeights 0 0 hidden.weights1 cat > hidden.weights1.pdat
pop

pop

echo         <<<<<<<< Let's see our output pipes   >>>>>>>>
pinfo

# Every time we load some weights, all of the pipes
# that connect to weight data will be updated.

# This is how you execute command files
source load.cmd

echo          <<<<<<<<    Close the pipes >>>>>>>>>>
pclose output.biases
pclose hidden.biases
pclose hidden.weights1
pclose output.weights1
pclose output.weights2

quit

