/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include "aspirin_bp.h"

#ifdef CRAY
# define NO_ATANH
#endif

#ifdef CONVEX
# define NO_ATANH
#endif

#ifdef HP9000
# define NO_ATANH
#endif

#ifdef MC860
# define NO_ATANH
#endif

float Sigmoid(x) /* [-0.5,0.5] */
     float x;
{
  return ( (1.0 / (1.0 + AM_EXP((double)-x))) - 0.5);
}

float SigmoidPrime(x)
     float x;
{
  x = Sigmoid(x);
  return ( 0.25 - (x * x));
}


float HyperbolicError (target, output, credit, nx, ny)
     register float *output, *target, *credit;
     register int nx, ny;
{
  float mag_squared = 0.0;

#ifdef NO_ATANH
  register int i;

  for(i=0;i<nx;i++) {
    credit[i] = target[i] - output[i];
    mag_squared += credit[i] * credit[i];
  }/* end for */

#else

  while(nx--) {
    float diff;

    diff = *target++ - *output++;
    mag_squared += diff * diff;
    if (diff > 0.9999999) *credit = 8.40562;
    else if (diff < -0.9999999) *credit = -8.40562;
    else  *credit = AM_ATANH((double)diff); 
    credit++;
  }/* end while */

#endif

  return( mag_squared / 2.0 );
}


void user_init()
{
  /* extern long time();

  int long seed;
  
  seed = time(0);
  printf("\nSeed: %ld", seed);
  spiral_set_random_init_seed(seed); */

  spiral_set_random_init_range(0.5);

  spiral_set_learning_rate(0.195); 
}
 
