/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
#include <stdio.h>

extern char *malloc();

/* the following are the features used in the output coding:

See Sejnowski & Rosenberg "Nettalk: A Parallel Network that Learns to
Read Aloud", TR JHU/EECS-86/01 for an easy to read table
of phonemes => features.

*/

#include "user.h"

#define bcopy(s1,s2,n) memcpy(s2,s1,n)
#define bzero(s,n) memset(s,0,n)

#define NTOKENS 29   /* # of types of letters */
#define WINDOWSIZE 7 /* # of letters */
#define NINPUTS (WINDOWSIZE * NTOKENS)

#define NOUTPUTS 26 /* # of features */

/* Position in mouth- */
#define   FRONT1() *(target_vector + 0) = 1.0
#define   LABIAL() *(target_vector + 0) = 1.0
#define   FRONT2() *(target_vector + 1) = 1.0
#define   DENTAL() *(target_vector + 1) = 1.0
#define   CENTRAL1() *(target_vector + 2) = 1.0
#define   ALVEOLAR() *(target_vector + 2) = 1.0
#define   CENTRAL2() *(target_vector + 3) = 1.0
#define   PALATAL() *(target_vector + 3) = 1.0
#define   BACK1() *(target_vector + 4) = 1.0
#define   VELAR() *(target_vector + 4) = 1.0
#define   BACK2() *(target_vector + 5) = 1.0
#define   GLOTTAL() *(target_vector + 5) = 1.0
/* Phonemetype- */
#define   STOP() *(target_vector + 6) = 1.0
#define   NASAL() *(target_vector + 7) = 1.0
#define   FRICATIVE() *(target_vector + 8) = 1.0
#define   AFFRICATIVE() *(target_vector + 9) = 1.0
#define   GLIDE() *(target_vector + 10) = 1.0
#define   LIQUID() *(target_vector + 11) = 1.0
#define   VOICED() *(target_vector + 12) = 1.0
#define   UNVOICED() *(target_vector + 12) = 0.0
#define   TENSED() *(target_vector + 13) = 1.0
/* Vowel Height- */
#define   HIGH() *(target_vector + 14) = 1.0
#define   MEDIUM() *(target_vector + 15) = 1.0
#define   LOW() *(target_vector + 16) = 1.0
/* Punctuation- */
#define   SILENT() *(target_vector + 17) = 1.0
#define   ELIDE() *(target_vector + 18) = 1.0
#define   PAUSE() *(target_vector + 19) = 1.0
#define   FULLSTOP() *(target_vector + 20) = 1.0

/*
Stress and Syllabel Boundries-
	'>'	indicates a consonant prior to a syllable nucleus.
	'<'	indicates a consonant or vowel following the first
		vowel of the syllable nucleus.
	'0'	indicates the first vowel in the nucleus of an unstressed
		syllable.
	'2'	indicates the first vowel in the nucleus of a syllable
		receiving secondary stress.
	'1'	indicates the first vowel in the nucleus of a syllable
		receiving primary stress.
*/
#define STRESS_A() *(target_vector + 21)=1.0
#define STRESS_B() *(target_vector + 22)=1.0
#define STRESS_C() *(target_vector + 23)=1.0
#define STRESS_D() *(target_vector + 24)=1.0
#define STRESS_E() *(target_vector + 25)=1.0
   

/* data (arrays of strings) */
static char *words[NPATTERNS], *phonemes[NPATTERNS], *stresses[NPATTERNS], lengths[NPATTERNS];

/* input & target buffers */
static float input_vector[ NINPUTS ], target_vector[ NOUTPUTS ];

static int pattern_counter = 0;
static int char_counter = -1;

static char *string_copy(s,n)
     char *s;
     int n;
{
  char *new;

  new = malloc(n);
  if (new == (char *)NULL) {
    fprintf(stderr, "\nOut of Memory...barf!\n");
    exit(1);
  }

  bcopy(s,new,n);
  return(new);
}

static void readdata()
{
  FILE *fp;
  register int counter = NPATTERNS;
  register int nsymbols = 0;
  char word[128],phoneme[128],stress[128],weird[128];

  printf("\nUsing datafile: %s", DATAFILE);

  fp = fopen(DATAFILE, "r");
  if (fp == (FILE *)NULL) {
    fprintf(stderr, "\nUnable to open %s!\n", DATAFILE);
    exit(1);
  }

  /* read the fields into strings */
  while(counter--) {
    fscanf(fp,"%s %s %s %s",
	   word, phoneme, stress, weird);
    lengths[counter] = strlen(word);
    nsymbols += lengths[counter];
    words[counter] = string_copy(word, lengths[counter]);
    phonemes[counter] = string_copy(phoneme, lengths[counter]);
    stresses[counter] = string_copy(stress, lengths[counter]);
  }/* end loop */

  printf("\nTotal number of positions: %d", nsymbols);

  fclose(fp);
}


static void set_letter(ptr, word_index, character, letter)
     float *ptr;
     int word_index, character, letter;
{
  int char_index;

  char_index = character + 3 - letter;
  if ( char_index >= 0 && char_index < lengths[word_index]) {
    char symbol;

    symbol = *(*(words + word_index) + char_index);
    switch(symbol) {/* maps symbol => input */
    case '.' :
      *(ptr + 26) = 1.0;
      break;
    case ',' :
      *(ptr + 27) = 1.0;
      break;
    case ' ' :
      *(ptr + 28) = 1.0;
      break;
    default:
      symbol -= 65;
      if (symbol > 27) symbol -= 32;
      *(ptr + symbol) = 1.0;
    }

  }/* end if */

}

static set_input(index, character)
     int index, character;
{
  register int counter = WINDOWSIZE;

  /* Clear */
  bzero((char *)input_vector, NINPUTS * sizeof(float)); 

  /* there are 7 input characters */
  while(counter--) {
    set_letter(input_vector + (counter * NTOKENS),
	       index,
	       character,
	       counter);
  }
}


static void set_target(word_index, character)
     int word_index, character;
{
  /* each phoneme has an associated unique output vector */

  /* clear */
  bzero((char *)target_vector, NOUTPUTS * sizeof(float));

  /* set features */
  switch( *(*(phonemes + word_index) + character) ) {
  case 'a' :
    LOW();
    TENSED();
    CENTRAL2();
    break;
  case 'b' :
    VOICED();
    LABIAL();
    STOP();
    break;
  case 'c' :
    MEDIUM();
    VELAR();
    break;
  case 'd' :
    VOICED();
    ALVEOLAR();
    STOP();
    break;
  case 'e' :
    MEDIUM();
    TENSED();
    FRONT2();
    break;
  case 'f' :
    UNVOICED();
    LABIAL();
    FRICATIVE();
    break;
  case 'g' :
    VOICED();
    VELAR();
    STOP();
    break;
  case 'h' :
    UNVOICED();
    GLOTTAL();
    GLIDE();
    break;
  case 'i' :
    HIGH();
    TENSED();
    FRONT1();
    break;
  case 'k' :
    UNVOICED();
    VELAR();
    STOP();
    break;
  case 'l' :
    VOICED();
    DENTAL();
    LIQUID();
    break;
  case 'm' :
    VOICED();
    LABIAL();
    NASAL();
    break;
  case 'n' :
    VOICED();
    ALVEOLAR();
    NASAL();
    break;
  case 'o' :
    MEDIUM();
    TENSED();
    BACK2();
    break;
  case 'p' :
    UNVOICED();
    LABIAL();
    STOP();
    break;
  case 'r' :
    VOICED();
    PALATAL();
    LIQUID();
    break;
  case 's' :
    UNVOICED();
    ALVEOLAR();
    FRICATIVE();
    break;
  case 't' :
    UNVOICED();
    ALVEOLAR();
    STOP();
    break;
  case 'u' :
    HIGH();
    TENSED();
    BACK2();
    break;
  case 'v' :
    VOICED();
    LABIAL();
    FRICATIVE();
    break;
  case 'w' :
    VOICED();
    LABIAL();
    GLIDE();
    break;
  case 'x' :
    MEDIUM();
    CENTRAL2();
    break;
  case 'y' :
    VOICED();
    PALATAL();
    GLIDE();
    break;
  case 'z' :
    VOICED();
    TENSED();
    FRICATIVE();
    break;
  case 'A' :
    MEDIUM();
    TENSED();
    FRONT2(); CENTRAL1();
    break;
  case 'C' :
    UNVOICED();
    PALATAL();
    AFFRICATIVE();
    break;
  case 'D' :
    VOICED();
    DENTAL();
    FRICATIVE();
    break;
  case 'E' :
    MEDIUM();
    FRONT1(); FRONT2();
    break;
  case 'G' :
    VOICED();
    VELAR();
    NASAL();
    break;
  case 'I' :
    HIGH();
    FRONT1();
    break;
  case 'J' :
    VOICED();
    VELAR();
    NASAL();
    break;
  case 'K' :
    UNVOICED();
    PALATAL();
    FRICATIVE(); VELAR();
    AFFRICATIVE();
    break;
  case 'L' :
    VOICED();
    ALVEOLAR();
    LIQUID();
    break;
  case 'M' :
    VOICED();
    DENTAL();
    NASAL();
    break;
  case 'N' :
    VOICED();
    PALATAL();
    NASAL();
    break;
  case 'O' :
    MEDIUM();
    TENSED();
    CENTRAL1(); CENTRAL2();
    break;
  case 'Q' :
    VOICED();
    LABIAL(); VELAR();
    AFFRICATIVE();
    STOP();
    break;
  case 'R' :
    VOICED();
    VELAR();
    LIQUID();
    break;
  case 'S' :
    UNVOICED();
    PALATAL();
    FRICATIVE();
    break;
  case 'T' :
    UNVOICED();
    DENTAL();
    FRICATIVE();
    break;
  case 'U' :
    HIGH();
    BACK1();
    break;
  case 'W' :
    HIGH(); MEDIUM();
    TENSED();
    CENTRAL2(); BACK1();
    break;
  case 'X' :
    UNVOICED();
    FRICATIVE();
    FRONT2(); CENTRAL1();
    break;
  case 'Y' :
    HIGH();
    TENSED();
    FRONT2(); CENTRAL1();
    break;
  case 'Z' :
    VOICED();
    PALATAL();
    FRICATIVE();
    break;
  case '@' :
    LOW();
    FRONT2();
    break;
  case '!' :
    UNVOICED();
    LABIAL(); DENTAL();
    AFFRICATIVE();
    break;
  case '#' :
    VOICED();
    PALATAL(); VELAR();
    AFFRICATIVE();
    break;
  case '*' :
    VOICED();
    GLIDE();
    FRONT1(); LOW(); 
    CENTRAL1();
    break;
  case '|' :
    HIGH();
    FRONT1(); FRONT2();
    break;
  case '^' :
    LOW();
    CENTRAL1();
    break;
  case '-' :
    SILENT();
    ELIDE();
    break;
  case '_' :
    PAUSE();
    ELIDE();
    break;
  case '.' :
    PAUSE();
    FULLSTOP();
    break;
    default : {
      fprintf(stderr,"\nUnknown phoneme: %c",
	      *(*(phonemes + word_index) + character));
      exit(1);
    }
  }
  
  /* set stress */
  switch( *(*(stresses + word_index) + character) ) {
  case '>' :
    STRESS_A();
    break;
  case '<' :
    STRESS_B();
    break;
  case '0' :
    STRESS_C();
    break;
  case '2' :
    STRESS_D();
    break;
  case '1' :
    STRESS_E();
    break;
  }

}


static void input_character()
{
  char_counter = (char_counter + 1) % lengths[pattern_counter];
  if (!char_counter)
    pattern_counter = (pattern_counter + 1) % NPATTERNS;

  set_input(pattern_counter, char_counter);
  set_target(pattern_counter, char_counter); 
  
}


void user_init()
{
/*  extern long time(); */

 readdata();   /* read in the data from DATAFILE */

 ntalk_set_learning_rate(0.05);
 ntalk_set_random_init_range(0.5);
/*  ntalk_set_random_init_seed(time(0)); */

 ntalk_set_input(input_vector);
 ntalk_set_target_output(target_vector);

 define_generator(input_character, (char *)NULL, "Input");

}
