
# This command file illustrates some features
# of the MIGRAINES user interface.

# This program saves the hidden layer vectors
# and weights for plotting

# This program assumes you have loaded the file encode.df


# Note: the '! sleep 1' statements seem only necessary on the
#       NeXT, where pclose is returning *before* the file is closed.

# keep sure we're in the right place
poproot

# Load the network
load Network.Finished

######### Output values of the hidden nodes for all inputs ######### 

# no header
pnoheader

# into the black box
push encoder

echo        <<<< Open pipe to file >>>>
push encoder:Hidden_Layer

# Get some values in the hidden nodes
cycle 1

# This opens a file and dumps the data...
popenNodes HiddenValues cat > hidden_values.pdat

# There are 7 more patterns, after each pattern
# all node value pipes are updated
cycle 7

echo        <<<< Close pipe >>>>
pclose HiddenValues

# sort it so using lines looks better
! mv hidden_values.pdat arf
! sort arf > hidden_values.pdat
! rm arf

# to the top
poproot

######### Output values of all weights ######### 

# header
pheader

# into the black box
push encoder

push encoder:Output_Layer

popenBiases W am2gnuplot > output.biases.pdat
pclose W

push encoder:Hidden_Layer->encoder:Output_Layer

popenWeights 0 0 W am2gnuplot > output.w0.pdat
pclose W

popenWeights 1 0 W am2gnuplot > output.w1.pdat
pclose W

popenWeights 2 0 W am2gnuplot > output.w2.pdat
pclose W

popenWeights 3 0 W am2gnuplot > output.w3.pdat
pclose W

popenWeights 4 0 W am2gnuplot > output.w4.pdat
pclose W

popenWeights 5 0 W am2gnuplot > output.w5.pdat
pclose W

popenWeights 6 0 W am2gnuplot > output.w6.pdat
pclose W

popenWeights 7 0 W am2gnuplot > output.w7.pdat
pclose W

# now make a 3d file
pnoheader

popenWeights 0 0 W cat > output.3d.pdat
pclose W
# avoid any snyc problems
! sleep 1

popenWeights 1 0 W cat >> output.3d.pdat
pclose W
# avoid any snyc problems
! sleep 1

popenWeights 2 0 W cat >> output.3d.pdat
pclose W
# avoid any snyc problems
! sleep 1

popenWeights 3 0 W cat >> output.3d.pdat
pclose W
# avoid any snyc problems
! sleep 1

popenWeights 4 0 W cat >> output.3d.pdat
pclose W
# avoid any snyc problems
! sleep 1

popenWeights 5 0 W cat >> output.3d.pdat
pclose W
# avoid any snyc problems
! sleep 1

popenWeights 6 0 W cat >> output.3d.pdat
pclose W
# avoid any snyc problems
! sleep 1

popenWeights 7 0 W cat >> output.3d.pdat
pclose W
# avoid any snyc problems
! sleep 1

# sort it so using lines looks better
! mv output.3d.pdat arf
! sort arf > output.3d.pdat
! rm arf


# done 3d
pheader


pop
pop

push encoder:Hidden_Layer

popenBiases W am2gnuplot > hidden.biases.pdat
pclose W

push $INPUTS->encoder:Hidden_Layer

popenWeights 0 0 W am2gnuplot > hidden.w0.pdat
pclose W

popenWeights 1 0 W am2gnuplot > hidden.w1.pdat
pclose W

popenWeights 2 0 W am2gnuplot > hidden.w2.pdat
pclose W


quit


