/* 

  ****************   NO WARRANTY  *****************

Since the Aspirin/MIGRAINES system is licensed free of charge,
the MITRE Corporation provides absolutley no warranty. Should
the Aspirin/MIGRAINES system prove defective, you must assume
the cost of all necessary servicing, repair or correction.
In no way will the MITRE Corporation be liable to you for
damages, including any lost profits, lost monies, or other
special, incidental or consequential damages arising out of
the use or inability to use the Aspirin/MIGRAINES system.

  *****************   COPYRIGHT  *******************

This software is the copyright of The MITRE Corporation. 
It may be freely used and modified for research and development
purposes. We require a brief acknowledgement in any research
paper or other publication where this software has made a significant
contribution. If you wish to use it for commercial gain you must contact 
The MITRE Corporation for conditions of use. The MITRE Corporation 
provides absolutely NO WARRANTY for this software.

   January, 1992 
   Russell Leighton
   The MITRE Corporation
   7525 Colshire Dr.
   McLean, Va. 22102-3481

*/
/* Detector demo:  Learn to detect a signal in noise. */

#include "detect.h"


#ifndef PADDING
# define PADDING 0
#endif

#define SIZE (100 + PADDING)

/* Globals */
static float snr = 1.0;
static float noise_target[1] = {0.0};
static float signal_target[1] = {1.0};
static float noise_variance = 1.0;
static float noise[SIZE];
static float signal[SIZE];


/*
 *   NormalRandom()    --  Uses the Box-Jenkins technique
 */
static int NRswitch = 0;
static float NR_u1, NR_u2;
static float NormalRandom(mean, variance)
     float mean, variance;
{
  if (NRswitch == 0) {
    while((NR_u1 = AM_RANDOM()) == 0.0);
    while((NR_u2 = AM_RANDOM()) == 0.0);
    NRswitch = 1;
    return( mean + AM_SQRT((double)(-2 * AM_LOG((double)NR_u1) * variance)) * AM_COS((double)(2 * AM_PI * NR_u2)) );
  } else {
    NRswitch = 0;
    return( mean + AM_SQRT((double)(-2 * AM_LOG((double)NR_u1) * variance)) * AM_SIN((double)(2 * AM_PI * NR_u2)) );
  }
}  /* end NormalRandom() */


/*=================================================*
    set_io_pattern: Set input and desired output.
 *=================================================*/
static set_io_pattern(index)
     int index;
{
  register float *ptr1, *ptr2;
  register int counter;

  /* do signal */
  if (index) {
    ptr1 = noise;
    ptr2 = signal;
    /* just add last noise to this signal */
    for(counter=0; counter<SIZE; counter++) {
      *ptr1++ += *ptr2++;
    }/* end for */
    /* set */
    detector_set_input(noise);
    detector_set_target_output(signal_target);
  }/* end if */
  /* do noise */
  else {
    /* gen new noise */
    ptr1 = noise;
    for(counter=0; counter<SIZE; counter++) {
      *ptr1++ = NormalRandom(0.0, noise_variance);
    }/* end for */
    /* set */
    detector_set_input(noise);
    detector_set_target_output(noise_target);
  }/* end else */
}/* end set_io_pattern */

static void gen_signal()
{
  set_io_pattern(1);
}/* end gen_signal */

static void gen_noise()
{
  set_io_pattern(0);
}/* end gen_noise */

static void generator()
{
  extern iterations;

  iterations = (iterations + 1) % 2;
  if (iterations)
    gen_signal();
  else
    gen_noise();
}

/*=================================================*
  init_signals:    Create signal and noise.
 *=================================================*/
static init_signals()
{
  register int counter;
  float signal_power = 0.0;

  /* create signal */
  for(counter=0; counter<SIZE; counter++) {
    signal[counter] = AM_SIN((double)counter*2*AM_PI*10.0/SIZE);
  }/* end for */

  /* calc power */
  for(counter=0; counter<SIZE; counter++) {
    signal_power += signal[counter] * signal[counter];
  }/* end for */
  
  /* create noise */
  noise_variance = signal_power / (snr * SIZE);
  for(counter=0; counter<SIZE; counter++) {
    noise[counter] = NormalRandom(0.0, noise_variance);
  }/* end for */

}/* end init_signals */


/*******************************************************************************/
/*******************************************************************************/
/*******************************************************************************/
/*************        This is the function that is exported!!   ****************/
/*******************************************************************************/
/*******************************************************************************/
/*******************************************************************************/

int iterations = 0;       /* this is used by the generator to set patterns */

/*=================================================*
 * initialize:  Init.
 *=================================================*/
user_init()
{
  extern void define_generator();  /* from Backprop.c */

  /* get snr from user (UNCOMMENT) */
  /* printf("\nPlease input SNR: ");
  scanf("%f", &snr); */

  snr = 10.0;
  printf("\nUsing SNR = %f", snr);

  /* initialize data */
  init_signals();

  detect_set_learning_rate(0.99);

  define_generator(gen_signal, (char *)NULL, "Signal");
  define_generator(gen_noise, (char *)NULL, "Noise");


}/* end initialize */
