;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Records.lisp
;;
;;  Copyright (c) 1990, Apple Computer, Inc.  All rights reserved.
;;
;;  This file contains definitions for Pascal style record structures, used
;;  for interfacing with the Macintosh operating system.
;;
;;  Definitions for records used by color quickdraw can be found in the
;;  file Color-Examples.lisp.
;;
;;  Other record definitions can be found in Inside Macintosh.
;;
;;

(in-package :ccl)

; joe  12/26/90   Wrapped (let ((*autoload-traps* nil)) 'round the whole mess...
; bill 09/20/90   (PixMap :handle) -> (:handle pixmap)
; joe  08/28/90   Changed format of pointer to records to (:pointer <record-name>)
; joe  07/06/90   Removed defaults, added array variants where appropriate
; bill 05/05/90   Add TextStyle & ScrapStuff
; bill 01/26/90   Fixed pixmap component names.
; bill 03-Nov-89  Added gDevice record.
;  as  03-mar-89  some color records

(let ((*autoload-traps* nil))

(defrecord Rect 
  (variant ((top integer)
            (left integer))
           ((topleft point)))
  (variant ((bottom integer)
            (right integer))
           ((bottomright point))
	   ((botright point))))

(defrecord bitMap 
  (baseAddr pointer) 
  (rowBytes integer) 
  (bounds rect))

(defrecord Bits16 
  (L0 longint) 
  (L1 longint) 
  (L2 longint) 
  (L3 longint)
  (L4 longint) 
  (L5 longint)
  (L6 longint) 
  (L7 longint))

(defrecord (control :handle)
  (nextControl (handle control))
  (Owner (:pointer window))
  (rect rect)
  (Vis boolean)
  (Hilite byte)
  (Value integer)
  (Min integer)
  (Max integer)
  (DefProc handle)
  (Data handle)
  (Action pointer)
  (RfCon longint)
  (Title (string 255)))

(defrecord Cursor 
  (data Bits16) 
  (mask Bits16) 
  (hotSpot point))

(defrecord Event
  (what integer)
  (message longint)
  (when longint)
  (where point)
  (modifiers integer))

(defrecord FontInfo
  (ascent integer) 
  (descent integer) 
  (widMax integer) 
  (leading integer))

(defrecord pattern 
  (variant ((w0 integer)
            (w1 integer)
            (w2 integer)
            (w3 integer))
           ((b0 byte)
            (b1 byte)
            (b2 byte)
            (b3 byte)
            (b4 byte)
            (b5 byte)
            (b6 byte)
            (b7 byte))
           ((bytes (array byte 8)))))

(defrecord grafport
  (device integer)
  (portbits BitMap)
  (portRect rect)
  (visRgn (handle region))
  (clipRgn (handle region))
  (bkPat pattern)
  (fillPat pattern)
  (pnLoc point)
  (pnSize point)
  (pnMode integer)
  (pnPat pattern)
  (pnVis integer)
  (txFont integer)
  (txFace integer)
  (txMode integer)
  (txSize integer)
  (spExtra longint)  ;beware old Inside Macintosh says 2 bytes.
  (fgColor longint)
  (bkcolor longint)
  (colrBit integer)
  (patStretch integer)
  (picSave handle)
  (rgnSave handle)
  (polySave handle)
  (grafProcs pointer))

(defrecord window 
  (port grafport)
  (windowKind integer)
  (visible boolean)
  (hilited boolean)
  (goAwayFlag boolean)
  (spareFlag boolean)
  (strucRgn (handle region))
  (contRgn (handle region))
  (updateRgn (handle region))
  (windowDefProc handle)
  (dataHandle handle)
  (titleHandle handle)
  (titleWidth integer)
  (controlList (handle control))
  (nextWindow (pointer window))
  (windowPic handle)
  (refCon longint))

(defrecord dialog
  (window window)
  (items handle)
  (textH (:handle TERec))
  (editField integer)
  (editOpen integer)
  (aDefItem integer))

(defrecord dialog-item
  (variant ((hCtl handle)) ((hText handle)) ((hProc handle)))
  (rect rect)
  (type byte)
  (datasize byte)
  (data integer))

(defrecord (list :handle)
  (rView rect)
  (port pointer)
  (indent point)
  (cellsize point)
  (visible rect)
  (vscroll handle)
  (hscroll handle)
  (selFlags byte)
  (lActive boolean)
  (lreserved byte)
  (listFlags byte)
  (clikTime longint)
  (clikLoc point)
  (mouseloc point)
  (lClikLoop pointer)
  (lastclick point)
  (refcon longint)
  (listDefProc handle)
  (userhandle handle)
  (dataBounds rect)
  (cells Handle)
  (maxIndex integer)
  (cellarray integer))

(defrecord PenState 
  (pnLoc point)
  (pnSize point) 
  (pnMode integer)
  (pnPat pattern))

(defrecord (Picture :handle) 
  (picSize integer)
  (picFrame Rect))

(defrecord (Polygon :handle)
  (polySize integer) 
  (polyBox Rect))

(defrecord regbuf
  (rD0 pointer)
  (rD1 pointer)
  (rD2 pointer)
  (rD3 pointer)
  (rD4 pointer)
  (rD5 pointer)
  (rD6 pointer)
  (rD7 pointer)
  (rA0 pointer)
  (rA1 pointer)
  (rA2 pointer)
  (rA3 pointer)
  (rA4 pointer)
  (rA5 pointer)
  (rA6 pointer)
  (rA7 pointer)
  (rSR integer))

(defrecord (Region :handle)
  (rgnSize integer) 
  (rgnBBox Rect))

(defrecord SFReply
  (good boolean)
  (copy boolean)
  (fType OSType)
  (vRefNum integer)
  (version integer)
  (fName (string 63)))

(defrecord (TERec :handle)
  (destRect rect)
  (viewRect rect)
  (selRect rect)
  (lineHeight integer)
  (fontAscent integer)
  (selPoint point)
  (selStart integer)
  (selEnd integer)
  (active integer)
  (wordBreak pointer)
  (clikLoop pointer)
  (clickTime longint)
  (clickLoc integer)
  (caretTime longint)
  (caretState integer)
  (just integer)
  (teLength integer)
  (hText handle)
  (recalBack integer)
  (recalLines integer)
  (clikStuff integer)
  (crOnly integer)
  (txFont integer)
  (txFace integer)
  (txMode integer)
  (txSize integer)
  (inPort (:pointer grafport))
  (highHook pointer)
  (caretHook pointer)
  (nLines integer)
  (lineStarts LongInt))

(defrecord SysEnv			;Version 1 SysEnv record
  (environsVersion integer)
  (machineType integer)
  (systemVersion integer)
  (processor integer)
  (hasFPU byte)
  (hasColorQD byte)
  (keyBoardType integer)
  (atDrvrVersNum integer)
  (sysVRefNum integer))

(defrecord RGBColor
  (red :unsigned-integer)
  (green :unsigned-integer)
  (blue :unsigned-integer))

(defrecord ColorSpec
  (value :integer)
  (rgb :RGBColor))

(defrecord (ColorTable :handle)
  (ctSeed :longint)
  (transIndex :integer)
  (ctSize :integer)
  (ctTable :colorSpec))

(defrecord (PixMap :handle)
  (baseAddr :pointer)
  (rowBytes :integer)
  (bounds :rect)
  (pmVersion :integer)
  (packType :integer)
  (packSize :longint)
  (hRes :longint)
  (vRes :longint)
  (pixelType :integer)
  (pixelSize :integer)
  (cmpCount :integer)
  (cmpSize :integer)
  (planeBytes :longint)
  (pmTable :handle)
  (pmReserved :longint))

(defrecord CGrafPort
  (device :integer)
  (portPixMap :handle)
  (portVersion :integer)
  (grafVars :handle)
  (chExtra :integer)
  (plLocHFrac :integer)
  (portRect :rect)
  (visRgn (handle :region))
  (clipRgn (handle :region))
  (bkPixPat :handle)
  (rgbFgColor :RGBColor)
  (rgbBkColor :RGBColor)
  (pnLoc point)
  (pnSize point)
  (pnMode integer)
  (pnPixPat :handle)
  (fillPixPat :handle)
  (pnVis integer)
  (txFont integer)
  (txFace integer)
  (txMode integer)
  (txSize integer)
  (spExtra longint)
  (fgColor longint)
  (bkcolor longint)
  (colrBit integer)
  (patStretch integer)
  (picSave handle)
  (rgnSave handle)
  (polySave handle)
  (grafProcs pointer))

(defrecord (gDevice :handle)
  (gdRefNum :integer)
  (gdID :integer)
  (gdType :integer)
  (gdITable :handle)                    ; really ITabHandle
  (gdResPref :integer)
  (gdSearchProc :handle)                ; really SProcHndl
  (gdCompProc :handle)                  ; really CProcHndl
  (gdFlags :integer)
  (gdPMap (:handle PixMap))
  (gdRefCon :longint)
  (gdNextGD (:handle gDevice))
  (gdRect :rect)
  (gdMode :longint)
  (gdCCButes :integer)
  (gfCCDepth :integer)
  (gdCCXData :handle)
  (gdCCXMask :handle)
  (gdReserved :longint))


(defrecord (AuxCtlRec :handle)
  (acNext :handle)
  (acOwner :handle)
  (acCTable :handle)
  (acFlags :integer)
  (acReserved :longint)
  (acRefCon :longint))

(defrecord (AuxWinRec :handle)
  (awNext :handle)
  (awOwner :pointer)
  (awCTable :handle)
  (dialogCItem :handle)
  (awFlags :longint)
  (awReserved :handle)
  (awRefCon :longint))

(defrecord (MCEntryPtr :pointer)
  (mctID :integer)
  (mctItem :integer)
  (mctRGB1 :rgbcolor)
  (mctRGB2 :rgbcolor)
  (mctRGB3 :rgbcolor)
  (mctRGB4 :rgbcolor)
  (mctReserved :integer))

(defrecord (TextStyle :pointer)
  (tsFont :integer)
  (tsFace :integer)
  (tsSize :integer)
  (tsColor :RGBColor))

(defrecord (ScrapStuff :pointer)
  (scrapSize :longint)
  (scrapHandle :handle)
  (scrapCount :integer)
  (scrapState :integer)
  (scrapName :pointer))

)
(provide 'records)
